/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.DeliveryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigStreamDeliveryInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigStreamDeliveryInfo> {
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastStatus").getter(ConfigStreamDeliveryInfo.getter(ConfigStreamDeliveryInfo::lastStatusAsString)).setter(ConfigStreamDeliveryInfo.setter(Builder::lastStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()}).build();
    private static final SdkField<String> LAST_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastErrorCode").getter(ConfigStreamDeliveryInfo.getter(ConfigStreamDeliveryInfo::lastErrorCode)).setter(ConfigStreamDeliveryInfo.setter(Builder::lastErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorCode").build()}).build();
    private static final SdkField<String> LAST_ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastErrorMessage").getter(ConfigStreamDeliveryInfo.getter(ConfigStreamDeliveryInfo::lastErrorMessage)).setter(ConfigStreamDeliveryInfo.setter(Builder::lastErrorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastErrorMessage").build()}).build();
    private static final SdkField<Instant> LAST_STATUS_CHANGE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStatusChangeTime").getter(ConfigStreamDeliveryInfo.getter(ConfigStreamDeliveryInfo::lastStatusChangeTime)).setter(ConfigStreamDeliveryInfo.setter(Builder::lastStatusChangeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChangeTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_STATUS_FIELD, LAST_ERROR_CODE_FIELD, LAST_ERROR_MESSAGE_FIELD, LAST_STATUS_CHANGE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lastStatus;
    private final String lastErrorCode;
    private final String lastErrorMessage;
    private final Instant lastStatusChangeTime;

    private ConfigStreamDeliveryInfo(BuilderImpl builder) {
        this.lastStatus = builder.lastStatus;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.lastStatusChangeTime = builder.lastStatusChangeTime;
    }

    public DeliveryStatus lastStatus() {
        return DeliveryStatus.fromValue(this.lastStatus);
    }

    public String lastStatusAsString() {
        return this.lastStatus;
    }

    public String lastErrorCode() {
        return this.lastErrorCode;
    }

    public String lastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Instant lastStatusChangeTime() {
        return this.lastStatusChangeTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusChangeTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigStreamDeliveryInfo)) {
            return false;
        }
        ConfigStreamDeliveryInfo other = (ConfigStreamDeliveryInfo)obj;
        return Objects.equals(this.lastStatusAsString(), other.lastStatusAsString()) && Objects.equals(this.lastErrorCode(), other.lastErrorCode()) && Objects.equals(this.lastErrorMessage(), other.lastErrorMessage()) && Objects.equals(this.lastStatusChangeTime(), other.lastStatusChangeTime());
    }

    public String toString() {
        return ToString.builder((String)"ConfigStreamDeliveryInfo").add("LastStatus", (Object)this.lastStatusAsString()).add("LastErrorCode", (Object)this.lastErrorCode()).add("LastErrorMessage", (Object)this.lastErrorMessage()).add("LastStatusChangeTime", (Object)this.lastStatusChangeTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatusAsString()));
            }
            case "lastErrorCode": {
                return Optional.ofNullable(clazz.cast(this.lastErrorCode()));
            }
            case "lastErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.lastErrorMessage()));
            }
            case "lastStatusChangeTime": {
                return Optional.ofNullable(clazz.cast(this.lastStatusChangeTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigStreamDeliveryInfo, T> g) {
        return obj -> g.apply((ConfigStreamDeliveryInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lastStatus;
        private String lastErrorCode;
        private String lastErrorMessage;
        private Instant lastStatusChangeTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigStreamDeliveryInfo model) {
            this.lastStatus(model.lastStatus);
            this.lastErrorCode(model.lastErrorCode);
            this.lastErrorMessage(model.lastErrorMessage);
            this.lastStatusChangeTime(model.lastStatusChangeTime);
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(DeliveryStatus lastStatus) {
            this.lastStatus(lastStatus == null ? null : lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getLastErrorCode() {
            return this.lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public final Instant getLastStatusChangeTime() {
            return this.lastStatusChangeTime;
        }

        @Override
        public final Builder lastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
            return this;
        }

        public final void setLastStatusChangeTime(Instant lastStatusChangeTime) {
            this.lastStatusChangeTime = lastStatusChangeTime;
        }

        public ConfigStreamDeliveryInfo build() {
            return new ConfigStreamDeliveryInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigStreamDeliveryInfo> {
        public Builder lastStatus(String var1);

        public Builder lastStatus(DeliveryStatus var1);

        public Builder lastErrorCode(String var1);

        public Builder lastErrorMessage(String var1);

        public Builder lastStatusChangeTime(Instant var1);
    }
}

