/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.ExcludedAccountsCopier;
import software.amazon.awssdk.services.config.model.OrganizationCustomRuleMetadata;
import software.amazon.awssdk.services.config.model.OrganizationManagedRuleMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutOrganizationConfigRuleRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutOrganizationConfigRuleRequest> {
    private static final SdkField<String> ORGANIZATION_CONFIG_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationConfigRuleName").getter(PutOrganizationConfigRuleRequest.getter(PutOrganizationConfigRuleRequest::organizationConfigRuleName)).setter(PutOrganizationConfigRuleRequest.setter(Builder::organizationConfigRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleName").build()}).build();
    private static final SdkField<OrganizationManagedRuleMetadata> ORGANIZATION_MANAGED_RULE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationManagedRuleMetadata").getter(PutOrganizationConfigRuleRequest.getter(PutOrganizationConfigRuleRequest::organizationManagedRuleMetadata)).setter(PutOrganizationConfigRuleRequest.setter(Builder::organizationManagedRuleMetadata)).constructor(OrganizationManagedRuleMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationManagedRuleMetadata").build()}).build();
    private static final SdkField<OrganizationCustomRuleMetadata> ORGANIZATION_CUSTOM_RULE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationCustomRuleMetadata").getter(PutOrganizationConfigRuleRequest.getter(PutOrganizationConfigRuleRequest::organizationCustomRuleMetadata)).setter(PutOrganizationConfigRuleRequest.setter(Builder::organizationCustomRuleMetadata)).constructor(OrganizationCustomRuleMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationCustomRuleMetadata").build()}).build();
    private static final SdkField<List<String>> EXCLUDED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedAccounts").getter(PutOrganizationConfigRuleRequest.getter(PutOrganizationConfigRuleRequest::excludedAccounts)).setter(PutOrganizationConfigRuleRequest.setter(Builder::excludedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFIG_RULE_NAME_FIELD, ORGANIZATION_MANAGED_RULE_METADATA_FIELD, ORGANIZATION_CUSTOM_RULE_METADATA_FIELD, EXCLUDED_ACCOUNTS_FIELD));
    private final String organizationConfigRuleName;
    private final OrganizationManagedRuleMetadata organizationManagedRuleMetadata;
    private final OrganizationCustomRuleMetadata organizationCustomRuleMetadata;
    private final List<String> excludedAccounts;

    private PutOrganizationConfigRuleRequest(BuilderImpl builder) {
        super(builder);
        this.organizationConfigRuleName = builder.organizationConfigRuleName;
        this.organizationManagedRuleMetadata = builder.organizationManagedRuleMetadata;
        this.organizationCustomRuleMetadata = builder.organizationCustomRuleMetadata;
        this.excludedAccounts = builder.excludedAccounts;
    }

    public String organizationConfigRuleName() {
        return this.organizationConfigRuleName;
    }

    public OrganizationManagedRuleMetadata organizationManagedRuleMetadata() {
        return this.organizationManagedRuleMetadata;
    }

    public OrganizationCustomRuleMetadata organizationCustomRuleMetadata() {
        return this.organizationCustomRuleMetadata;
    }

    public boolean hasExcludedAccounts() {
        return this.excludedAccounts != null && !(this.excludedAccounts instanceof SdkAutoConstructList);
    }

    public List<String> excludedAccounts() {
        return this.excludedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationConfigRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationManagedRuleMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationCustomRuleMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludedAccounts());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutOrganizationConfigRuleRequest)) {
            return false;
        }
        PutOrganizationConfigRuleRequest other = (PutOrganizationConfigRuleRequest)((Object)obj);
        return Objects.equals(this.organizationConfigRuleName(), other.organizationConfigRuleName()) && Objects.equals(this.organizationManagedRuleMetadata(), other.organizationManagedRuleMetadata()) && Objects.equals(this.organizationCustomRuleMetadata(), other.organizationCustomRuleMetadata()) && Objects.equals(this.excludedAccounts(), other.excludedAccounts());
    }

    public String toString() {
        return ToString.builder((String)"PutOrganizationConfigRuleRequest").add("OrganizationConfigRuleName", (Object)this.organizationConfigRuleName()).add("OrganizationManagedRuleMetadata", (Object)this.organizationManagedRuleMetadata()).add("OrganizationCustomRuleMetadata", (Object)this.organizationCustomRuleMetadata()).add("ExcludedAccounts", this.excludedAccounts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConfigRuleName": {
                return Optional.ofNullable(clazz.cast(this.organizationConfigRuleName()));
            }
            case "OrganizationManagedRuleMetadata": {
                return Optional.ofNullable(clazz.cast(this.organizationManagedRuleMetadata()));
            }
            case "OrganizationCustomRuleMetadata": {
                return Optional.ofNullable(clazz.cast(this.organizationCustomRuleMetadata()));
            }
            case "ExcludedAccounts": {
                return Optional.ofNullable(clazz.cast(this.excludedAccounts()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutOrganizationConfigRuleRequest, T> g) {
        return obj -> g.apply((PutOrganizationConfigRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String organizationConfigRuleName;
        private OrganizationManagedRuleMetadata organizationManagedRuleMetadata;
        private OrganizationCustomRuleMetadata organizationCustomRuleMetadata;
        private List<String> excludedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutOrganizationConfigRuleRequest model) {
            super(model);
            this.organizationConfigRuleName(model.organizationConfigRuleName);
            this.organizationManagedRuleMetadata(model.organizationManagedRuleMetadata);
            this.organizationCustomRuleMetadata(model.organizationCustomRuleMetadata);
            this.excludedAccounts(model.excludedAccounts);
        }

        public final String getOrganizationConfigRuleName() {
            return this.organizationConfigRuleName;
        }

        @Override
        public final Builder organizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
            return this;
        }

        public final void setOrganizationConfigRuleName(String organizationConfigRuleName) {
            this.organizationConfigRuleName = organizationConfigRuleName;
        }

        public final OrganizationManagedRuleMetadata.Builder getOrganizationManagedRuleMetadata() {
            return this.organizationManagedRuleMetadata != null ? this.organizationManagedRuleMetadata.toBuilder() : null;
        }

        @Override
        public final Builder organizationManagedRuleMetadata(OrganizationManagedRuleMetadata organizationManagedRuleMetadata) {
            this.organizationManagedRuleMetadata = organizationManagedRuleMetadata;
            return this;
        }

        public final void setOrganizationManagedRuleMetadata(OrganizationManagedRuleMetadata.BuilderImpl organizationManagedRuleMetadata) {
            this.organizationManagedRuleMetadata = organizationManagedRuleMetadata != null ? organizationManagedRuleMetadata.build() : null;
        }

        public final OrganizationCustomRuleMetadata.Builder getOrganizationCustomRuleMetadata() {
            return this.organizationCustomRuleMetadata != null ? this.organizationCustomRuleMetadata.toBuilder() : null;
        }

        @Override
        public final Builder organizationCustomRuleMetadata(OrganizationCustomRuleMetadata organizationCustomRuleMetadata) {
            this.organizationCustomRuleMetadata = organizationCustomRuleMetadata;
            return this;
        }

        public final void setOrganizationCustomRuleMetadata(OrganizationCustomRuleMetadata.BuilderImpl organizationCustomRuleMetadata) {
            this.organizationCustomRuleMetadata = organizationCustomRuleMetadata != null ? organizationCustomRuleMetadata.build() : null;
        }

        public final Collection<String> getExcludedAccounts() {
            return this.excludedAccounts;
        }

        @Override
        public final Builder excludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedAccounts(String ... excludedAccounts) {
            this.excludedAccounts(Arrays.asList(excludedAccounts));
            return this;
        }

        public final void setExcludedAccounts(Collection<String> excludedAccounts) {
            this.excludedAccounts = ExcludedAccountsCopier.copy(excludedAccounts);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutOrganizationConfigRuleRequest build() {
            return new PutOrganizationConfigRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutOrganizationConfigRuleRequest> {
        public Builder organizationConfigRuleName(String var1);

        public Builder organizationManagedRuleMetadata(OrganizationManagedRuleMetadata var1);

        default public Builder organizationManagedRuleMetadata(Consumer<OrganizationManagedRuleMetadata.Builder> organizationManagedRuleMetadata) {
            return this.organizationManagedRuleMetadata((OrganizationManagedRuleMetadata)((OrganizationManagedRuleMetadata.Builder)OrganizationManagedRuleMetadata.builder().applyMutation(organizationManagedRuleMetadata)).build());
        }

        public Builder organizationCustomRuleMetadata(OrganizationCustomRuleMetadata var1);

        default public Builder organizationCustomRuleMetadata(Consumer<OrganizationCustomRuleMetadata.Builder> organizationCustomRuleMetadata) {
            return this.organizationCustomRuleMetadata((OrganizationCustomRuleMetadata)((OrganizationCustomRuleMetadata.Builder)OrganizationCustomRuleMetadata.builder().applyMutation(organizationCustomRuleMetadata)).build());
        }

        public Builder excludedAccounts(Collection<String> var1);

        public Builder excludedAccounts(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

