/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.ConfigurationItem;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;

public class GetResourceConfigHistoryIterable
implements SdkIterable<GetResourceConfigHistoryResponse> {
    private final ConfigClient client;
    private final GetResourceConfigHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourceConfigHistoryIterable(ConfigClient client, GetResourceConfigHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetResourceConfigHistoryResponseFetcher();
    }

    public Iterator<GetResourceConfigHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationItem> configurationItems() {
        Function<GetResourceConfigHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationItems() != null) {
                return response.configurationItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetResourceConfigHistoryResponseFetcher
    implements SyncPageFetcher<GetResourceConfigHistoryResponse> {
        private GetResourceConfigHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceConfigHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetResourceConfigHistoryResponse nextPage(GetResourceConfigHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetResourceConfigHistoryIterable.this.client.getResourceConfigHistory(GetResourceConfigHistoryIterable.this.firstRequest);
            }
            return GetResourceConfigHistoryIterable.this.client.getResourceConfigHistory((GetResourceConfigHistoryRequest)((Object)GetResourceConfigHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

