/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ConfigurationItemStatus {
    OK("OK"),
    RESOURCE_DISCOVERED("ResourceDiscovered"),
    RESOURCE_NOT_RECORDED("ResourceNotRecorded"),
    RESOURCE_DELETED("ResourceDeleted"),
    RESOURCE_DELETED_NOT_RECORDED("ResourceDeletedNotRecorded"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ConfigurationItemStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationItemStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ConfigurationItemStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationItemStatus> knownValues() {
        return Stream.of(ConfigurationItemStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

