/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationRecorderStatusResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationRecorderStatusResponse> {
    private static final SdkField<List<ConfigurationRecorderStatus>> CONFIGURATION_RECORDERS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeConfigurationRecorderStatusResponse.getter(DescribeConfigurationRecorderStatusResponse::configurationRecordersStatus)).setter(DescribeConfigurationRecorderStatusResponse.setter(Builder::configurationRecordersStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRecordersStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationRecorderStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_RECORDERS_STATUS_FIELD));
    private final List<ConfigurationRecorderStatus> configurationRecordersStatus;

    private DescribeConfigurationRecorderStatusResponse(BuilderImpl builder) {
        super(builder);
        this.configurationRecordersStatus = builder.configurationRecordersStatus;
    }

    public boolean hasConfigurationRecordersStatus() {
        return this.configurationRecordersStatus != null && !(this.configurationRecordersStatus instanceof SdkAutoConstructList);
    }

    public List<ConfigurationRecorderStatus> configurationRecordersStatus() {
        return this.configurationRecordersStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationRecordersStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecorderStatusResponse)) {
            return false;
        }
        DescribeConfigurationRecorderStatusResponse other = (DescribeConfigurationRecorderStatusResponse)((Object)obj);
        return Objects.equals(this.configurationRecordersStatus(), other.configurationRecordersStatus());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationRecorderStatusResponse").add("ConfigurationRecordersStatus", this.configurationRecordersStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationRecordersStatus": {
                return Optional.ofNullable(clazz.cast(this.configurationRecordersStatus()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationRecorderStatusResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationRecorderStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationRecorderStatus> configurationRecordersStatus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecorderStatusResponse model) {
            super(model);
            this.configurationRecordersStatus(model.configurationRecordersStatus);
        }

        public final Collection<ConfigurationRecorderStatus.Builder> getConfigurationRecordersStatus() {
            return this.configurationRecordersStatus != null ? (Collection)this.configurationRecordersStatus.stream().map(ConfigurationRecorderStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationRecordersStatus(Collection<ConfigurationRecorderStatus> configurationRecordersStatus) {
            this.configurationRecordersStatus = ConfigurationRecorderStatusListCopier.copy(configurationRecordersStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecordersStatus(ConfigurationRecorderStatus ... configurationRecordersStatus) {
            this.configurationRecordersStatus(Arrays.asList(configurationRecordersStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecordersStatus(Consumer<ConfigurationRecorderStatus.Builder> ... configurationRecordersStatus) {
            this.configurationRecordersStatus(Stream.of(configurationRecordersStatus).map(c -> (ConfigurationRecorderStatus)((ConfigurationRecorderStatus.Builder)ConfigurationRecorderStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationRecordersStatus(Collection<ConfigurationRecorderStatus.BuilderImpl> configurationRecordersStatus) {
            this.configurationRecordersStatus = ConfigurationRecorderStatusListCopier.copyFromBuilder(configurationRecordersStatus);
        }

        @Override
        public DescribeConfigurationRecorderStatusResponse build() {
            return new DescribeConfigurationRecorderStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationRecorderStatusResponse> {
        public Builder configurationRecordersStatus(Collection<ConfigurationRecorderStatus> var1);

        public Builder configurationRecordersStatus(ConfigurationRecorderStatus ... var1);

        public Builder configurationRecordersStatus(Consumer<ConfigurationRecorderStatus.Builder> ... var1);
    }
}

