/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConformancePackComplianceResourceIdsCopier;
import software.amazon.awssdk.services.config.model.ConformancePackComplianceType;
import software.amazon.awssdk.services.config.model.ConformancePackConfigRuleNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConformancePackEvaluationFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConformancePackEvaluationFilters> {
    private static final SdkField<List<String>> CONFIG_RULE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ConformancePackEvaluationFilters.getter(ConformancePackEvaluationFilters::configRuleNames)).setter(ConformancePackEvaluationFilters.setter(Builder::configRuleNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConformancePackEvaluationFilters.getter(ConformancePackEvaluationFilters::complianceTypeAsString)).setter(ConformancePackEvaluationFilters.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConformancePackEvaluationFilters.getter(ConformancePackEvaluationFilters::resourceType)).setter(ConformancePackEvaluationFilters.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ConformancePackEvaluationFilters.getter(ConformancePackEvaluationFilters::resourceIds)).setter(ConformancePackEvaluationFilters.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAMES_FIELD, COMPLIANCE_TYPE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> configRuleNames;
    private final String complianceType;
    private final String resourceType;
    private final List<String> resourceIds;

    private ConformancePackEvaluationFilters(BuilderImpl builder) {
        this.configRuleNames = builder.configRuleNames;
        this.complianceType = builder.complianceType;
        this.resourceType = builder.resourceType;
        this.resourceIds = builder.resourceIds;
    }

    public boolean hasConfigRuleNames() {
        return this.configRuleNames != null && !(this.configRuleNames instanceof SdkAutoConstructList);
    }

    public List<String> configRuleNames() {
        return this.configRuleNames;
    }

    public ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(this.complianceType);
    }

    public String complianceTypeAsString() {
        return this.complianceType;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public List<String> resourceIds() {
        return this.resourceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackEvaluationFilters)) {
            return false;
        }
        ConformancePackEvaluationFilters other = (ConformancePackEvaluationFilters)obj;
        return Objects.equals(this.configRuleNames(), other.configRuleNames()) && Objects.equals(this.complianceTypeAsString(), other.complianceTypeAsString()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceIds(), other.resourceIds());
    }

    public String toString() {
        return ToString.builder((String)"ConformancePackEvaluationFilters").add("ConfigRuleNames", this.configRuleNames()).add("ComplianceType", (Object)this.complianceTypeAsString()).add("ResourceType", (Object)this.resourceType()).add("ResourceIds", this.resourceIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleNames": {
                return Optional.ofNullable(clazz.cast(this.configRuleNames()));
            }
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceTypeAsString()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackEvaluationFilters, T> g) {
        return obj -> g.apply((ConformancePackEvaluationFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> configRuleNames = DefaultSdkAutoConstructList.getInstance();
        private String complianceType;
        private String resourceType;
        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackEvaluationFilters model) {
            this.configRuleNames(model.configRuleNames);
            this.complianceType(model.complianceType);
            this.resourceType(model.resourceType);
            this.resourceIds(model.resourceIds);
        }

        public final Collection<String> getConfigRuleNames() {
            return this.configRuleNames;
        }

        @Override
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConformancePackConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRuleNames(String ... configRuleNames) {
            this.configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConformancePackConfigRuleNamesCopier.copy(configRuleNames);
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getResourceIds() {
            return this.resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ConformancePackComplianceResourceIdsCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ConformancePackComplianceResourceIdsCopier.copy(resourceIds);
        }

        public ConformancePackEvaluationFilters build() {
            return new ConformancePackEvaluationFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConformancePackEvaluationFilters> {
        public Builder configRuleNames(Collection<String> var1);

        public Builder configRuleNames(String ... var1);

        public Builder complianceType(String var1);

        public Builder complianceType(ConformancePackComplianceType var1);

        public Builder resourceType(String var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);
    }
}

