/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.AggregatedSourceStatusType;
import software.amazon.awssdk.services.config.model.AggregatedSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregatedSourceStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregatedSourceStatus> {
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AggregatedSourceStatus.getter(AggregatedSourceStatus::sourceId)).setter(AggregatedSourceStatus.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AggregatedSourceStatus.getter(AggregatedSourceStatus::sourceTypeAsString)).setter(AggregatedSourceStatus.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AggregatedSourceStatus.getter(AggregatedSourceStatus::awsRegion)).setter(AggregatedSourceStatus.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()}).build();
    private static final SdkField<String> LAST_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AggregatedSourceStatus.getter(AggregatedSourceStatus::lastUpdateStatusAsString)).setter(AggregatedSourceStatus.setter(Builder::lastUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateStatus").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AggregatedSourceStatus.getter(AggregatedSourceStatus::lastUpdateTime)).setter(AggregatedSourceStatus.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final SdkField<String> LAST_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AggregatedSourceStatus.getter(AggregatedSourceStatus::lastErrorCode)).setter(AggregatedSourceStatus.setter(Builder::lastErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastErrorCode").build()}).build();
    private static final SdkField<String> LAST_ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AggregatedSourceStatus.getter(AggregatedSourceStatus::lastErrorMessage)).setter(AggregatedSourceStatus.setter(Builder::lastErrorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ID_FIELD, SOURCE_TYPE_FIELD, AWS_REGION_FIELD, LAST_UPDATE_STATUS_FIELD, LAST_UPDATE_TIME_FIELD, LAST_ERROR_CODE_FIELD, LAST_ERROR_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceId;
    private final String sourceType;
    private final String awsRegion;
    private final String lastUpdateStatus;
    private final Instant lastUpdateTime;
    private final String lastErrorCode;
    private final String lastErrorMessage;

    private AggregatedSourceStatus(BuilderImpl builder) {
        this.sourceId = builder.sourceId;
        this.sourceType = builder.sourceType;
        this.awsRegion = builder.awsRegion;
        this.lastUpdateStatus = builder.lastUpdateStatus;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public AggregatedSourceType sourceType() {
        return AggregatedSourceType.fromValue(this.sourceType);
    }

    public String sourceTypeAsString() {
        return this.sourceType;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public AggregatedSourceStatusType lastUpdateStatus() {
        return AggregatedSourceStatusType.fromValue(this.lastUpdateStatus);
    }

    public String lastUpdateStatusAsString() {
        return this.lastUpdateStatus;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String lastErrorCode() {
        return this.lastErrorCode;
    }

    public String lastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastErrorMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatedSourceStatus)) {
            return false;
        }
        AggregatedSourceStatus other = (AggregatedSourceStatus)obj;
        return Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.lastUpdateStatusAsString(), other.lastUpdateStatusAsString()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.lastErrorCode(), other.lastErrorCode()) && Objects.equals(this.lastErrorMessage(), other.lastErrorMessage());
    }

    public String toString() {
        return ToString.builder((String)"AggregatedSourceStatus").add("SourceId", (Object)this.sourceId()).add("SourceType", (Object)this.sourceTypeAsString()).add("AwsRegion", (Object)this.awsRegion()).add("LastUpdateStatus", (Object)this.lastUpdateStatusAsString()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("LastErrorCode", (Object)this.lastErrorCode()).add("LastErrorMessage", (Object)this.lastErrorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "LastUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateStatusAsString()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "LastErrorCode": {
                return Optional.ofNullable(clazz.cast(this.lastErrorCode()));
            }
            case "LastErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.lastErrorMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregatedSourceStatus, T> g) {
        return obj -> g.apply((AggregatedSourceStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceId;
        private String sourceType;
        private String awsRegion;
        private String lastUpdateStatus;
        private Instant lastUpdateTime;
        private String lastErrorCode;
        private String lastErrorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatedSourceStatus model) {
            this.sourceId(model.sourceId);
            this.sourceType(model.sourceType);
            this.awsRegion(model.awsRegion);
            this.lastUpdateStatus(model.lastUpdateStatus);
            this.lastUpdateTime(model.lastUpdateTime);
            this.lastErrorCode(model.lastErrorCode);
            this.lastErrorMessage(model.lastErrorMessage);
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(AggregatedSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getLastUpdateStatus() {
            return this.lastUpdateStatus;
        }

        @Override
        public final Builder lastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
            return this;
        }

        @Override
        public final Builder lastUpdateStatus(AggregatedSourceStatusType lastUpdateStatus) {
            this.lastUpdateStatus(lastUpdateStatus == null ? null : lastUpdateStatus.toString());
            return this;
        }

        public final void setLastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final String getLastErrorCode() {
            return this.lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        public final String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        public AggregatedSourceStatus build() {
            return new AggregatedSourceStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregatedSourceStatus> {
        public Builder sourceId(String var1);

        public Builder sourceType(String var1);

        public Builder sourceType(AggregatedSourceType var1);

        public Builder awsRegion(String var1);

        public Builder lastUpdateStatus(String var1);

        public Builder lastUpdateStatus(AggregatedSourceStatusType var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder lastErrorCode(String var1);

        public Builder lastErrorMessage(String var1);
    }
}

