/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.EvaluationResult;
import software.amazon.awssdk.services.config.model.EvaluationResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetComplianceDetailsByResourceResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, GetComplianceDetailsByResourceResponse> {
    private static final SdkField<List<EvaluationResult>> EVALUATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetComplianceDetailsByResourceResponse.getter(GetComplianceDetailsByResourceResponse::evaluationResults)).setter(GetComplianceDetailsByResourceResponse.setter(Builder::evaluationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetComplianceDetailsByResourceResponse.getter(GetComplianceDetailsByResourceResponse::nextToken)).setter(GetComplianceDetailsByResourceResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<EvaluationResult> evaluationResults;
    private final String nextToken;

    private GetComplianceDetailsByResourceResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationResults = builder.evaluationResults;
        this.nextToken = builder.nextToken;
    }

    public List<EvaluationResult> evaluationResults() {
        return this.evaluationResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceDetailsByResourceResponse)) {
            return false;
        }
        GetComplianceDetailsByResourceResponse other = (GetComplianceDetailsByResourceResponse)((Object)obj);
        return Objects.equals(this.evaluationResults(), other.evaluationResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetComplianceDetailsByResourceResponse").add("EvaluationResults", this.evaluationResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationResults": {
                return Optional.ofNullable(clazz.cast(this.evaluationResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceDetailsByResourceResponse, T> g) {
        return obj -> g.apply((GetComplianceDetailsByResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<EvaluationResult> evaluationResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceDetailsByResourceResponse model) {
            super(model);
            this.evaluationResults(model.evaluationResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<EvaluationResult.Builder> getEvaluationResults() {
            return this.evaluationResults != null ? (Collection)this.evaluationResults.stream().map(EvaluationResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder evaluationResults(Collection<EvaluationResult> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copy(evaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(EvaluationResult ... evaluationResults) {
            this.evaluationResults(Arrays.asList(evaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(Consumer<EvaluationResult.Builder> ... evaluationResults) {
            this.evaluationResults(Stream.of(evaluationResults).map(c -> (EvaluationResult)((EvaluationResult.Builder)EvaluationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvaluationResults(Collection<EvaluationResult.BuilderImpl> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copyFromBuilder(evaluationResults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetComplianceDetailsByResourceResponse build() {
            return new GetComplianceDetailsByResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetComplianceDetailsByResourceResponse> {
        public Builder evaluationResults(Collection<EvaluationResult> var1);

        public Builder evaluationResults(EvaluationResult ... var1);

        public Builder evaluationResults(Consumer<EvaluationResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

