/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEvent;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationEventsRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationEventsResponse;

public class ListAutomationEventsIterable
implements SdkIterable<ListAutomationEventsResponse> {
    private final ComputeOptimizerAutomationClient client;
    private final ListAutomationEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutomationEventsIterable(ComputeOptimizerAutomationClient client, ListAutomationEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutomationEventsResponseFetcher();
    }

    public Iterator<ListAutomationEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutomationEvent> automationEvents() {
        Function<ListAutomationEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.automationEvents() != null) {
                return response.automationEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutomationEventsResponseFetcher
    implements SyncPageFetcher<ListAutomationEventsResponse> {
        private ListAutomationEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomationEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutomationEventsResponse nextPage(ListAutomationEventsResponse previousPage) {
            if (previousPage == null) {
                return ListAutomationEventsIterable.this.client.listAutomationEvents(ListAutomationEventsIterable.this.firstRequest);
            }
            return ListAutomationEventsIterable.this.client.listAutomationEvents((ListAutomationEventsRequest)((Object)ListAutomationEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

