/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ComputeOptimizerAutomationResponse;
import software.amazon.awssdk.services.computeoptimizerautomation.model.EventStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAutomationEventResponse
extends ComputeOptimizerAutomationResponse
implements ToCopyableBuilder<Builder, StartAutomationEventResponse> {
    private static final SdkField<String> RECOMMENDED_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedActionId").getter(StartAutomationEventResponse.getter(StartAutomationEventResponse::recommendedActionId)).setter(StartAutomationEventResponse.setter(Builder::recommendedActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedActionId").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(StartAutomationEventResponse.getter(StartAutomationEventResponse::eventId)).setter(StartAutomationEventResponse.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventStatus").getter(StartAutomationEventResponse.getter(StartAutomationEventResponse::eventStatusAsString)).setter(StartAutomationEventResponse.setter(Builder::eventStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDED_ACTION_ID_FIELD, EVENT_ID_FIELD, EVENT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartAutomationEventResponse.memberNameToFieldInitializer();
    private final String recommendedActionId;
    private final String eventId;
    private final String eventStatus;

    private StartAutomationEventResponse(BuilderImpl builder) {
        super(builder);
        this.recommendedActionId = builder.recommendedActionId;
        this.eventId = builder.eventId;
        this.eventStatus = builder.eventStatus;
    }

    public final String recommendedActionId() {
        return this.recommendedActionId;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final EventStatus eventStatus() {
        return EventStatus.fromValue(this.eventStatus);
    }

    public final String eventStatusAsString() {
        return this.eventStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedActionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAutomationEventResponse)) {
            return false;
        }
        StartAutomationEventResponse other = (StartAutomationEventResponse)((Object)obj);
        return Objects.equals(this.recommendedActionId(), other.recommendedActionId()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventStatusAsString(), other.eventStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartAutomationEventResponse").add("RecommendedActionId", (Object)this.recommendedActionId()).add("EventId", (Object)this.eventId()).add("EventStatus", (Object)this.eventStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommendedActionId": {
                return Optional.ofNullable(clazz.cast(this.recommendedActionId()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventStatus": {
                return Optional.ofNullable(clazz.cast(this.eventStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("recommendedActionId", RECOMMENDED_ACTION_ID_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("eventStatus", EVENT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAutomationEventResponse, T> g) {
        return obj -> g.apply((StartAutomationEventResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerAutomationResponse.BuilderImpl
    implements Builder {
        private String recommendedActionId;
        private String eventId;
        private String eventStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAutomationEventResponse model) {
            super(model);
            this.recommendedActionId(model.recommendedActionId);
            this.eventId(model.eventId);
            this.eventStatus(model.eventStatus);
        }

        public final String getRecommendedActionId() {
            return this.recommendedActionId;
        }

        public final void setRecommendedActionId(String recommendedActionId) {
            this.recommendedActionId = recommendedActionId;
        }

        @Override
        public final Builder recommendedActionId(String recommendedActionId) {
            this.recommendedActionId = recommendedActionId;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventStatus() {
            return this.eventStatus;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(EventStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        @Override
        public StartAutomationEventResponse build() {
            return new StartAutomationEventResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerAutomationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAutomationEventResponse> {
        public Builder recommendedActionId(String var1);

        public Builder eventId(String var1);

        public Builder eventStatus(String var1);

        public Builder eventStatus(EventStatus var1);
    }
}

