/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationRule;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationRulesCopier;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ComputeOptimizerAutomationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutomationRulesResponse
extends ComputeOptimizerAutomationResponse
implements ToCopyableBuilder<Builder, ListAutomationRulesResponse> {
    private static final SdkField<List<AutomationRule>> AUTOMATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("automationRules").getter(ListAutomationRulesResponse.getter(ListAutomationRulesResponse::automationRules)).setter(ListAutomationRulesResponse.setter(Builder::automationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automationRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAutomationRulesResponse.getter(ListAutomationRulesResponse::nextToken)).setter(ListAutomationRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_RULES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAutomationRulesResponse.memberNameToFieldInitializer();
    private final List<AutomationRule> automationRules;
    private final String nextToken;

    private ListAutomationRulesResponse(BuilderImpl builder) {
        super(builder);
        this.automationRules = builder.automationRules;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAutomationRules() {
        return this.automationRules != null && !(this.automationRules instanceof SdkAutoConstructList);
    }

    public final List<AutomationRule> automationRules() {
        return this.automationRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutomationRules() ? this.automationRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomationRulesResponse)) {
            return false;
        }
        ListAutomationRulesResponse other = (ListAutomationRulesResponse)((Object)obj);
        return this.hasAutomationRules() == other.hasAutomationRules() && Objects.equals(this.automationRules(), other.automationRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAutomationRulesResponse").add("AutomationRules", this.hasAutomationRules() ? this.automationRules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "automationRules": {
                return Optional.ofNullable(clazz.cast(this.automationRules()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("automationRules", AUTOMATION_RULES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomationRulesResponse, T> g) {
        return obj -> g.apply((ListAutomationRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerAutomationResponse.BuilderImpl
    implements Builder {
        private List<AutomationRule> automationRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomationRulesResponse model) {
            super(model);
            this.automationRules(model.automationRules);
            this.nextToken(model.nextToken);
        }

        public final List<AutomationRule.Builder> getAutomationRules() {
            List<AutomationRule.Builder> result = AutomationRulesCopier.copyToBuilder(this.automationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutomationRules(Collection<AutomationRule.BuilderImpl> automationRules) {
            this.automationRules = AutomationRulesCopier.copyFromBuilder(automationRules);
        }

        @Override
        public final Builder automationRules(Collection<AutomationRule> automationRules) {
            this.automationRules = AutomationRulesCopier.copy(automationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationRules(AutomationRule ... automationRules) {
            this.automationRules(Arrays.asList(automationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationRules(Consumer<AutomationRule.Builder> ... automationRules) {
            this.automationRules(Stream.of(automationRules).map(c -> (AutomationRule)((AutomationRule.Builder)AutomationRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutomationRulesResponse build() {
            return new ListAutomationRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerAutomationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutomationRulesResponse> {
        public Builder automationRules(Collection<AutomationRule> var1);

        public Builder automationRules(AutomationRule ... var1);

        public Builder automationRules(Consumer<AutomationRule.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

