/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a recommendation option for an Amazon Elastic Block Store (Amazon EBS) instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeRecommendationOption implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeRecommendationOption.Builder, VolumeRecommendationOption> {
    private static final SdkField<VolumeConfiguration> CONFIGURATION_FIELD = SdkField
            .<VolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(VolumeRecommendationOption::configuration)).setter(setter(Builder::configuration))
            .constructor(VolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<Double> PERFORMANCE_RISK_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("performanceRisk").getter(getter(VolumeRecommendationOption::performanceRisk))
            .setter(setter(Builder::performanceRisk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceRisk").build()).build();

    private static final SdkField<Integer> RANK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("rank")
            .getter(getter(VolumeRecommendationOption::rank)).setter(setter(Builder::rank))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()).build();

    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField
            .<SavingsOpportunity> builder(MarshallingType.SDK_POJO).memberName("savingsOpportunity")
            .getter(getter(VolumeRecommendationOption::savingsOpportunity)).setter(setter(Builder::savingsOpportunity))
            .constructor(SavingsOpportunity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build())
            .build();

    private static final SdkField<EBSSavingsOpportunityAfterDiscounts> SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD = SdkField
            .<EBSSavingsOpportunityAfterDiscounts> builder(MarshallingType.SDK_POJO)
            .memberName("savingsOpportunityAfterDiscounts")
            .getter(getter(VolumeRecommendationOption::savingsOpportunityAfterDiscounts))
            .setter(setter(Builder::savingsOpportunityAfterDiscounts))
            .constructor(EBSSavingsOpportunityAfterDiscounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityAfterDiscounts")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            PERFORMANCE_RISK_FIELD, RANK_FIELD, SAVINGS_OPPORTUNITY_FIELD, SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VolumeConfiguration configuration;

    private final Double performanceRisk;

    private final Integer rank;

    private final SavingsOpportunity savingsOpportunity;

    private final EBSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

    private VolumeRecommendationOption(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.performanceRisk = builder.performanceRisk;
        this.rank = builder.rank;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.savingsOpportunityAfterDiscounts = builder.savingsOpportunityAfterDiscounts;
    }

    /**
     * <p>
     * An array of objects that describe a volume configuration.
     * </p>
     * 
     * @return An array of objects that describe a volume configuration.
     */
    public final VolumeConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The performance risk of the volume recommendation option.
     * </p>
     * <p>
     * Performance risk is the likelihood of the recommended volume type meeting the performance requirement of your
     * workload.
     * </p>
     * <p>
     * The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning that the recommended resource
     * is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely
     * you should validate whether the recommendation will meet the performance requirements of your workload before
     * migrating your resource.
     * </p>
     * 
     * @return The performance risk of the volume recommendation option.</p>
     *         <p>
     *         Performance risk is the likelihood of the recommended volume type meeting the performance requirement of
     *         your workload.
     *         </p>
     *         <p>
     *         The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning that the recommended
     *         resource is predicted to always provide enough hardware capability. The higher the performance risk is,
     *         the more likely you should validate whether the recommendation will meet the performance requirements of
     *         your workload before migrating your resource.
     */
    public final Double performanceRisk() {
        return performanceRisk;
    }

    /**
     * <p>
     * The rank of the volume recommendation option.
     * </p>
     * <p>
     * The top recommendation option is ranked as <code>1</code>.
     * </p>
     * 
     * @return The rank of the volume recommendation option.</p>
     *         <p>
     *         The top recommendation option is ranked as <code>1</code>.
     */
    public final Integer rank() {
        return rank;
    }

    /**
     * <p>
     * An object that describes the savings opportunity for the EBS volume recommendation option. Savings opportunity
     * includes the estimated monthly savings amount and percentage.
     * </p>
     * 
     * @return An object that describes the savings opportunity for the EBS volume recommendation option. Savings
     *         opportunity includes the estimated monthly savings amount and percentage.
     */
    public final SavingsOpportunity savingsOpportunity() {
        return savingsOpportunity;
    }

    /**
     * <p>
     * An object that describes the savings opportunity for the Amazon EBS volume recommendation option with specific
     * discounts. Savings opportunity includes the estimated monthly savings and percentage.
     * </p>
     * 
     * @return An object that describes the savings opportunity for the Amazon EBS volume recommendation option with
     *         specific discounts. Savings opportunity includes the estimated monthly savings and percentage.
     */
    public final EBSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts() {
        return savingsOpportunityAfterDiscounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(performanceRisk());
        hashCode = 31 * hashCode + Objects.hashCode(rank());
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunityAfterDiscounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeRecommendationOption)) {
            return false;
        }
        VolumeRecommendationOption other = (VolumeRecommendationOption) obj;
        return Objects.equals(configuration(), other.configuration())
                && Objects.equals(performanceRisk(), other.performanceRisk()) && Objects.equals(rank(), other.rank())
                && Objects.equals(savingsOpportunity(), other.savingsOpportunity())
                && Objects.equals(savingsOpportunityAfterDiscounts(), other.savingsOpportunityAfterDiscounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VolumeRecommendationOption").add("Configuration", configuration())
                .add("PerformanceRisk", performanceRisk()).add("Rank", rank()).add("SavingsOpportunity", savingsOpportunity())
                .add("SavingsOpportunityAfterDiscounts", savingsOpportunityAfterDiscounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "performanceRisk":
            return Optional.ofNullable(clazz.cast(performanceRisk()));
        case "rank":
            return Optional.ofNullable(clazz.cast(rank()));
        case "savingsOpportunity":
            return Optional.ofNullable(clazz.cast(savingsOpportunity()));
        case "savingsOpportunityAfterDiscounts":
            return Optional.ofNullable(clazz.cast(savingsOpportunityAfterDiscounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("performanceRisk", PERFORMANCE_RISK_FIELD);
        map.put("rank", RANK_FIELD);
        map.put("savingsOpportunity", SAVINGS_OPPORTUNITY_FIELD);
        map.put("savingsOpportunityAfterDiscounts", SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VolumeRecommendationOption, T> g) {
        return obj -> g.apply((VolumeRecommendationOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeRecommendationOption> {
        /**
         * <p>
         * An array of objects that describe a volume configuration.
         * </p>
         * 
         * @param configuration
         *        An array of objects that describe a volume configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(VolumeConfiguration configuration);

        /**
         * <p>
         * An array of objects that describe a volume configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link VolumeConfiguration.Builder} avoiding the
         * need to create one manually via {@link VolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VolumeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(VolumeConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link VolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(VolumeConfiguration)
         */
        default Builder configuration(Consumer<VolumeConfiguration.Builder> configuration) {
            return configuration(VolumeConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The performance risk of the volume recommendation option.
         * </p>
         * <p>
         * Performance risk is the likelihood of the recommended volume type meeting the performance requirement of your
         * workload.
         * </p>
         * <p>
         * The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning that the recommended
         * resource is predicted to always provide enough hardware capability. The higher the performance risk is, the
         * more likely you should validate whether the recommendation will meet the performance requirements of your
         * workload before migrating your resource.
         * </p>
         * 
         * @param performanceRisk
         *        The performance risk of the volume recommendation option.</p>
         *        <p>
         *        Performance risk is the likelihood of the recommended volume type meeting the performance requirement
         *        of your workload.
         *        </p>
         *        <p>
         *        The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning that the
         *        recommended resource is predicted to always provide enough hardware capability. The higher the
         *        performance risk is, the more likely you should validate whether the recommendation will meet the
         *        performance requirements of your workload before migrating your resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceRisk(Double performanceRisk);

        /**
         * <p>
         * The rank of the volume recommendation option.
         * </p>
         * <p>
         * The top recommendation option is ranked as <code>1</code>.
         * </p>
         * 
         * @param rank
         *        The rank of the volume recommendation option.</p>
         *        <p>
         *        The top recommendation option is ranked as <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rank(Integer rank);

        /**
         * <p>
         * An object that describes the savings opportunity for the EBS volume recommendation option. Savings
         * opportunity includes the estimated monthly savings amount and percentage.
         * </p>
         * 
         * @param savingsOpportunity
         *        An object that describes the savings opportunity for the EBS volume recommendation option. Savings
         *        opportunity includes the estimated monthly savings amount and percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunity(SavingsOpportunity savingsOpportunity);

        /**
         * <p>
         * An object that describes the savings opportunity for the EBS volume recommendation option. Savings
         * opportunity includes the estimated monthly savings amount and percentage.
         * </p>
         * This is a convenience method that creates an instance of the {@link SavingsOpportunity.Builder} avoiding the
         * need to create one manually via {@link SavingsOpportunity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsOpportunity.Builder#build()} is called immediately and its
         * result is passed to {@link #savingsOpportunity(SavingsOpportunity)}.
         * 
         * @param savingsOpportunity
         *        a consumer that will call methods on {@link SavingsOpportunity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsOpportunity(SavingsOpportunity)
         */
        default Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return savingsOpportunity(SavingsOpportunity.builder().applyMutation(savingsOpportunity).build());
        }

        /**
         * <p>
         * An object that describes the savings opportunity for the Amazon EBS volume recommendation option with
         * specific discounts. Savings opportunity includes the estimated monthly savings and percentage.
         * </p>
         * 
         * @param savingsOpportunityAfterDiscounts
         *        An object that describes the savings opportunity for the Amazon EBS volume recommendation option with
         *        specific discounts. Savings opportunity includes the estimated monthly savings and percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunityAfterDiscounts(EBSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts);

        /**
         * <p>
         * An object that describes the savings opportunity for the Amazon EBS volume recommendation option with
         * specific discounts. Savings opportunity includes the estimated monthly savings and percentage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EBSSavingsOpportunityAfterDiscounts.Builder} avoiding the need to create one manually via
         * {@link EBSSavingsOpportunityAfterDiscounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EBSSavingsOpportunityAfterDiscounts.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #savingsOpportunityAfterDiscounts(EBSSavingsOpportunityAfterDiscounts)}.
         * 
         * @param savingsOpportunityAfterDiscounts
         *        a consumer that will call methods on {@link EBSSavingsOpportunityAfterDiscounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsOpportunityAfterDiscounts(EBSSavingsOpportunityAfterDiscounts)
         */
        default Builder savingsOpportunityAfterDiscounts(
                Consumer<EBSSavingsOpportunityAfterDiscounts.Builder> savingsOpportunityAfterDiscounts) {
            return savingsOpportunityAfterDiscounts(EBSSavingsOpportunityAfterDiscounts.builder()
                    .applyMutation(savingsOpportunityAfterDiscounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VolumeConfiguration configuration;

        private Double performanceRisk;

        private Integer rank;

        private SavingsOpportunity savingsOpportunity;

        private EBSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeRecommendationOption model) {
            configuration(model.configuration);
            performanceRisk(model.performanceRisk);
            rank(model.rank);
            savingsOpportunity(model.savingsOpportunity);
            savingsOpportunityAfterDiscounts(model.savingsOpportunityAfterDiscounts);
        }

        public final VolumeConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(VolumeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(VolumeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Double getPerformanceRisk() {
            return performanceRisk;
        }

        public final void setPerformanceRisk(Double performanceRisk) {
            this.performanceRisk = performanceRisk;
        }

        @Override
        public final Builder performanceRisk(Double performanceRisk) {
            this.performanceRisk = performanceRisk;
            return this;
        }

        public final Integer getRank() {
            return rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return savingsOpportunity != null ? savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final EBSSavingsOpportunityAfterDiscounts.Builder getSavingsOpportunityAfterDiscounts() {
            return savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts.toBuilder() : null;
        }

        public final void setSavingsOpportunityAfterDiscounts(
                EBSSavingsOpportunityAfterDiscounts.BuilderImpl savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts
                    .build() : null;
        }

        @Override
        public final Builder savingsOpportunityAfterDiscounts(EBSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
            return this;
        }

        @Override
        public VolumeRecommendationOption build() {
            return new VolumeRecommendationOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
