/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEcsServiceRecommendationsRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<GetEcsServiceRecommendationsRequest.Builder, GetEcsServiceRecommendationsRequest> {
    private static final SdkField<List<String>> SERVICE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("serviceArns")
            .getter(getter(GetEcsServiceRecommendationsRequest::serviceArns))
            .setter(setter(Builder::serviceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetEcsServiceRecommendationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetEcsServiceRecommendationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<ECSServiceRecommendationFilter>> FILTERS_FIELD = SdkField
            .<List<ECSServiceRecommendationFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(GetEcsServiceRecommendationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ECSServiceRecommendationFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ECSServiceRecommendationFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(GetEcsServiceRecommendationsRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARNS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD, ACCOUNT_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> serviceArns;

    private final String nextToken;

    private final Integer maxResults;

    private final List<ECSServiceRecommendationFilter> filters;

    private final List<String> accountIds;

    private GetEcsServiceRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceArns = builder.serviceArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.accountIds = builder.accountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceArns() {
        return serviceArns != null && !(serviceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN that identifies the Amazon ECS service.
     * </p>
     * <p>
     * The following is the format of the ARN:
     * </p>
     * <p>
     * <code>arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceArns} method.
     * </p>
     * 
     * @return The ARN that identifies the Amazon ECS service. </p>
     *         <p>
     *         The following is the format of the ARN:
     *         </p>
     *         <p>
     *         <code>arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name</code>
     */
    public final List<String> serviceArns() {
        return serviceArns;
    }

    /**
     * <p>
     * The token to advance to the next page of Amazon ECS service recommendations.
     * </p>
     * 
     * @return The token to advance to the next page of Amazon ECS service recommendations.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of Amazon ECS service recommendations to return with a single request.
     * </p>
     * <p>
     * To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of Amazon ECS service recommendations to return with a single request. </p>
     *         <p>
     *         To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects to specify a filter that returns a more specific list of Amazon ECS service recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return An array of objects to specify a filter that returns a more specific list of Amazon ECS service
     *         recommendations.
     */
    public final List<ECSServiceRecommendationFilter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Return the Amazon ECS service recommendations to the specified Amazon Web Services account IDs.
     * </p>
     * <p>
     * If your account is the management account or the delegated administrator of an organization, use this parameter
     * to return the Amazon ECS service recommendations to specific member accounts.
     * </p>
     * <p>
     * You can only specify one account ID per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return Return the Amazon ECS service recommendations to the specified Amazon Web Services account IDs. </p>
     *         <p>
     *         If your account is the management account or the delegated administrator of an organization, use this
     *         parameter to return the Amazon ECS service recommendations to specific member accounts.
     *         </p>
     *         <p>
     *         You can only specify one account ID per request.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceArns() ? serviceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEcsServiceRecommendationsRequest)) {
            return false;
        }
        GetEcsServiceRecommendationsRequest other = (GetEcsServiceRecommendationsRequest) obj;
        return hasServiceArns() == other.hasServiceArns() && Objects.equals(serviceArns(), other.serviceArns())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEcsServiceRecommendationsRequest")
                .add("ServiceArns", hasServiceArns() ? serviceArns() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Filters", hasFilters() ? filters() : null)
                .add("AccountIds", hasAccountIds() ? accountIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceArns":
            return Optional.ofNullable(clazz.cast(serviceArns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceArns", SERVICE_ARNS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEcsServiceRecommendationsRequest, T> g) {
        return obj -> g.apply((GetEcsServiceRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEcsServiceRecommendationsRequest> {
        /**
         * <p>
         * The ARN that identifies the Amazon ECS service.
         * </p>
         * <p>
         * The following is the format of the ARN:
         * </p>
         * <p>
         * <code>arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name</code>
         * </p>
         * 
         * @param serviceArns
         *        The ARN that identifies the Amazon ECS service. </p>
         *        <p>
         *        The following is the format of the ARN:
         *        </p>
         *        <p>
         *        <code>arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArns(Collection<String> serviceArns);

        /**
         * <p>
         * The ARN that identifies the Amazon ECS service.
         * </p>
         * <p>
         * The following is the format of the ARN:
         * </p>
         * <p>
         * <code>arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name</code>
         * </p>
         * 
         * @param serviceArns
         *        The ARN that identifies the Amazon ECS service. </p>
         *        <p>
         *        The following is the format of the ARN:
         *        </p>
         *        <p>
         *        <code>arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArns(String... serviceArns);

        /**
         * <p>
         * The token to advance to the next page of Amazon ECS service recommendations.
         * </p>
         * 
         * @param nextToken
         *        The token to advance to the next page of Amazon ECS service recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of Amazon ECS service recommendations to return with a single request.
         * </p>
         * <p>
         * To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of Amazon ECS service recommendations to return with a single request. </p>
         *        <p>
         *        To retrieve the remaining results, make another request with the returned <code>nextToken</code>
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of Amazon ECS service
         * recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that returns a more specific list of Amazon ECS service
         *        recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ECSServiceRecommendationFilter> filters);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of Amazon ECS service
         * recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that returns a more specific list of Amazon ECS service
         *        recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ECSServiceRecommendationFilter... filters);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of Amazon ECS service
         * recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilter.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<ECSServiceRecommendationFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.ECSServiceRecommendationFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<ECSServiceRecommendationFilter>)
         */
        Builder filters(Consumer<ECSServiceRecommendationFilter.Builder>... filters);

        /**
         * <p>
         * Return the Amazon ECS service recommendations to the specified Amazon Web Services account IDs.
         * </p>
         * <p>
         * If your account is the management account or the delegated administrator of an organization, use this
         * parameter to return the Amazon ECS service recommendations to specific member accounts.
         * </p>
         * <p>
         * You can only specify one account ID per request.
         * </p>
         * 
         * @param accountIds
         *        Return the Amazon ECS service recommendations to the specified Amazon Web Services account IDs. </p>
         *        <p>
         *        If your account is the management account or the delegated administrator of an organization, use this
         *        parameter to return the Amazon ECS service recommendations to specific member accounts.
         *        </p>
         *        <p>
         *        You can only specify one account ID per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * Return the Amazon ECS service recommendations to the specified Amazon Web Services account IDs.
         * </p>
         * <p>
         * If your account is the management account or the delegated administrator of an organization, use this
         * parameter to return the Amazon ECS service recommendations to specific member accounts.
         * </p>
         * <p>
         * You can only specify one account ID per request.
         * </p>
         * 
         * @param accountIds
         *        Return the Amazon ECS service recommendations to the specified Amazon Web Services account IDs. </p>
         *        <p>
         *        If your account is the management account or the delegated administrator of an organization, use this
         *        parameter to return the Amazon ECS service recommendations to specific member accounts.
         *        </p>
         *        <p>
         *        You can only specify one account ID per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private List<String> serviceArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private List<ECSServiceRecommendationFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEcsServiceRecommendationsRequest model) {
            super(model);
            serviceArns(model.serviceArns);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
            accountIds(model.accountIds);
        }

        public final Collection<String> getServiceArns() {
            if (serviceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceArns;
        }

        public final void setServiceArns(Collection<String> serviceArns) {
            this.serviceArns = ServiceArnsCopier.copy(serviceArns);
        }

        @Override
        public final Builder serviceArns(Collection<String> serviceArns) {
            this.serviceArns = ServiceArnsCopier.copy(serviceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceArns(String... serviceArns) {
            serviceArns(Arrays.asList(serviceArns));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<ECSServiceRecommendationFilter.Builder> getFilters() {
            List<ECSServiceRecommendationFilter.Builder> result = ECSServiceRecommendationFiltersCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ECSServiceRecommendationFilter.BuilderImpl> filters) {
            this.filters = ECSServiceRecommendationFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ECSServiceRecommendationFilter> filters) {
            this.filters = ECSServiceRecommendationFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ECSServiceRecommendationFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ECSServiceRecommendationFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ECSServiceRecommendationFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEcsServiceRecommendationsRequest build() {
            return new GetEcsServiceRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
