/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the performance risk ratings for a given resource type.
 * </p>
 * <p>
 * Resources with a <code>high</code> or <code>medium</code> rating are at risk of not meeting the performance needs of
 * their workloads, while resources with a <code>low</code> rating are performing well in their workloads.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CurrentPerformanceRiskRatings implements SdkPojo, Serializable,
        ToCopyableBuilder<CurrentPerformanceRiskRatings.Builder, CurrentPerformanceRiskRatings> {
    private static final SdkField<Long> HIGH_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("high")
            .getter(getter(CurrentPerformanceRiskRatings::high)).setter(setter(Builder::high))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("high").build()).build();

    private static final SdkField<Long> MEDIUM_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("medium")
            .getter(getter(CurrentPerformanceRiskRatings::medium)).setter(setter(Builder::medium))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("medium").build()).build();

    private static final SdkField<Long> LOW_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("low")
            .getter(getter(CurrentPerformanceRiskRatings::low)).setter(setter(Builder::low))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("low").build()).build();

    private static final SdkField<Long> VERY_LOW_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("veryLow")
            .getter(getter(CurrentPerformanceRiskRatings::veryLow)).setter(setter(Builder::veryLow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("veryLow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIGH_FIELD, MEDIUM_FIELD,
            LOW_FIELD, VERY_LOW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long high;

    private final Long medium;

    private final Long low;

    private final Long veryLow;

    private CurrentPerformanceRiskRatings(BuilderImpl builder) {
        this.high = builder.high;
        this.medium = builder.medium;
        this.low = builder.low;
        this.veryLow = builder.veryLow;
    }

    /**
     * <p>
     * A count of the applicable resource types with a high performance risk rating.
     * </p>
     * 
     * @return A count of the applicable resource types with a high performance risk rating.
     */
    public final Long high() {
        return high;
    }

    /**
     * <p>
     * A count of the applicable resource types with a medium performance risk rating.
     * </p>
     * 
     * @return A count of the applicable resource types with a medium performance risk rating.
     */
    public final Long medium() {
        return medium;
    }

    /**
     * <p>
     * A count of the applicable resource types with a low performance risk rating.
     * </p>
     * 
     * @return A count of the applicable resource types with a low performance risk rating.
     */
    public final Long low() {
        return low;
    }

    /**
     * <p>
     * A count of the applicable resource types with a very low performance risk rating.
     * </p>
     * 
     * @return A count of the applicable resource types with a very low performance risk rating.
     */
    public final Long veryLow() {
        return veryLow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(high());
        hashCode = 31 * hashCode + Objects.hashCode(medium());
        hashCode = 31 * hashCode + Objects.hashCode(low());
        hashCode = 31 * hashCode + Objects.hashCode(veryLow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentPerformanceRiskRatings)) {
            return false;
        }
        CurrentPerformanceRiskRatings other = (CurrentPerformanceRiskRatings) obj;
        return Objects.equals(high(), other.high()) && Objects.equals(medium(), other.medium())
                && Objects.equals(low(), other.low()) && Objects.equals(veryLow(), other.veryLow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CurrentPerformanceRiskRatings").add("High", high()).add("Medium", medium()).add("Low", low())
                .add("VeryLow", veryLow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "high":
            return Optional.ofNullable(clazz.cast(high()));
        case "medium":
            return Optional.ofNullable(clazz.cast(medium()));
        case "low":
            return Optional.ofNullable(clazz.cast(low()));
        case "veryLow":
            return Optional.ofNullable(clazz.cast(veryLow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("high", HIGH_FIELD);
        map.put("medium", MEDIUM_FIELD);
        map.put("low", LOW_FIELD);
        map.put("veryLow", VERY_LOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CurrentPerformanceRiskRatings, T> g) {
        return obj -> g.apply((CurrentPerformanceRiskRatings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CurrentPerformanceRiskRatings> {
        /**
         * <p>
         * A count of the applicable resource types with a high performance risk rating.
         * </p>
         * 
         * @param high
         *        A count of the applicable resource types with a high performance risk rating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder high(Long high);

        /**
         * <p>
         * A count of the applicable resource types with a medium performance risk rating.
         * </p>
         * 
         * @param medium
         *        A count of the applicable resource types with a medium performance risk rating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medium(Long medium);

        /**
         * <p>
         * A count of the applicable resource types with a low performance risk rating.
         * </p>
         * 
         * @param low
         *        A count of the applicable resource types with a low performance risk rating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder low(Long low);

        /**
         * <p>
         * A count of the applicable resource types with a very low performance risk rating.
         * </p>
         * 
         * @param veryLow
         *        A count of the applicable resource types with a very low performance risk rating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder veryLow(Long veryLow);
    }

    static final class BuilderImpl implements Builder {
        private Long high;

        private Long medium;

        private Long low;

        private Long veryLow;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentPerformanceRiskRatings model) {
            high(model.high);
            medium(model.medium);
            low(model.low);
            veryLow(model.veryLow);
        }

        public final Long getHigh() {
            return high;
        }

        public final void setHigh(Long high) {
            this.high = high;
        }

        @Override
        public final Builder high(Long high) {
            this.high = high;
            return this;
        }

        public final Long getMedium() {
            return medium;
        }

        public final void setMedium(Long medium) {
            this.medium = medium;
        }

        @Override
        public final Builder medium(Long medium) {
            this.medium = medium;
            return this;
        }

        public final Long getLow() {
            return low;
        }

        public final void setLow(Long low) {
            this.low = low;
        }

        @Override
        public final Builder low(Long low) {
            this.low = low;
            return this;
        }

        public final Long getVeryLow() {
            return veryLow;
        }

        public final void setVeryLow(Long veryLow) {
            this.veryLow = veryLow;
        }

        @Override
        public final Builder veryLow(Long veryLow) {
            this.veryLow = veryLow;
            return this;
        }

        @Override
        public CurrentPerformanceRiskRatings build() {
            return new CurrentPerformanceRiskRatings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
