/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.computeoptimizer.internal.ComputeOptimizerServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.computeoptimizer.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.computeoptimizer.model.AccessDeniedException;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerException;
import software.amazon.awssdk.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.DeleteRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEbsVolumeRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEcsServiceRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEcsServiceRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportIdleRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportIdleRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportLicenseRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportLicenseRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportRdsDatabaseRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportRdsDatabaseRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetIdleRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetIdleRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetLicenseRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRdsDatabaseRecommendationProjectedMetricsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetRdsDatabaseRecommendationProjectedMetricsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRdsDatabaseRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetRdsDatabaseRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.InternalServerException;
import software.amazon.awssdk.services.computeoptimizer.model.InvalidParameterValueException;
import software.amazon.awssdk.services.computeoptimizer.model.LimitExceededException;
import software.amazon.awssdk.services.computeoptimizer.model.MissingAuthenticationTokenException;
import software.amazon.awssdk.services.computeoptimizer.model.OptInRequiredException;
import software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.computeoptimizer.model.ServiceUnavailableException;
import software.amazon.awssdk.services.computeoptimizer.model.ThrottlingException;
import software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusRequest;
import software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusResponse;
import software.amazon.awssdk.services.computeoptimizer.transform.DeleteRecommendationPreferencesRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.DescribeRecommendationExportJobsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportAutoScalingGroupRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportEbsVolumeRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportEc2InstanceRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportEcsServiceRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportIdleRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportLambdaFunctionRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportLicenseRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportRdsDatabaseRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetAutoScalingGroupRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEbsVolumeRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEc2InstanceRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEc2RecommendationProjectedMetricsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEcsServiceRecommendationProjectedMetricsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEcsServiceRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEffectiveRecommendationPreferencesRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEnrollmentStatusRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEnrollmentStatusesForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetIdleRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetLambdaFunctionRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetLicenseRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetRdsDatabaseRecommendationProjectedMetricsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetRdsDatabaseRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetRecommendationPreferencesRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetRecommendationSummariesRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.PutRecommendationPreferencesRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.UpdateEnrollmentStatusRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ComputeOptimizerClient}.
 *
 * @see ComputeOptimizerClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultComputeOptimizerClient implements ComputeOptimizerClient {
    private static final Logger log = Logger.loggerFor(DefaultComputeOptimizerClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultComputeOptimizerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Compute_Optimizer" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Deletes a recommendation preference, such as enhanced infrastructure metrics.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param deleteRecommendationPreferencesRequest
     * @return Result of the DeleteRecommendationPreferences operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.DeleteRecommendationPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/DeleteRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRecommendationPreferencesResponse deleteRecommendationPreferences(
            DeleteRecommendationPreferencesRequest deleteRecommendationPreferencesRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRecommendationPreferencesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRecommendationPreferencesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRecommendationPreferencesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteRecommendationPreferencesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRecommendationPreferences");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRecommendationPreferencesRequest, DeleteRecommendationPreferencesResponse>()
                            .withOperationName("DeleteRecommendationPreferences").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteRecommendationPreferencesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRecommendationPreferencesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes recommendation export jobs created in the last seven days.
     * </p>
     * <p>
     * Use the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions to
     * request an export of your recommendations. Then use the <a>DescribeRecommendationExportJobs</a> action to view
     * your export jobs.
     * </p>
     *
     * @param describeRecommendationExportJobsRequest
     * @return Result of the DescribeRecommendationExportJobs operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.DescribeRecommendationExportJobs
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/DescribeRecommendationExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRecommendationExportJobsResponse describeRecommendationExportJobs(
            DescribeRecommendationExportJobsRequest describeRecommendationExportJobsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRecommendationExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeRecommendationExportJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRecommendationExportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRecommendationExportJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRecommendationExportJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeRecommendationExportJobsRequest, DescribeRecommendationExportJobsResponse>()
                            .withOperationName("DescribeRecommendationExportJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeRecommendationExportJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeRecommendationExportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exports optimization recommendations for Amazon EC2 Auto Scaling groups.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object
     * Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Amazon EC2 Auto Scaling group export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportAutoScalingGroupRecommendationsRequest
     * @return Result of the ExportAutoScalingGroupRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws LimitExceededException
     *         The request exceeds a limit of the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.ExportAutoScalingGroupRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportAutoScalingGroupRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExportAutoScalingGroupRecommendationsResponse exportAutoScalingGroupRecommendations(
            ExportAutoScalingGroupRecommendationsRequest exportAutoScalingGroupRecommendationsRequest)
            throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException,
            InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportAutoScalingGroupRecommendationsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ExportAutoScalingGroupRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportAutoScalingGroupRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                exportAutoScalingGroupRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportAutoScalingGroupRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ExportAutoScalingGroupRecommendationsRequest, ExportAutoScalingGroupRecommendationsResponse>()
                            .withOperationName("ExportAutoScalingGroupRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(exportAutoScalingGroupRecommendationsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExportAutoScalingGroupRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exports optimization recommendations for Amazon EBS volumes.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object
     * Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportEbsVolumeRecommendationsRequest
     * @return Result of the ExportEBSVolumeRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws LimitExceededException
     *         The request exceeds a limit of the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.ExportEBSVolumeRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportEBSVolumeRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExportEbsVolumeRecommendationsResponse exportEBSVolumeRecommendations(
            ExportEbsVolumeRecommendationsRequest exportEbsVolumeRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportEbsVolumeRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExportEbsVolumeRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportEbsVolumeRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                exportEbsVolumeRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportEBSVolumeRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ExportEbsVolumeRecommendationsRequest, ExportEbsVolumeRecommendationsResponse>()
                            .withOperationName("ExportEBSVolumeRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(exportEbsVolumeRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExportEbsVolumeRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exports optimization recommendations for Amazon EC2 instances.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object
     * Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportEc2InstanceRecommendationsRequest
     * @return Result of the ExportEC2InstanceRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws LimitExceededException
     *         The request exceeds a limit of the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.ExportEC2InstanceRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportEC2InstanceRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExportEc2InstanceRecommendationsResponse exportEC2InstanceRecommendations(
            ExportEc2InstanceRecommendationsRequest exportEc2InstanceRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportEc2InstanceRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExportEc2InstanceRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportEc2InstanceRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                exportEc2InstanceRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportEC2InstanceRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ExportEc2InstanceRecommendationsRequest, ExportEc2InstanceRecommendationsResponse>()
                            .withOperationName("ExportEC2InstanceRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(exportEc2InstanceRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExportEc2InstanceRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exports optimization recommendations for Amazon ECS services on Fargate.
     * </p>
     * <p>
     * Recommendations are exported in a CSV file, and its metadata in a JSON file, to an existing Amazon Simple Storage
     * Service (Amazon S3) bucket that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can only have one Amazon ECS service export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportEcsServiceRecommendationsRequest
     * @return Result of the ExportECSServiceRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws LimitExceededException
     *         The request exceeds a limit of the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.ExportECSServiceRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportECSServiceRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExportEcsServiceRecommendationsResponse exportECSServiceRecommendations(
            ExportEcsServiceRecommendationsRequest exportEcsServiceRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportEcsServiceRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExportEcsServiceRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportEcsServiceRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                exportEcsServiceRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportECSServiceRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ExportEcsServiceRecommendationsRequest, ExportEcsServiceRecommendationsResponse>()
                            .withOperationName("ExportECSServiceRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(exportEcsServiceRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExportEcsServiceRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Export optimization recommendations for your idle resources.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (CSV) file, and its metadata in a JavaScript Object
     * Notation (JSON) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one idle resource export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportIdleRecommendationsRequest
     * @return Result of the ExportIdleRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws LimitExceededException
     *         The request exceeds a limit of the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.ExportIdleRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportIdleRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExportIdleRecommendationsResponse exportIdleRecommendations(
            ExportIdleRecommendationsRequest exportIdleRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportIdleRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExportIdleRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportIdleRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exportIdleRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportIdleRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ExportIdleRecommendationsRequest, ExportIdleRecommendationsResponse>()
                            .withOperationName("ExportIdleRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(exportIdleRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExportIdleRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exports optimization recommendations for Lambda functions.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object
     * Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Lambda function export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportLambdaFunctionRecommendationsRequest
     * @return Result of the ExportLambdaFunctionRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws LimitExceededException
     *         The request exceeds a limit of the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.ExportLambdaFunctionRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportLambdaFunctionRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExportLambdaFunctionRecommendationsResponse exportLambdaFunctionRecommendations(
            ExportLambdaFunctionRecommendationsRequest exportLambdaFunctionRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportLambdaFunctionRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExportLambdaFunctionRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportLambdaFunctionRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                exportLambdaFunctionRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportLambdaFunctionRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ExportLambdaFunctionRecommendationsRequest, ExportLambdaFunctionRecommendationsResponse>()
                            .withOperationName("ExportLambdaFunctionRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(exportLambdaFunctionRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExportLambdaFunctionRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Export optimization recommendations for your licenses.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (CSV) file, and its metadata in a JavaScript Object
     * Notation (JSON) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one license export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportLicenseRecommendationsRequest
     * @return Result of the ExportLicenseRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws LimitExceededException
     *         The request exceeds a limit of the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.ExportLicenseRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportLicenseRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExportLicenseRecommendationsResponse exportLicenseRecommendations(
            ExportLicenseRecommendationsRequest exportLicenseRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportLicenseRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExportLicenseRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportLicenseRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exportLicenseRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportLicenseRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ExportLicenseRecommendationsRequest, ExportLicenseRecommendationsResponse>()
                            .withOperationName("ExportLicenseRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(exportLicenseRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExportLicenseRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Export optimization recommendations for your Amazon Aurora and Amazon Relational Database Service (Amazon RDS)
     * databases.
     * </p>
     * <p>
     * Recommendations are exported in a comma-separated values (CSV) file, and its metadata in a JavaScript Object
     * Notation (JSON) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting
     * Recommendations</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * You can have only one Amazon Aurora or RDS export job in progress per Amazon Web Services Region.
     * </p>
     *
     * @param exportRdsDatabaseRecommendationsRequest
     * @return Result of the ExportRDSDatabaseRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws LimitExceededException
     *         The request exceeds a limit of the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.ExportRDSDatabaseRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportRDSDatabaseRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExportRdsDatabaseRecommendationsResponse exportRDSDatabaseRecommendations(
            ExportRdsDatabaseRecommendationsRequest exportRdsDatabaseRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportRdsDatabaseRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExportRdsDatabaseRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportRdsDatabaseRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                exportRdsDatabaseRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportRDSDatabaseRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<ExportRdsDatabaseRecommendationsRequest, ExportRdsDatabaseRecommendationsResponse>()
                            .withOperationName("ExportRDSDatabaseRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(exportRdsDatabaseRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExportRdsDatabaseRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns Amazon EC2 Auto Scaling group recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that meet a specific set of
     * requirements. For more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getAutoScalingGroupRecommendationsRequest
     * @return Result of the GetAutoScalingGroupRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetAutoScalingGroupRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetAutoScalingGroupRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAutoScalingGroupRecommendationsResponse getAutoScalingGroupRecommendations(
            GetAutoScalingGroupRecommendationsRequest getAutoScalingGroupRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAutoScalingGroupRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAutoScalingGroupRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAutoScalingGroupRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAutoScalingGroupRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAutoScalingGroupRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAutoScalingGroupRecommendationsRequest, GetAutoScalingGroupRecommendationsResponse>()
                            .withOperationName("GetAutoScalingGroupRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getAutoScalingGroupRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAutoScalingGroupRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon EBS volumes that meet a specific set of requirements. For
     * more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getEbsVolumeRecommendationsRequest
     * @return Result of the GetEBSVolumeRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetEBSVolumeRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEBSVolumeRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEbsVolumeRecommendationsResponse getEBSVolumeRecommendations(
            GetEbsVolumeRecommendationsRequest getEbsVolumeRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEbsVolumeRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEbsVolumeRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEbsVolumeRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEbsVolumeRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEBSVolumeRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEbsVolumeRecommendationsRequest, GetEbsVolumeRecommendationsResponse>()
                            .withOperationName("GetEBSVolumeRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getEbsVolumeRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEbsVolumeRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns Amazon EC2 instance recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a
     * specific set of requirements. For more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getEc2InstanceRecommendationsRequest
     * @return Result of the GetEC2InstanceRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetEC2InstanceRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEC2InstanceRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEc2InstanceRecommendationsResponse getEC2InstanceRecommendations(
            GetEc2InstanceRecommendationsRequest getEc2InstanceRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEc2InstanceRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEc2InstanceRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEc2InstanceRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getEc2InstanceRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEC2InstanceRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEc2InstanceRecommendationsRequest, GetEc2InstanceRecommendationsResponse>()
                            .withOperationName("GetEC2InstanceRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getEc2InstanceRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEc2InstanceRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the projected utilization metrics of Amazon EC2 instance recommendations.
     * </p>
     * <note>
     * <p>
     * The <code>Cpu</code> and <code>Memory</code> metrics are the only projected utilization metrics returned when you
     * run this action. Additionally, the <code>Memory</code> metric is returned only for resources that have the
     * unified CloudWatch agent installed on them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization
     * with the CloudWatch Agent</a>.
     * </p>
     * </note>
     *
     * @param getEc2RecommendationProjectedMetricsRequest
     * @return Result of the GetEC2RecommendationProjectedMetrics operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetEC2RecommendationProjectedMetrics
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEC2RecommendationProjectedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEc2RecommendationProjectedMetricsResponse getEC2RecommendationProjectedMetrics(
            GetEc2RecommendationProjectedMetricsRequest getEc2RecommendationProjectedMetricsRequest)
            throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException,
            AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEc2RecommendationProjectedMetricsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetEc2RecommendationProjectedMetricsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEc2RecommendationProjectedMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getEc2RecommendationProjectedMetricsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEC2RecommendationProjectedMetrics");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEc2RecommendationProjectedMetricsRequest, GetEc2RecommendationProjectedMetricsResponse>()
                            .withOperationName("GetEC2RecommendationProjectedMetrics").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getEc2RecommendationProjectedMetricsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEc2RecommendationProjectedMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the projected metrics of Amazon ECS service recommendations.
     * </p>
     *
     * @param getEcsServiceRecommendationProjectedMetricsRequest
     * @return Result of the GetECSServiceRecommendationProjectedMetrics operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetECSServiceRecommendationProjectedMetrics
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetECSServiceRecommendationProjectedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEcsServiceRecommendationProjectedMetricsResponse getECSServiceRecommendationProjectedMetrics(
            GetEcsServiceRecommendationProjectedMetricsRequest getEcsServiceRecommendationProjectedMetricsRequest)
            throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException,
            AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEcsServiceRecommendationProjectedMetricsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetEcsServiceRecommendationProjectedMetricsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getEcsServiceRecommendationProjectedMetricsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getEcsServiceRecommendationProjectedMetricsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetECSServiceRecommendationProjectedMetrics");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEcsServiceRecommendationProjectedMetricsRequest, GetEcsServiceRecommendationProjectedMetricsResponse>()
                            .withOperationName("GetECSServiceRecommendationProjectedMetrics")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getEcsServiceRecommendationProjectedMetricsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEcsServiceRecommendationProjectedMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns Amazon ECS service recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon ECS services on Fargate that meet a specific set of
     * requirements. For more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getEcsServiceRecommendationsRequest
     * @return Result of the GetECSServiceRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetECSServiceRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetECSServiceRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEcsServiceRecommendationsResponse getECSServiceRecommendations(
            GetEcsServiceRecommendationsRequest getEcsServiceRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEcsServiceRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEcsServiceRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEcsServiceRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEcsServiceRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetECSServiceRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEcsServiceRecommendationsRequest, GetEcsServiceRecommendationsResponse>()
                            .withOperationName("GetECSServiceRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getEcsServiceRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEcsServiceRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the recommendation preferences that are in effect for a given resource, such as enhanced infrastructure
     * metrics. Considers all applicable preferences that you might have set at the resource, account, and organization
     * level.
     * </p>
     * <p>
     * When you create a recommendation preference, you can set its status to <code>Active</code> or
     * <code>Inactive</code>. Use this action to view the recommendation preferences that are in effect, or
     * <code>Active</code>.
     * </p>
     *
     * @param getEffectiveRecommendationPreferencesRequest
     * @return Result of the GetEffectiveRecommendationPreferences operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetEffectiveRecommendationPreferences
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEffectiveRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEffectiveRecommendationPreferencesResponse getEffectiveRecommendationPreferences(
            GetEffectiveRecommendationPreferencesRequest getEffectiveRecommendationPreferencesRequest)
            throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException,
            AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEffectiveRecommendationPreferencesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetEffectiveRecommendationPreferencesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEffectiveRecommendationPreferencesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getEffectiveRecommendationPreferencesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEffectiveRecommendationPreferences");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEffectiveRecommendationPreferencesRequest, GetEffectiveRecommendationPreferencesResponse>()
                            .withOperationName("GetEffectiveRecommendationPreferences").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(getEffectiveRecommendationPreferencesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEffectiveRecommendationPreferencesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the enrollment (opt in) status of an account to the Compute Optimizer service.
     * </p>
     * <p>
     * If the account is the management account of an organization, this action also confirms the enrollment status of
     * member accounts of the organization. Use the <a>GetEnrollmentStatusesForOrganization</a> action to get detailed
     * information about the enrollment status of member accounts of an organization.
     * </p>
     *
     * @param getEnrollmentStatusRequest
     * @return Result of the GetEnrollmentStatus operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetEnrollmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEnrollmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEnrollmentStatusResponse getEnrollmentStatus(GetEnrollmentStatusRequest getEnrollmentStatusRequest)
            throws InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException,
            ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEnrollmentStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEnrollmentStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEnrollmentStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEnrollmentStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEnrollmentStatus");

            return clientHandler.execute(new ClientExecutionParams<GetEnrollmentStatusRequest, GetEnrollmentStatusResponse>()
                    .withOperationName("GetEnrollmentStatus").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getEnrollmentStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEnrollmentStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an
     * organization management account.
     * </p>
     * <p>
     * To get the enrollment status of standalone accounts, use the <a>GetEnrollmentStatus</a> action.
     * </p>
     *
     * @param getEnrollmentStatusesForOrganizationRequest
     * @return Result of the GetEnrollmentStatusesForOrganization operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetEnrollmentStatusesForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEnrollmentStatusesForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEnrollmentStatusesForOrganizationResponse getEnrollmentStatusesForOrganization(
            GetEnrollmentStatusesForOrganizationRequest getEnrollmentStatusesForOrganizationRequest)
            throws InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException,
            ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEnrollmentStatusesForOrganizationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetEnrollmentStatusesForOrganizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEnrollmentStatusesForOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getEnrollmentStatusesForOrganizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEnrollmentStatusesForOrganization");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEnrollmentStatusesForOrganizationRequest, GetEnrollmentStatusesForOrganizationResponse>()
                            .withOperationName("GetEnrollmentStatusesForOrganization").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getEnrollmentStatusesForOrganizationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEnrollmentStatusesForOrganizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns idle resource recommendations. Compute Optimizer generates recommendations for idle resources that meet a
     * specific set of requirements. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Resource requirements</a> in the
     * <i>Compute Optimizer User Guide</i>
     * </p>
     *
     * @param getIdleRecommendationsRequest
     * @return Result of the GetIdleRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetIdleRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetIdleRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetIdleRecommendationsResponse getIdleRecommendations(GetIdleRecommendationsRequest getIdleRecommendationsRequest)
            throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException,
            AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIdleRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetIdleRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIdleRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIdleRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdleRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<GetIdleRecommendationsRequest, GetIdleRecommendationsResponse>()
                            .withOperationName("GetIdleRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getIdleRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetIdleRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns Lambda function recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for functions that meet a specific set of requirements. For more
     * information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getLambdaFunctionRecommendationsRequest
     * @return Result of the GetLambdaFunctionRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws LimitExceededException
     *         The request exceeds a limit of the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetLambdaFunctionRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetLambdaFunctionRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetLambdaFunctionRecommendationsResponse getLambdaFunctionRecommendations(
            GetLambdaFunctionRecommendationsRequest getLambdaFunctionRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLambdaFunctionRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLambdaFunctionRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLambdaFunctionRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getLambdaFunctionRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLambdaFunctionRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<GetLambdaFunctionRecommendationsRequest, GetLambdaFunctionRecommendationsResponse>()
                            .withOperationName("GetLambdaFunctionRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getLambdaFunctionRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetLambdaFunctionRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns license recommendations for Amazon EC2 instances that run on a specific license.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for licenses that meet a specific set of requirements. For more
     * information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getLicenseRecommendationsRequest
     * @return Result of the GetLicenseRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetLicenseRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetLicenseRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetLicenseRecommendationsResponse getLicenseRecommendations(
            GetLicenseRecommendationsRequest getLicenseRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLicenseRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLicenseRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLicenseRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLicenseRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLicenseRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<GetLicenseRecommendationsRequest, GetLicenseRecommendationsResponse>()
                            .withOperationName("GetLicenseRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getLicenseRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetLicenseRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the projected metrics of Aurora and RDS database recommendations.
     * </p>
     *
     * @param getRdsDatabaseRecommendationProjectedMetricsRequest
     * @return Result of the GetRDSDatabaseRecommendationProjectedMetrics operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetRDSDatabaseRecommendationProjectedMetrics
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRDSDatabaseRecommendationProjectedMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRdsDatabaseRecommendationProjectedMetricsResponse getRDSDatabaseRecommendationProjectedMetrics(
            GetRdsDatabaseRecommendationProjectedMetricsRequest getRdsDatabaseRecommendationProjectedMetricsRequest)
            throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException,
            AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRdsDatabaseRecommendationProjectedMetricsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetRdsDatabaseRecommendationProjectedMetricsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getRdsDatabaseRecommendationProjectedMetricsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRdsDatabaseRecommendationProjectedMetricsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRDSDatabaseRecommendationProjectedMetrics");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRdsDatabaseRecommendationProjectedMetricsRequest, GetRdsDatabaseRecommendationProjectedMetricsResponse>()
                            .withOperationName("GetRDSDatabaseRecommendationProjectedMetrics")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(getRdsDatabaseRecommendationProjectedMetricsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRdsDatabaseRecommendationProjectedMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns Amazon Aurora and RDS database recommendations.
     * </p>
     * <p>
     * Compute Optimizer generates recommendations for Amazon Aurora and RDS databases that meet a specific set of
     * requirements. For more information, see the <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and
     * requirements</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getRdsDatabaseRecommendationsRequest
     * @return Result of the GetRDSDatabaseRecommendations operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetRDSDatabaseRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRDSDatabaseRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRdsDatabaseRecommendationsResponse getRDSDatabaseRecommendations(
            GetRdsDatabaseRecommendationsRequest getRdsDatabaseRecommendationsRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRdsDatabaseRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRdsDatabaseRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRdsDatabaseRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRdsDatabaseRecommendationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRDSDatabaseRecommendations");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRdsDatabaseRecommendationsRequest, GetRdsDatabaseRecommendationsResponse>()
                            .withOperationName("GetRDSDatabaseRecommendations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getRdsDatabaseRecommendationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRdsDatabaseRecommendationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns existing recommendation preferences, such as enhanced infrastructure metrics.
     * </p>
     * <p>
     * Use the <code>scope</code> parameter to specify which preferences to return. You can specify to return
     * preferences for an organization, a specific account ID, or a specific EC2 instance or Amazon EC2 Auto Scaling
     * group Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param getRecommendationPreferencesRequest
     * @return Result of the GetRecommendationPreferences operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetRecommendationPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRecommendationPreferencesResponse getRecommendationPreferences(
            GetRecommendationPreferencesRequest getRecommendationPreferencesRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRecommendationPreferencesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRecommendationPreferencesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRecommendationPreferencesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRecommendationPreferencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecommendationPreferences");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRecommendationPreferencesRequest, GetRecommendationPreferencesResponse>()
                            .withOperationName("GetRecommendationPreferences").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getRecommendationPreferencesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRecommendationPreferencesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the optimization findings for an account.
     * </p>
     * <p>
     * It returns the number of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon EC2 instances in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
     * <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * EC2Amazon EC2 Auto Scaling groups in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon EBS volumes in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda functions in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon ECS services in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or
     * <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Commercial software licenses in an account that are <code>InsufficientMetrics</code>, <code>NotOptimized</code>
     * or <code>Optimized</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Aurora and Amazon RDS databases in an account that are <code>Underprovisioned</code>,
     * <code>Overprovisioned</code>, <code>Optimized</code>, or <code>NotOptimized</code>.
     * </p>
     * </li>
     * </ul>
     *
     * @param getRecommendationSummariesRequest
     * @return Result of the GetRecommendationSummaries operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.GetRecommendationSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRecommendationSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRecommendationSummariesResponse getRecommendationSummaries(
            GetRecommendationSummariesRequest getRecommendationSummariesRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException,
            ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRecommendationSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRecommendationSummariesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRecommendationSummariesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRecommendationSummariesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecommendationSummaries");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRecommendationSummariesRequest, GetRecommendationSummariesResponse>()
                            .withOperationName("GetRecommendationSummaries").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getRecommendationSummariesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRecommendationSummariesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new recommendation preference or updates an existing recommendation preference, such as enhanced
     * infrastructure metrics.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param putRecommendationPreferencesRequest
     * @return Result of the PutRecommendationPreferences operation returned by the service.
     * @throws OptInRequiredException
     *         The account is not opted in to Compute Optimizer.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.PutRecommendationPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/PutRecommendationPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutRecommendationPreferencesResponse putRecommendationPreferences(
            PutRecommendationPreferencesRequest putRecommendationPreferencesRequest) throws OptInRequiredException,
            InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException,
            SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutRecommendationPreferencesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutRecommendationPreferencesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putRecommendationPreferencesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRecommendationPreferencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRecommendationPreferences");

            return clientHandler
                    .execute(new ClientExecutionParams<PutRecommendationPreferencesRequest, PutRecommendationPreferencesResponse>()
                            .withOperationName("PutRecommendationPreferences").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putRecommendationPreferencesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutRecommendationPreferencesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.
     * </p>
     * <p>
     * If the account is a management account of an organization, this action can also be used to enroll member accounts
     * of the organization.
     * </p>
     * <p>
     * You must have the appropriate permissions to opt in to Compute Optimizer, to view its recommendations, and to opt
     * out. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html">Controlling access with Amazon
     * Web Services Identity and Access Management</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * When you opt in, Compute Optimizer automatically creates a service-linked role in your account to access its
     * data. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html">Using
     * Service-Linked Roles for Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     *
     * @param updateEnrollmentStatusRequest
     * @return Result of the UpdateEnrollmentStatus operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Try your call again.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterValueException
     *         The value supplied for the input parameter is out of range or not valid.
     * @throws MissingAuthenticationTokenException
     *         The request must contain either a valid (registered) Amazon Web Services access key ID or X.509
     *         certificate.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ComputeOptimizerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ComputeOptimizerClient.UpdateEnrollmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/UpdateEnrollmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateEnrollmentStatusResponse updateEnrollmentStatus(UpdateEnrollmentStatusRequest updateEnrollmentStatusRequest)
            throws InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException,
            MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException,
            ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEnrollmentStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEnrollmentStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MissingAuthenticationToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "OptInRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OptInRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OptInRequiredException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEnrollmentStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEnrollmentStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEnrollmentStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateEnrollmentStatusRequest, UpdateEnrollmentStatusResponse>()
                            .withOperationName("UpdateEnrollmentStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateEnrollmentStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateEnrollmentStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ComputeOptimizerServiceClientConfigurationBuilder serviceConfigBuilder = new ComputeOptimizerServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ComputeOptimizerException::builder).protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.0");
    }

    @Override
    public final ComputeOptimizerServiceClientConfiguration serviceClientConfiguration() {
        return new ComputeOptimizerServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
