/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecommendationSourceType {
    EC2_INSTANCE("Ec2Instance"),
    AUTO_SCALING_GROUP("AutoScalingGroup"),
    EBS_VOLUME("EbsVolume"),
    LAMBDA_FUNCTION("LambdaFunction"),
    ECS_SERVICE("EcsService"),
    LICENSE("License"),
    RDS_DB_INSTANCE("RdsDBInstance"),
    RDS_DB_INSTANCE_STORAGE("RdsDBInstanceStorage"),
    AURORA_DB_CLUSTER_STORAGE("AuroraDBClusterStorage"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecommendationSourceType> VALUE_MAP;
    private final String value;

    private RecommendationSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecommendationSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecommendationSourceType> knownValues() {
        EnumSet<RecommendationSourceType> knownValues = EnumSet.allOf(RecommendationSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecommendationSourceType.class, RecommendationSourceType::toString);
    }
}

