/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RDSStorageFinding {
    OPTIMIZED("Optimized"),
    UNDERPROVISIONED("Underprovisioned"),
    OVERPROVISIONED("Overprovisioned"),
    NOT_OPTIMIZED("NotOptimized"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RDSStorageFinding> VALUE_MAP;
    private final String value;

    private RDSStorageFinding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RDSStorageFinding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RDSStorageFinding> knownValues() {
        EnumSet<RDSStorageFinding> knownValues = EnumSet.allOf(RDSStorageFinding.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RDSStorageFinding.class, RDSStorageFinding::toString);
    }
}

