/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExportableRDSDBField {
    RESOURCE_ARN("ResourceArn"),
    ACCOUNT_ID("AccountId"),
    ENGINE("Engine"),
    ENGINE_VERSION("EngineVersion"),
    IDLE("Idle"),
    MULTI_AZDB_INSTANCE("MultiAZDBInstance"),
    CLUSTER_WRITER("ClusterWriter"),
    CURRENT_DB_INSTANCE_CLASS("CurrentDBInstanceClass"),
    CURRENT_STORAGE_CONFIGURATION_STORAGE_TYPE("CurrentStorageConfigurationStorageType"),
    CURRENT_STORAGE_CONFIGURATION_ALLOCATED_STORAGE("CurrentStorageConfigurationAllocatedStorage"),
    CURRENT_STORAGE_CONFIGURATION_MAX_ALLOCATED_STORAGE("CurrentStorageConfigurationMaxAllocatedStorage"),
    CURRENT_STORAGE_CONFIGURATION_IOPS("CurrentStorageConfigurationIOPS"),
    CURRENT_STORAGE_CONFIGURATION_STORAGE_THROUGHPUT("CurrentStorageConfigurationStorageThroughput"),
    CURRENT_STORAGE_ESTIMATED_MONTHLY_VOLUME_IO_PS_COST_VARIATION("CurrentStorageEstimatedMonthlyVolumeIOPsCostVariation"),
    CURRENT_INSTANCE_ON_DEMAND_HOURLY_PRICE("CurrentInstanceOnDemandHourlyPrice"),
    CURRENT_STORAGE_ON_DEMAND_MONTHLY_PRICE("CurrentStorageOnDemandMonthlyPrice"),
    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),
    CURRENT_STORAGE_ESTIMATED_CLUSTER_INSTANCE_ON_DEMAND_MONTHLY_COST("CurrentStorageEstimatedClusterInstanceOnDemandMonthlyCost"),
    CURRENT_STORAGE_ESTIMATED_CLUSTER_STORAGE_ON_DEMAND_MONTHLY_COST("CurrentStorageEstimatedClusterStorageOnDemandMonthlyCost"),
    CURRENT_STORAGE_ESTIMATED_CLUSTER_STORAGE_IO_ON_DEMAND_MONTHLY_COST("CurrentStorageEstimatedClusterStorageIOOnDemandMonthlyCost"),
    CURRENT_INSTANCE_PERFORMANCE_RISK("CurrentInstancePerformanceRisk"),
    UTILIZATION_METRICS_CPU_MAXIMUM("UtilizationMetricsCpuMaximum"),
    UTILIZATION_METRICS_MEMORY_MAXIMUM("UtilizationMetricsMemoryMaximum"),
    UTILIZATION_METRICS_EBS_VOLUME_STORAGE_SPACE_UTILIZATION_MAXIMUM("UtilizationMetricsEBSVolumeStorageSpaceUtilizationMaximum"),
    UTILIZATION_METRICS_NETWORK_RECEIVE_THROUGHPUT_MAXIMUM("UtilizationMetricsNetworkReceiveThroughputMaximum"),
    UTILIZATION_METRICS_NETWORK_TRANSMIT_THROUGHPUT_MAXIMUM("UtilizationMetricsNetworkTransmitThroughputMaximum"),
    UTILIZATION_METRICS_EBS_VOLUME_READ_IOPS_MAXIMUM("UtilizationMetricsEBSVolumeReadIOPSMaximum"),
    UTILIZATION_METRICS_EBS_VOLUME_WRITE_IOPS_MAXIMUM("UtilizationMetricsEBSVolumeWriteIOPSMaximum"),
    UTILIZATION_METRICS_EBS_VOLUME_READ_THROUGHPUT_MAXIMUM("UtilizationMetricsEBSVolumeReadThroughputMaximum"),
    UTILIZATION_METRICS_EBS_VOLUME_WRITE_THROUGHPUT_MAXIMUM("UtilizationMetricsEBSVolumeWriteThroughputMaximum"),
    UTILIZATION_METRICS_DATABASE_CONNECTIONS_MAXIMUM("UtilizationMetricsDatabaseConnectionsMaximum"),
    UTILIZATION_METRICS_STORAGE_NETWORK_RECEIVE_THROUGHPUT_MAXIMUM("UtilizationMetricsStorageNetworkReceiveThroughputMaximum"),
    UTILIZATION_METRICS_STORAGE_NETWORK_TRANSMIT_THROUGHPUT_MAXIMUM("UtilizationMetricsStorageNetworkTransmitThroughputMaximum"),
    UTILIZATION_METRICS_AURORA_MEMORY_HEALTH_STATE_MAXIMUM("UtilizationMetricsAuroraMemoryHealthStateMaximum"),
    UTILIZATION_METRICS_AURORA_MEMORY_NUM_DECLINED_SQL_TOTAL_MAXIMUM("UtilizationMetricsAuroraMemoryNumDeclinedSqlTotalMaximum"),
    UTILIZATION_METRICS_AURORA_MEMORY_NUM_KILL_CONN_TOTAL_MAXIMUM("UtilizationMetricsAuroraMemoryNumKillConnTotalMaximum"),
    UTILIZATION_METRICS_AURORA_MEMORY_NUM_KILL_QUERY_TOTAL_MAXIMUM("UtilizationMetricsAuroraMemoryNumKillQueryTotalMaximum"),
    UTILIZATION_METRICS_READ_IOPS_EPHEMERAL_STORAGE_MAXIMUM("UtilizationMetricsReadIOPSEphemeralStorageMaximum"),
    UTILIZATION_METRICS_WRITE_IOPS_EPHEMERAL_STORAGE_MAXIMUM("UtilizationMetricsWriteIOPSEphemeralStorageMaximum"),
    UTILIZATION_METRICS_VOLUME_BYTES_USED_AVERAGE("UtilizationMetricsVolumeBytesUsedAverage"),
    UTILIZATION_METRICS_VOLUME_READ_IO_PS_AVERAGE("UtilizationMetricsVolumeReadIOPsAverage"),
    UTILIZATION_METRICS_VOLUME_WRITE_IO_PS_AVERAGE("UtilizationMetricsVolumeWriteIOPsAverage"),
    INSTANCE_FINDING("InstanceFinding"),
    INSTANCE_FINDING_REASON_CODES("InstanceFindingReasonCodes"),
    STORAGE_FINDING("StorageFinding"),
    STORAGE_FINDING_REASON_CODES("StorageFindingReasonCodes"),
    INSTANCE_RECOMMENDATION_OPTIONS_DB_INSTANCE_CLASS("InstanceRecommendationOptionsDBInstanceClass"),
    INSTANCE_RECOMMENDATION_OPTIONS_RANK("InstanceRecommendationOptionsRank"),
    INSTANCE_RECOMMENDATION_OPTIONS_PERFORMANCE_RISK("InstanceRecommendationOptionsPerformanceRisk"),
    INSTANCE_RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_CPU_MAXIMUM("InstanceRecommendationOptionsProjectedUtilizationMetricsCpuMaximum"),
    STORAGE_RECOMMENDATION_OPTIONS_STORAGE_TYPE("StorageRecommendationOptionsStorageType"),
    STORAGE_RECOMMENDATION_OPTIONS_ALLOCATED_STORAGE("StorageRecommendationOptionsAllocatedStorage"),
    STORAGE_RECOMMENDATION_OPTIONS_MAX_ALLOCATED_STORAGE("StorageRecommendationOptionsMaxAllocatedStorage"),
    STORAGE_RECOMMENDATION_OPTIONS_IOPS("StorageRecommendationOptionsIOPS"),
    STORAGE_RECOMMENDATION_OPTIONS_STORAGE_THROUGHPUT("StorageRecommendationOptionsStorageThroughput"),
    STORAGE_RECOMMENDATION_OPTIONS_RANK("StorageRecommendationOptionsRank"),
    STORAGE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_VOLUME_IO_PS_COST_VARIATION("StorageRecommendationOptionsEstimatedMonthlyVolumeIOPsCostVariation"),
    INSTANCE_RECOMMENDATION_OPTIONS_INSTANCE_ON_DEMAND_HOURLY_PRICE("InstanceRecommendationOptionsInstanceOnDemandHourlyPrice"),
    INSTANCE_RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("InstanceRecommendationOptionsSavingsOpportunityPercentage"),
    INSTANCE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY("InstanceRecommendationOptionsEstimatedMonthlySavingsCurrency"),
    INSTANCE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("InstanceRecommendationOptionsEstimatedMonthlySavingsValue"),
    INSTANCE_RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_PERCENTAGE("InstanceRecommendationOptionsSavingsOpportunityAfterDiscountsPercentage"),
    INSTANCE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY_AFTER_DISCOUNTS("InstanceRecommendationOptionsEstimatedMonthlySavingsCurrencyAfterDiscounts"),
    INSTANCE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE_AFTER_DISCOUNTS("InstanceRecommendationOptionsEstimatedMonthlySavingsValueAfterDiscounts"),
    STORAGE_RECOMMENDATION_OPTIONS_ON_DEMAND_MONTHLY_PRICE("StorageRecommendationOptionsOnDemandMonthlyPrice"),
    STORAGE_RECOMMENDATION_OPTIONS_ESTIMATED_CLUSTER_INSTANCE_ON_DEMAND_MONTHLY_COST("StorageRecommendationOptionsEstimatedClusterInstanceOnDemandMonthlyCost"),
    STORAGE_RECOMMENDATION_OPTIONS_ESTIMATED_CLUSTER_STORAGE_ON_DEMAND_MONTHLY_COST("StorageRecommendationOptionsEstimatedClusterStorageOnDemandMonthlyCost"),
    STORAGE_RECOMMENDATION_OPTIONS_ESTIMATED_CLUSTER_STORAGE_IO_ON_DEMAND_MONTHLY_COST("StorageRecommendationOptionsEstimatedClusterStorageIOOnDemandMonthlyCost"),
    STORAGE_RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("StorageRecommendationOptionsSavingsOpportunityPercentage"),
    STORAGE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY("StorageRecommendationOptionsEstimatedMonthlySavingsCurrency"),
    STORAGE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("StorageRecommendationOptionsEstimatedMonthlySavingsValue"),
    STORAGE_RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_PERCENTAGE("StorageRecommendationOptionsSavingsOpportunityAfterDiscountsPercentage"),
    STORAGE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY_AFTER_DISCOUNTS("StorageRecommendationOptionsEstimatedMonthlySavingsCurrencyAfterDiscounts"),
    STORAGE_RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE_AFTER_DISCOUNTS("StorageRecommendationOptionsEstimatedMonthlySavingsValueAfterDiscounts"),
    EFFECTIVE_RECOMMENDATION_PREFERENCES_CPU_VENDOR_ARCHITECTURES("EffectiveRecommendationPreferencesCpuVendorArchitectures"),
    EFFECTIVE_RECOMMENDATION_PREFERENCES_ENHANCED_INFRASTRUCTURE_METRICS("EffectiveRecommendationPreferencesEnhancedInfrastructureMetrics"),
    EFFECTIVE_RECOMMENDATION_PREFERENCES_LOOK_BACK_PERIOD("EffectiveRecommendationPreferencesLookBackPeriod"),
    EFFECTIVE_RECOMMENDATION_PREFERENCES_SAVINGS_ESTIMATION_MODE("EffectiveRecommendationPreferencesSavingsEstimationMode"),
    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),
    TAGS("Tags"),
    DB_CLUSTER_IDENTIFIER("DBClusterIdentifier"),
    PROMOTION_TIER("PromotionTier"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableRDSDBField> VALUE_MAP;
    private final String value;

    private ExportableRDSDBField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportableRDSDBField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportableRDSDBField> knownValues() {
        EnumSet<ExportableRDSDBField> knownValues = EnumSet.allOf(ExportableRDSDBField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExportableRDSDBField.class, ExportableRDSDBField::toString);
    }
}

