/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerRequest;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceName;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferenceNamesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ResourceType;
import software.amazon.awssdk.services.computeoptimizer.model.Scope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRecommendationPreferencesRequest
extends ComputeOptimizerRequest
implements ToCopyableBuilder<Builder, DeleteRecommendationPreferencesRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(DeleteRecommendationPreferencesRequest.getter(DeleteRecommendationPreferencesRequest::resourceTypeAsString)).setter(DeleteRecommendationPreferencesRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<Scope> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scope").getter(DeleteRecommendationPreferencesRequest.getter(DeleteRecommendationPreferencesRequest::scope)).setter(DeleteRecommendationPreferencesRequest.setter(Builder::scope)).constructor(Scope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<List<String>> RECOMMENDATION_PREFERENCE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationPreferenceNames").getter(DeleteRecommendationPreferencesRequest.getter(DeleteRecommendationPreferencesRequest::recommendationPreferenceNamesAsStrings)).setter(DeleteRecommendationPreferencesRequest.setter(Builder::recommendationPreferenceNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationPreferenceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, SCOPE_FIELD, RECOMMENDATION_PREFERENCE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteRecommendationPreferencesRequest.memberNameToFieldInitializer();
    private final String resourceType;
    private final Scope scope;
    private final List<String> recommendationPreferenceNames;

    private DeleteRecommendationPreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.scope = builder.scope;
        this.recommendationPreferenceNames = builder.recommendationPreferenceNames;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final Scope scope() {
        return this.scope;
    }

    public final List<RecommendationPreferenceName> recommendationPreferenceNames() {
        return RecommendationPreferenceNamesCopier.copyStringToEnum(this.recommendationPreferenceNames);
    }

    public final boolean hasRecommendationPreferenceNames() {
        return this.recommendationPreferenceNames != null && !(this.recommendationPreferenceNames instanceof SdkAutoConstructList);
    }

    public final List<String> recommendationPreferenceNamesAsStrings() {
        return this.recommendationPreferenceNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationPreferenceNames() ? this.recommendationPreferenceNamesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRecommendationPreferencesRequest)) {
            return false;
        }
        DeleteRecommendationPreferencesRequest other = (DeleteRecommendationPreferencesRequest)((Object)obj);
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.scope(), other.scope()) && this.hasRecommendationPreferenceNames() == other.hasRecommendationPreferenceNames() && Objects.equals(this.recommendationPreferenceNamesAsStrings(), other.recommendationPreferenceNamesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRecommendationPreferencesRequest").add("ResourceType", (Object)this.resourceTypeAsString()).add("Scope", (Object)this.scope()).add("RecommendationPreferenceNames", this.hasRecommendationPreferenceNames() ? this.recommendationPreferenceNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "recommendationPreferenceNames": {
                return Optional.ofNullable(clazz.cast(this.recommendationPreferenceNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("recommendationPreferenceNames", RECOMMENDATION_PREFERENCE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRecommendationPreferencesRequest, T> g) {
        return obj -> g.apply((DeleteRecommendationPreferencesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerRequest.BuilderImpl
    implements Builder {
        private String resourceType;
        private Scope scope;
        private List<String> recommendationPreferenceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRecommendationPreferencesRequest model) {
            super(model);
            this.resourceType(model.resourceType);
            this.scope(model.scope);
            this.recommendationPreferenceNamesWithStrings(model.recommendationPreferenceNames);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Scope.Builder getScope() {
            return this.scope != null ? this.scope.toBuilder() : null;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final Collection<String> getRecommendationPreferenceNames() {
            if (this.recommendationPreferenceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationPreferenceNames;
        }

        public final void setRecommendationPreferenceNames(Collection<String> recommendationPreferenceNames) {
            this.recommendationPreferenceNames = RecommendationPreferenceNamesCopier.copy(recommendationPreferenceNames);
        }

        @Override
        public final Builder recommendationPreferenceNamesWithStrings(Collection<String> recommendationPreferenceNames) {
            this.recommendationPreferenceNames = RecommendationPreferenceNamesCopier.copy(recommendationPreferenceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationPreferenceNamesWithStrings(String ... recommendationPreferenceNames) {
            this.recommendationPreferenceNamesWithStrings(Arrays.asList(recommendationPreferenceNames));
            return this;
        }

        @Override
        public final Builder recommendationPreferenceNames(Collection<RecommendationPreferenceName> recommendationPreferenceNames) {
            this.recommendationPreferenceNames = RecommendationPreferenceNamesCopier.copyEnumToString(recommendationPreferenceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationPreferenceNames(RecommendationPreferenceName ... recommendationPreferenceNames) {
            this.recommendationPreferenceNames(Arrays.asList(recommendationPreferenceNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRecommendationPreferencesRequest build() {
            return new DeleteRecommendationPreferencesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRecommendationPreferencesRequest> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder scope(Scope var1);

        default public Builder scope(Consumer<Scope.Builder> scope) {
            return this.scope((Scope)((Scope.Builder)Scope.builder().applyMutation(scope)).build());
        }

        public Builder recommendationPreferenceNamesWithStrings(Collection<String> var1);

        public Builder recommendationPreferenceNamesWithStrings(String ... var1);

        public Builder recommendationPreferenceNames(Collection<RecommendationPreferenceName> var1);

        public Builder recommendationPreferenceNames(RecommendationPreferenceName ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

