/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationError;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationErrorsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendation;
import software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLicenseRecommendationsResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, GetLicenseRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetLicenseRecommendationsResponse.getter(GetLicenseRecommendationsResponse::nextToken)).setter(GetLicenseRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<LicenseRecommendation>> LICENSE_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("licenseRecommendations").getter(GetLicenseRecommendationsResponse.getter(GetLicenseRecommendationsResponse::licenseRecommendations)).setter(GetLicenseRecommendationsResponse.setter(Builder::licenseRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GetRecommendationError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(GetLicenseRecommendationsResponse.getter(GetLicenseRecommendationsResponse::errors)).setter(GetLicenseRecommendationsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetRecommendationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, LICENSE_RECOMMENDATIONS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLicenseRecommendationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<LicenseRecommendation> licenseRecommendations;
    private final List<GetRecommendationError> errors;

    private GetLicenseRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.licenseRecommendations = builder.licenseRecommendations;
        this.errors = builder.errors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasLicenseRecommendations() {
        return this.licenseRecommendations != null && !(this.licenseRecommendations instanceof SdkAutoConstructList);
    }

    public final List<LicenseRecommendation> licenseRecommendations() {
        return this.licenseRecommendations;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<GetRecommendationError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseRecommendations() ? this.licenseRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLicenseRecommendationsResponse)) {
            return false;
        }
        GetLicenseRecommendationsResponse other = (GetLicenseRecommendationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasLicenseRecommendations() == other.hasLicenseRecommendations() && Objects.equals(this.licenseRecommendations(), other.licenseRecommendations()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"GetLicenseRecommendationsResponse").add("NextToken", (Object)this.nextToken()).add("LicenseRecommendations", this.hasLicenseRecommendations() ? this.licenseRecommendations() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "licenseRecommendations": {
                return Optional.ofNullable(clazz.cast(this.licenseRecommendations()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("licenseRecommendations", LICENSE_RECOMMENDATIONS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLicenseRecommendationsResponse, T> g) {
        return obj -> g.apply((GetLicenseRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<LicenseRecommendation> licenseRecommendations = DefaultSdkAutoConstructList.getInstance();
        private List<GetRecommendationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLicenseRecommendationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.licenseRecommendations(model.licenseRecommendations);
            this.errors(model.errors);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<LicenseRecommendation.Builder> getLicenseRecommendations() {
            List<LicenseRecommendation.Builder> result = LicenseRecommendationsCopier.copyToBuilder(this.licenseRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseRecommendations(Collection<LicenseRecommendation.BuilderImpl> licenseRecommendations) {
            this.licenseRecommendations = LicenseRecommendationsCopier.copyFromBuilder(licenseRecommendations);
        }

        @Override
        public final Builder licenseRecommendations(Collection<LicenseRecommendation> licenseRecommendations) {
            this.licenseRecommendations = LicenseRecommendationsCopier.copy(licenseRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseRecommendations(LicenseRecommendation ... licenseRecommendations) {
            this.licenseRecommendations(Arrays.asList(licenseRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseRecommendations(Consumer<LicenseRecommendation.Builder> ... licenseRecommendations) {
            this.licenseRecommendations(Stream.of(licenseRecommendations).map(c -> (LicenseRecommendation)((LicenseRecommendation.Builder)LicenseRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GetRecommendationError.Builder> getErrors() {
            List<GetRecommendationError.Builder> result = GetRecommendationErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<GetRecommendationError.BuilderImpl> errors) {
            this.errors = GetRecommendationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<GetRecommendationError> errors) {
            this.errors = GetRecommendationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(GetRecommendationError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<GetRecommendationError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (GetRecommendationError)((GetRecommendationError.Builder)GetRecommendationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetLicenseRecommendationsResponse build() {
            return new GetLicenseRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLicenseRecommendationsResponse> {
        public Builder nextToken(String var1);

        public Builder licenseRecommendations(Collection<LicenseRecommendation> var1);

        public Builder licenseRecommendations(LicenseRecommendation ... var1);

        public Builder licenseRecommendations(Consumer<LicenseRecommendation.Builder> ... var1);

        public Builder errors(Collection<GetRecommendationError> var1);

        public Builder errors(GetRecommendationError ... var1);

        public Builder errors(Consumer<GetRecommendationError.Builder> ... var1);
    }
}

