/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.AccountIdsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerRequest;
import software.amazon.awssdk.services.computeoptimizer.model.EBSFilter;
import software.amazon.awssdk.services.computeoptimizer.model.EBSFiltersCopier;
import software.amazon.awssdk.services.computeoptimizer.model.VolumeArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEbsVolumeRecommendationsRequest
extends ComputeOptimizerRequest
implements ToCopyableBuilder<Builder, GetEbsVolumeRecommendationsRequest> {
    private static final SdkField<List<String>> VOLUME_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumeArns").getter(GetEbsVolumeRecommendationsRequest.getter(GetEbsVolumeRecommendationsRequest::volumeArns)).setter(GetEbsVolumeRecommendationsRequest.setter(Builder::volumeArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetEbsVolumeRecommendationsRequest.getter(GetEbsVolumeRecommendationsRequest::nextToken)).setter(GetEbsVolumeRecommendationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetEbsVolumeRecommendationsRequest.getter(GetEbsVolumeRecommendationsRequest::maxResults)).setter(GetEbsVolumeRecommendationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<List<EBSFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(GetEbsVolumeRecommendationsRequest.getter(GetEbsVolumeRecommendationsRequest::filters)).setter(GetEbsVolumeRecommendationsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EBSFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(GetEbsVolumeRecommendationsRequest.getter(GetEbsVolumeRecommendationsRequest::accountIds)).setter(GetEbsVolumeRecommendationsRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARNS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD, ACCOUNT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEbsVolumeRecommendationsRequest.memberNameToFieldInitializer();
    private final List<String> volumeArns;
    private final String nextToken;
    private final Integer maxResults;
    private final List<EBSFilter> filters;
    private final List<String> accountIds;

    private GetEbsVolumeRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.volumeArns = builder.volumeArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.accountIds = builder.accountIds;
    }

    public final boolean hasVolumeArns() {
        return this.volumeArns != null && !(this.volumeArns instanceof SdkAutoConstructList);
    }

    public final List<String> volumeArns() {
        return this.volumeArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<EBSFilter> filters() {
        return this.filters;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeArns() ? this.volumeArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEbsVolumeRecommendationsRequest)) {
            return false;
        }
        GetEbsVolumeRecommendationsRequest other = (GetEbsVolumeRecommendationsRequest)((Object)obj);
        return this.hasVolumeArns() == other.hasVolumeArns() && Objects.equals(this.volumeArns(), other.volumeArns()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds());
    }

    public final String toString() {
        return ToString.builder((String)"GetEbsVolumeRecommendationsRequest").add("VolumeArns", this.hasVolumeArns() ? this.volumeArns() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Filters", this.hasFilters() ? this.filters() : null).add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "volumeArns": {
                return Optional.ofNullable(clazz.cast(this.volumeArns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("volumeArns", VOLUME_ARNS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEbsVolumeRecommendationsRequest, T> g) {
        return obj -> g.apply((GetEbsVolumeRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerRequest.BuilderImpl
    implements Builder {
        private List<String> volumeArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;
        private List<EBSFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEbsVolumeRecommendationsRequest model) {
            super(model);
            this.volumeArns(model.volumeArns);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filters(model.filters);
            this.accountIds(model.accountIds);
        }

        public final Collection<String> getVolumeArns() {
            if (this.volumeArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.volumeArns;
        }

        public final void setVolumeArns(Collection<String> volumeArns) {
            this.volumeArns = VolumeArnsCopier.copy(volumeArns);
        }

        @Override
        public final Builder volumeArns(Collection<String> volumeArns) {
            this.volumeArns = VolumeArnsCopier.copy(volumeArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeArns(String ... volumeArns) {
            this.volumeArns(Arrays.asList(volumeArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<EBSFilter.Builder> getFilters() {
            List<EBSFilter.Builder> result = EBSFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<EBSFilter.BuilderImpl> filters) {
            this.filters = EBSFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<EBSFilter> filters) {
            this.filters = EBSFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(EBSFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<EBSFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (EBSFilter)((EBSFilter.Builder)EBSFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEbsVolumeRecommendationsRequest build() {
            return new GetEbsVolumeRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComputeOptimizerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEbsVolumeRecommendationsRequest> {
        public Builder volumeArns(Collection<String> var1);

        public Builder volumeArns(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filters(Collection<EBSFilter> var1);

        public Builder filters(EBSFilter ... var1);

        public Builder filters(Consumer<EBSFilter.Builder> ... var1);

        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

