/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeConfiguration> {
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeType").getter(VolumeConfiguration.getter(VolumeConfiguration::volumeType)).setter(VolumeConfiguration.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("volumeSize").getter(VolumeConfiguration.getter(VolumeConfiguration::volumeSize)).setter(VolumeConfiguration.setter(Builder::volumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSize").build()}).build();
    private static final SdkField<Integer> VOLUME_BASELINE_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("volumeBaselineIOPS").getter(VolumeConfiguration.getter(VolumeConfiguration::volumeBaselineIOPS)).setter(VolumeConfiguration.setter(Builder::volumeBaselineIOPS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeBaselineIOPS").build()}).build();
    private static final SdkField<Integer> VOLUME_BURST_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("volumeBurstIOPS").getter(VolumeConfiguration.getter(VolumeConfiguration::volumeBurstIOPS)).setter(VolumeConfiguration.setter(Builder::volumeBurstIOPS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeBurstIOPS").build()}).build();
    private static final SdkField<Integer> VOLUME_BASELINE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("volumeBaselineThroughput").getter(VolumeConfiguration.getter(VolumeConfiguration::volumeBaselineThroughput)).setter(VolumeConfiguration.setter(Builder::volumeBaselineThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeBaselineThroughput").build()}).build();
    private static final SdkField<Integer> VOLUME_BURST_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("volumeBurstThroughput").getter(VolumeConfiguration.getter(VolumeConfiguration::volumeBurstThroughput)).setter(VolumeConfiguration.setter(Builder::volumeBurstThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeBurstThroughput").build()}).build();
    private static final SdkField<Boolean> ROOT_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("rootVolume").getter(VolumeConfiguration.getter(VolumeConfiguration::rootVolume)).setter(VolumeConfiguration.setter(Builder::rootVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootVolume").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_TYPE_FIELD, VOLUME_SIZE_FIELD, VOLUME_BASELINE_IOPS_FIELD, VOLUME_BURST_IOPS_FIELD, VOLUME_BASELINE_THROUGHPUT_FIELD, VOLUME_BURST_THROUGHPUT_FIELD, ROOT_VOLUME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("volumeType", VOLUME_TYPE_FIELD);
            this.put("volumeSize", VOLUME_SIZE_FIELD);
            this.put("volumeBaselineIOPS", VOLUME_BASELINE_IOPS_FIELD);
            this.put("volumeBurstIOPS", VOLUME_BURST_IOPS_FIELD);
            this.put("volumeBaselineThroughput", VOLUME_BASELINE_THROUGHPUT_FIELD);
            this.put("volumeBurstThroughput", VOLUME_BURST_THROUGHPUT_FIELD);
            this.put("rootVolume", ROOT_VOLUME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String volumeType;
    private final Integer volumeSize;
    private final Integer volumeBaselineIOPS;
    private final Integer volumeBurstIOPS;
    private final Integer volumeBaselineThroughput;
    private final Integer volumeBurstThroughput;
    private final Boolean rootVolume;

    private VolumeConfiguration(BuilderImpl builder) {
        this.volumeType = builder.volumeType;
        this.volumeSize = builder.volumeSize;
        this.volumeBaselineIOPS = builder.volumeBaselineIOPS;
        this.volumeBurstIOPS = builder.volumeBurstIOPS;
        this.volumeBaselineThroughput = builder.volumeBaselineThroughput;
        this.volumeBurstThroughput = builder.volumeBurstThroughput;
        this.rootVolume = builder.rootVolume;
    }

    public final String volumeType() {
        return this.volumeType;
    }

    public final Integer volumeSize() {
        return this.volumeSize;
    }

    public final Integer volumeBaselineIOPS() {
        return this.volumeBaselineIOPS;
    }

    public final Integer volumeBurstIOPS() {
        return this.volumeBurstIOPS;
    }

    public final Integer volumeBaselineThroughput() {
        return this.volumeBaselineThroughput;
    }

    public final Integer volumeBurstThroughput() {
        return this.volumeBurstThroughput;
    }

    public final Boolean rootVolume() {
        return this.rootVolume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeBaselineIOPS());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeBurstIOPS());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeBaselineThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeBurstThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootVolume());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeConfiguration)) {
            return false;
        }
        VolumeConfiguration other = (VolumeConfiguration)obj;
        return Objects.equals(this.volumeType(), other.volumeType()) && Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.volumeBaselineIOPS(), other.volumeBaselineIOPS()) && Objects.equals(this.volumeBurstIOPS(), other.volumeBurstIOPS()) && Objects.equals(this.volumeBaselineThroughput(), other.volumeBaselineThroughput()) && Objects.equals(this.volumeBurstThroughput(), other.volumeBurstThroughput()) && Objects.equals(this.rootVolume(), other.rootVolume());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeConfiguration").add("VolumeType", (Object)this.volumeType()).add("VolumeSize", (Object)this.volumeSize()).add("VolumeBaselineIOPS", (Object)this.volumeBaselineIOPS()).add("VolumeBurstIOPS", (Object)this.volumeBurstIOPS()).add("VolumeBaselineThroughput", (Object)this.volumeBaselineThroughput()).add("VolumeBurstThroughput", (Object)this.volumeBurstThroughput()).add("RootVolume", (Object)this.rootVolume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "volumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeType()));
            }
            case "volumeSize": {
                return Optional.ofNullable(clazz.cast(this.volumeSize()));
            }
            case "volumeBaselineIOPS": {
                return Optional.ofNullable(clazz.cast(this.volumeBaselineIOPS()));
            }
            case "volumeBurstIOPS": {
                return Optional.ofNullable(clazz.cast(this.volumeBurstIOPS()));
            }
            case "volumeBaselineThroughput": {
                return Optional.ofNullable(clazz.cast(this.volumeBaselineThroughput()));
            }
            case "volumeBurstThroughput": {
                return Optional.ofNullable(clazz.cast(this.volumeBurstThroughput()));
            }
            case "rootVolume": {
                return Optional.ofNullable(clazz.cast(this.rootVolume()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VolumeConfiguration, T> g) {
        return obj -> g.apply((VolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeType;
        private Integer volumeSize;
        private Integer volumeBaselineIOPS;
        private Integer volumeBurstIOPS;
        private Integer volumeBaselineThroughput;
        private Integer volumeBurstThroughput;
        private Boolean rootVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeConfiguration model) {
            this.volumeType(model.volumeType);
            this.volumeSize(model.volumeSize);
            this.volumeBaselineIOPS(model.volumeBaselineIOPS);
            this.volumeBurstIOPS(model.volumeBurstIOPS);
            this.volumeBaselineThroughput(model.volumeBaselineThroughput);
            this.volumeBurstThroughput(model.volumeBurstThroughput);
            this.rootVolume(model.rootVolume);
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final Integer getVolumeBaselineIOPS() {
            return this.volumeBaselineIOPS;
        }

        public final void setVolumeBaselineIOPS(Integer volumeBaselineIOPS) {
            this.volumeBaselineIOPS = volumeBaselineIOPS;
        }

        @Override
        public final Builder volumeBaselineIOPS(Integer volumeBaselineIOPS) {
            this.volumeBaselineIOPS = volumeBaselineIOPS;
            return this;
        }

        public final Integer getVolumeBurstIOPS() {
            return this.volumeBurstIOPS;
        }

        public final void setVolumeBurstIOPS(Integer volumeBurstIOPS) {
            this.volumeBurstIOPS = volumeBurstIOPS;
        }

        @Override
        public final Builder volumeBurstIOPS(Integer volumeBurstIOPS) {
            this.volumeBurstIOPS = volumeBurstIOPS;
            return this;
        }

        public final Integer getVolumeBaselineThroughput() {
            return this.volumeBaselineThroughput;
        }

        public final void setVolumeBaselineThroughput(Integer volumeBaselineThroughput) {
            this.volumeBaselineThroughput = volumeBaselineThroughput;
        }

        @Override
        public final Builder volumeBaselineThroughput(Integer volumeBaselineThroughput) {
            this.volumeBaselineThroughput = volumeBaselineThroughput;
            return this;
        }

        public final Integer getVolumeBurstThroughput() {
            return this.volumeBurstThroughput;
        }

        public final void setVolumeBurstThroughput(Integer volumeBurstThroughput) {
            this.volumeBurstThroughput = volumeBurstThroughput;
        }

        @Override
        public final Builder volumeBurstThroughput(Integer volumeBurstThroughput) {
            this.volumeBurstThroughput = volumeBurstThroughput;
            return this;
        }

        public final Boolean getRootVolume() {
            return this.rootVolume;
        }

        public final void setRootVolume(Boolean rootVolume) {
            this.rootVolume = rootVolume;
        }

        @Override
        public final Builder rootVolume(Boolean rootVolume) {
            this.rootVolume = rootVolume;
            return this;
        }

        public VolumeConfiguration build() {
            return new VolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeConfiguration> {
        public Builder volumeType(String var1);

        public Builder volumeSize(Integer var1);

        public Builder volumeBaselineIOPS(Integer var1);

        public Builder volumeBurstIOPS(Integer var1);

        public Builder volumeBaselineThroughput(Integer var1);

        public Builder volumeBurstThroughput(Integer var1);

        public Builder rootVolume(Boolean var1);
    }
}

