/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LicenseModel {
    LICENSE_INCLUDED("LicenseIncluded"),
    BRING_YOUR_OWN_LICENSE("BringYourOwnLicense"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LicenseModel> VALUE_MAP;
    private final String value;

    private LicenseModel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LicenseModel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LicenseModel> knownValues() {
        EnumSet<LicenseModel> knownValues = EnumSet.allOf(LicenseModel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LicenseModel.class, LicenseModel::toString);
    }
}

