/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEc2InstanceRecommendationsRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<GetEc2InstanceRecommendationsRequest.Builder, GetEc2InstanceRecommendationsRequest> {
    private static final SdkField<List<String>> INSTANCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("instanceArns")
            .getter(getter(GetEc2InstanceRecommendationsRequest::instanceArns))
            .setter(setter(Builder::instanceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetEc2InstanceRecommendationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetEc2InstanceRecommendationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(GetEc2InstanceRecommendationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(GetEc2InstanceRecommendationsRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RecommendationPreferences> RECOMMENDATION_PREFERENCES_FIELD = SdkField
            .<RecommendationPreferences> builder(MarshallingType.SDK_POJO).memberName("recommendationPreferences")
            .getter(getter(GetEc2InstanceRecommendationsRequest::recommendationPreferences))
            .setter(setter(Builder::recommendationPreferences)).constructor(RecommendationPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationPreferences").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARNS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD, ACCOUNT_IDS_FIELD, RECOMMENDATION_PREFERENCES_FIELD));

    private final List<String> instanceArns;

    private final String nextToken;

    private final Integer maxResults;

    private final List<Filter> filters;

    private final List<String> accountIds;

    private final RecommendationPreferences recommendationPreferences;

    private GetEc2InstanceRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArns = builder.instanceArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.accountIds = builder.accountIds;
        this.recommendationPreferences = builder.recommendationPreferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceArns() {
        return instanceArns != null && !(instanceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the instances for which to return recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the instances for which to return recommendations.
     */
    public final List<String> instanceArns() {
        return instanceArns;
    }

    /**
     * <p>
     * The token to advance to the next page of instance recommendations.
     * </p>
     * 
     * @return The token to advance to the next page of instance recommendations.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of instance recommendations to return with a single request.
     * </p>
     * <p>
     * To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of instance recommendations to return with a single request.</p>
     *         <p>
     *         To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects to specify a filter that returns a more specific list of instance recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return An array of objects to specify a filter that returns a more specific list of instance recommendations.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account for which to return instance recommendations.
     * </p>
     * <p>
     * If your account is the management account of an organization, use this parameter to specify the member account
     * for which you want to return instance recommendations.
     * </p>
     * <p>
     * Only one account ID can be specified per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account for which to return instance recommendations.</p>
     *         <p>
     *         If your account is the management account of an organization, use this parameter to specify the member
     *         account for which you want to return instance recommendations.
     *         </p>
     *         <p>
     *         Only one account ID can be specified per request.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * An object to specify the preferences for the Amazon EC2 instance recommendations to return in the response.
     * </p>
     * 
     * @return An object to specify the preferences for the Amazon EC2 instance recommendations to return in the
     *         response.
     */
    public final RecommendationPreferences recommendationPreferences() {
        return recommendationPreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceArns() ? instanceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recommendationPreferences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEc2InstanceRecommendationsRequest)) {
            return false;
        }
        GetEc2InstanceRecommendationsRequest other = (GetEc2InstanceRecommendationsRequest) obj;
        return hasInstanceArns() == other.hasInstanceArns() && Objects.equals(instanceArns(), other.instanceArns())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && Objects.equals(recommendationPreferences(), other.recommendationPreferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEc2InstanceRecommendationsRequest")
                .add("InstanceArns", hasInstanceArns() ? instanceArns() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Filters", hasFilters() ? filters() : null)
                .add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("RecommendationPreferences", recommendationPreferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceArns":
            return Optional.ofNullable(clazz.cast(instanceArns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "recommendationPreferences":
            return Optional.ofNullable(clazz.cast(recommendationPreferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEc2InstanceRecommendationsRequest, T> g) {
        return obj -> g.apply((GetEc2InstanceRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEc2InstanceRecommendationsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the instances for which to return recommendations.
         * </p>
         * 
         * @param instanceArns
         *        The Amazon Resource Name (ARN) of the instances for which to return recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArns(Collection<String> instanceArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the instances for which to return recommendations.
         * </p>
         * 
         * @param instanceArns
         *        The Amazon Resource Name (ARN) of the instances for which to return recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArns(String... instanceArns);

        /**
         * <p>
         * The token to advance to the next page of instance recommendations.
         * </p>
         * 
         * @param nextToken
         *        The token to advance to the next page of instance recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of instance recommendations to return with a single request.
         * </p>
         * <p>
         * To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of instance recommendations to return with a single request.</p>
         *        <p>
         *        To retrieve the remaining results, make another request with the returned <code>nextToken</code>
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of instance recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that returns a more specific list of instance recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of instance recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that returns a more specific list of instance recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * An array of objects to specify a filter that returns a more specific list of instance recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.Filter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.computeoptimizer.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.Filter.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The ID of the Amazon Web Services account for which to return instance recommendations.
         * </p>
         * <p>
         * If your account is the management account of an organization, use this parameter to specify the member
         * account for which you want to return instance recommendations.
         * </p>
         * <p>
         * Only one account ID can be specified per request.
         * </p>
         * 
         * @param accountIds
         *        The ID of the Amazon Web Services account for which to return instance recommendations.</p>
         *        <p>
         *        If your account is the management account of an organization, use this parameter to specify the member
         *        account for which you want to return instance recommendations.
         *        </p>
         *        <p>
         *        Only one account ID can be specified per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The ID of the Amazon Web Services account for which to return instance recommendations.
         * </p>
         * <p>
         * If your account is the management account of an organization, use this parameter to specify the member
         * account for which you want to return instance recommendations.
         * </p>
         * <p>
         * Only one account ID can be specified per request.
         * </p>
         * 
         * @param accountIds
         *        The ID of the Amazon Web Services account for which to return instance recommendations.</p>
         *        <p>
         *        If your account is the management account of an organization, use this parameter to specify the member
         *        account for which you want to return instance recommendations.
         *        </p>
         *        <p>
         *        Only one account ID can be specified per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * An object to specify the preferences for the Amazon EC2 instance recommendations to return in the response.
         * </p>
         * 
         * @param recommendationPreferences
         *        An object to specify the preferences for the Amazon EC2 instance recommendations to return in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationPreferences(RecommendationPreferences recommendationPreferences);

        /**
         * <p>
         * An object to specify the preferences for the Amazon EC2 instance recommendations to return in the response.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationPreferences.Builder}
         * avoiding the need to create one manually via {@link RecommendationPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationPreferences.Builder#build()} is called immediately
         * and its result is passed to {@link #recommendationPreferences(RecommendationPreferences)}.
         * 
         * @param recommendationPreferences
         *        a consumer that will call methods on {@link RecommendationPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationPreferences(RecommendationPreferences)
         */
        default Builder recommendationPreferences(Consumer<RecommendationPreferences.Builder> recommendationPreferences) {
            return recommendationPreferences(RecommendationPreferences.builder().applyMutation(recommendationPreferences).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private List<String> instanceArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private RecommendationPreferences recommendationPreferences;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEc2InstanceRecommendationsRequest model) {
            super(model);
            instanceArns(model.instanceArns);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
            accountIds(model.accountIds);
            recommendationPreferences(model.recommendationPreferences);
        }

        public final Collection<String> getInstanceArns() {
            if (instanceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceArns;
        }

        public final void setInstanceArns(Collection<String> instanceArns) {
            this.instanceArns = InstanceArnsCopier.copy(instanceArns);
        }

        @Override
        public final Builder instanceArns(Collection<String> instanceArns) {
            this.instanceArns = InstanceArnsCopier.copy(instanceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceArns(String... instanceArns) {
            instanceArns(Arrays.asList(instanceArns));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final RecommendationPreferences.Builder getRecommendationPreferences() {
            return recommendationPreferences != null ? recommendationPreferences.toBuilder() : null;
        }

        public final void setRecommendationPreferences(RecommendationPreferences.BuilderImpl recommendationPreferences) {
            this.recommendationPreferences = recommendationPreferences != null ? recommendationPreferences.build() : null;
        }

        @Override
        public final Builder recommendationPreferences(RecommendationPreferences recommendationPreferences) {
            this.recommendationPreferences = recommendationPreferences;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEc2InstanceRecommendationsRequest build() {
            return new GetEc2InstanceRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
