/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ECSServiceRecommendationOptionsCopier {
    static List<ECSServiceRecommendationOption> copy(
            Collection<? extends ECSServiceRecommendationOption> ecsServiceRecommendationOptionsParam) {
        List<ECSServiceRecommendationOption> list;
        if (ecsServiceRecommendationOptionsParam == null || ecsServiceRecommendationOptionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ECSServiceRecommendationOption> modifiableList = new ArrayList<>();
            ecsServiceRecommendationOptionsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ECSServiceRecommendationOption> copyFromBuilder(
            Collection<? extends ECSServiceRecommendationOption.Builder> ecsServiceRecommendationOptionsParam) {
        List<ECSServiceRecommendationOption> list;
        if (ecsServiceRecommendationOptionsParam == null || ecsServiceRecommendationOptionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ECSServiceRecommendationOption> modifiableList = new ArrayList<>();
            ecsServiceRecommendationOptionsParam.forEach(entry -> {
                ECSServiceRecommendationOption member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ECSServiceRecommendationOption.Builder> copyToBuilder(
            Collection<? extends ECSServiceRecommendationOption> ecsServiceRecommendationOptionsParam) {
        List<ECSServiceRecommendationOption.Builder> list;
        if (ecsServiceRecommendationOptionsParam == null || ecsServiceRecommendationOptionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ECSServiceRecommendationOption.Builder> modifiableList = new ArrayList<>();
            ecsServiceRecommendationOptionsParam.forEach(entry -> {
                ECSServiceRecommendationOption.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
