/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerClient;
import software.amazon.awssdk.services.computeoptimizer.model.AccountEnrollmentStatus;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse;

public class GetEnrollmentStatusesForOrganizationIterable
implements SdkIterable<GetEnrollmentStatusesForOrganizationResponse> {
    private final ComputeOptimizerClient client;
    private final GetEnrollmentStatusesForOrganizationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetEnrollmentStatusesForOrganizationIterable(ComputeOptimizerClient client, GetEnrollmentStatusesForOrganizationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetEnrollmentStatusesForOrganizationResponseFetcher();
    }

    public Iterator<GetEnrollmentStatusesForOrganizationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountEnrollmentStatus> accountEnrollmentStatuses() {
        Function<GetEnrollmentStatusesForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountEnrollmentStatuses() != null) {
                return response.accountEnrollmentStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetEnrollmentStatusesForOrganizationResponseFetcher
    implements SyncPageFetcher<GetEnrollmentStatusesForOrganizationResponse> {
        private GetEnrollmentStatusesForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(GetEnrollmentStatusesForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetEnrollmentStatusesForOrganizationResponse nextPage(GetEnrollmentStatusesForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return GetEnrollmentStatusesForOrganizationIterable.this.client.getEnrollmentStatusesForOrganization(GetEnrollmentStatusesForOrganizationIterable.this.firstRequest);
            }
            return GetEnrollmentStatusesForOrganizationIterable.this.client.getEnrollmentStatusesForOrganization((GetEnrollmentStatusesForOrganizationRequest)((Object)GetEnrollmentStatusesForOrganizationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

