/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.PlatformDifference;
import software.amazon.awssdk.services.computeoptimizer.model.PlatformDifferencesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ProjectedUtilizationMetricsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceRecommendationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceRecommendationOption> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(InstanceRecommendationOption.getter(InstanceRecommendationOption::instanceType)).setter(InstanceRecommendationOption.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<List<UtilizationMetric>> PROJECTED_UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projectedUtilizationMetrics").getter(InstanceRecommendationOption.getter(InstanceRecommendationOption::projectedUtilizationMetrics)).setter(InstanceRecommendationOption.setter(Builder::projectedUtilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedUtilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PLATFORM_DIFFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("platformDifferences").getter(InstanceRecommendationOption.getter(InstanceRecommendationOption::platformDifferencesAsStrings)).setter(InstanceRecommendationOption.setter(Builder::platformDifferencesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformDifferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> PERFORMANCE_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("performanceRisk").getter(InstanceRecommendationOption.getter(InstanceRecommendationOption::performanceRisk)).setter(InstanceRecommendationOption.setter(Builder::performanceRisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceRisk").build()}).build();
    private static final SdkField<Integer> RANK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("rank").getter(InstanceRecommendationOption.getter(InstanceRecommendationOption::rank)).setter(InstanceRecommendationOption.setter(Builder::rank)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()}).build();
    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunity").getter(InstanceRecommendationOption.getter(InstanceRecommendationOption::savingsOpportunity)).setter(InstanceRecommendationOption.setter(Builder::savingsOpportunity)).constructor(SavingsOpportunity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, PROJECTED_UTILIZATION_METRICS_FIELD, PLATFORM_DIFFERENCES_FIELD, PERFORMANCE_RISK_FIELD, RANK_FIELD, SAVINGS_OPPORTUNITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final List<UtilizationMetric> projectedUtilizationMetrics;
    private final List<String> platformDifferences;
    private final Double performanceRisk;
    private final Integer rank;
    private final SavingsOpportunity savingsOpportunity;

    private InstanceRecommendationOption(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.projectedUtilizationMetrics = builder.projectedUtilizationMetrics;
        this.platformDifferences = builder.platformDifferences;
        this.performanceRisk = builder.performanceRisk;
        this.rank = builder.rank;
        this.savingsOpportunity = builder.savingsOpportunity;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final boolean hasProjectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics != null && !(this.projectedUtilizationMetrics instanceof SdkAutoConstructList);
    }

    public final List<UtilizationMetric> projectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics;
    }

    public final List<PlatformDifference> platformDifferences() {
        return PlatformDifferencesCopier.copyStringToEnum(this.platformDifferences);
    }

    public final boolean hasPlatformDifferences() {
        return this.platformDifferences != null && !(this.platformDifferences instanceof SdkAutoConstructList);
    }

    public final List<String> platformDifferencesAsStrings() {
        return this.platformDifferences;
    }

    public final Double performanceRisk() {
        return this.performanceRisk;
    }

    public final Integer rank() {
        return this.rank;
    }

    public final SavingsOpportunity savingsOpportunity() {
        return this.savingsOpportunity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectedUtilizationMetrics() ? this.projectedUtilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatformDifferences() ? this.platformDifferencesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceRisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRecommendationOption)) {
            return false;
        }
        InstanceRecommendationOption other = (InstanceRecommendationOption)obj;
        return Objects.equals(this.instanceType(), other.instanceType()) && this.hasProjectedUtilizationMetrics() == other.hasProjectedUtilizationMetrics() && Objects.equals(this.projectedUtilizationMetrics(), other.projectedUtilizationMetrics()) && this.hasPlatformDifferences() == other.hasPlatformDifferences() && Objects.equals(this.platformDifferencesAsStrings(), other.platformDifferencesAsStrings()) && Objects.equals(this.performanceRisk(), other.performanceRisk()) && Objects.equals(this.rank(), other.rank()) && Objects.equals(this.savingsOpportunity(), other.savingsOpportunity());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceRecommendationOption").add("InstanceType", (Object)this.instanceType()).add("ProjectedUtilizationMetrics", this.hasProjectedUtilizationMetrics() ? this.projectedUtilizationMetrics() : null).add("PlatformDifferences", this.hasPlatformDifferences() ? this.platformDifferencesAsStrings() : null).add("PerformanceRisk", (Object)this.performanceRisk()).add("Rank", (Object)this.rank()).add("SavingsOpportunity", (Object)this.savingsOpportunity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "projectedUtilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.projectedUtilizationMetrics()));
            }
            case "platformDifferences": {
                return Optional.ofNullable(clazz.cast(this.platformDifferencesAsStrings()));
            }
            case "performanceRisk": {
                return Optional.ofNullable(clazz.cast(this.performanceRisk()));
            }
            case "rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
            case "savingsOpportunity": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceRecommendationOption, T> g) {
        return obj -> g.apply((InstanceRecommendationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private List<UtilizationMetric> projectedUtilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private List<String> platformDifferences = DefaultSdkAutoConstructList.getInstance();
        private Double performanceRisk;
        private Integer rank;
        private SavingsOpportunity savingsOpportunity;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRecommendationOption model) {
            this.instanceType(model.instanceType);
            this.projectedUtilizationMetrics(model.projectedUtilizationMetrics);
            this.platformDifferencesWithStrings(model.platformDifferences);
            this.performanceRisk(model.performanceRisk);
            this.rank(model.rank);
            this.savingsOpportunity(model.savingsOpportunity);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final List<UtilizationMetric.Builder> getProjectedUtilizationMetrics() {
            List<UtilizationMetric.Builder> result = ProjectedUtilizationMetricsCopier.copyToBuilder(this.projectedUtilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectedUtilizationMetrics(Collection<UtilizationMetric.BuilderImpl> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = ProjectedUtilizationMetricsCopier.copyFromBuilder(projectedUtilizationMetrics);
        }

        @Override
        @Transient
        public final Builder projectedUtilizationMetrics(Collection<UtilizationMetric> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = ProjectedUtilizationMetricsCopier.copy(projectedUtilizationMetrics);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(UtilizationMetric ... projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics(Arrays.asList(projectedUtilizationMetrics));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(Consumer<UtilizationMetric.Builder> ... projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics(Stream.of(projectedUtilizationMetrics).map(c -> (UtilizationMetric)((UtilizationMetric.Builder)UtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getPlatformDifferences() {
            if (this.platformDifferences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.platformDifferences;
        }

        public final void setPlatformDifferences(Collection<String> platformDifferences) {
            this.platformDifferences = PlatformDifferencesCopier.copy(platformDifferences);
        }

        @Override
        @Transient
        public final Builder platformDifferencesWithStrings(Collection<String> platformDifferences) {
            this.platformDifferences = PlatformDifferencesCopier.copy(platformDifferences);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder platformDifferencesWithStrings(String ... platformDifferences) {
            this.platformDifferencesWithStrings(Arrays.asList(platformDifferences));
            return this;
        }

        @Override
        @Transient
        public final Builder platformDifferences(Collection<PlatformDifference> platformDifferences) {
            this.platformDifferences = PlatformDifferencesCopier.copyEnumToString(platformDifferences);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder platformDifferences(PlatformDifference ... platformDifferences) {
            this.platformDifferences(Arrays.asList(platformDifferences));
            return this;
        }

        public final Double getPerformanceRisk() {
            return this.performanceRisk;
        }

        public final void setPerformanceRisk(Double performanceRisk) {
            this.performanceRisk = performanceRisk;
        }

        @Override
        @Transient
        public final Builder performanceRisk(Double performanceRisk) {
            this.performanceRisk = performanceRisk;
            return this;
        }

        public final Integer getRank() {
            return this.rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        @Transient
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return this.savingsOpportunity != null ? this.savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        @Transient
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public InstanceRecommendationOption build() {
            return new InstanceRecommendationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceRecommendationOption> {
        public Builder instanceType(String var1);

        public Builder projectedUtilizationMetrics(Collection<UtilizationMetric> var1);

        public Builder projectedUtilizationMetrics(UtilizationMetric ... var1);

        public Builder projectedUtilizationMetrics(Consumer<UtilizationMetric.Builder> ... var1);

        public Builder platformDifferencesWithStrings(Collection<String> var1);

        public Builder platformDifferencesWithStrings(String ... var1);

        public Builder platformDifferences(Collection<PlatformDifference> var1);

        public Builder platformDifferences(PlatformDifference ... var1);

        public Builder performanceRisk(Double var1);

        public Builder rank(Integer var1);

        public Builder savingsOpportunity(SavingsOpportunity var1);

        default public Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return this.savingsOpportunity((SavingsOpportunity)((SavingsOpportunity.Builder)SavingsOpportunity.builder().applyMutation(savingsOpportunity)).build());
        }
    }
}

