/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LambdaFunctionMetricStatistic {
    MAXIMUM("Maximum"),
    AVERAGE("Average"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LambdaFunctionMetricStatistic> VALUE_MAP;
    private final String value;

    private LambdaFunctionMetricStatistic(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LambdaFunctionMetricStatistic fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LambdaFunctionMetricStatistic> knownValues() {
        EnumSet<LambdaFunctionMetricStatistic> knownValues = EnumSet.allOf(LambdaFunctionMetricStatistic.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LambdaFunctionMetricStatistic.class, LambdaFunctionMetricStatistic::toString);
    }
}

