/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerRequest;
import software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics;
import software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference;
import software.amazon.awssdk.services.computeoptimizer.model.ResourceType;
import software.amazon.awssdk.services.computeoptimizer.model.Scope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecommendationPreferencesRequest
extends ComputeOptimizerRequest
implements ToCopyableBuilder<Builder, PutRecommendationPreferencesRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(PutRecommendationPreferencesRequest.getter(PutRecommendationPreferencesRequest::resourceTypeAsString)).setter(PutRecommendationPreferencesRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<Scope> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scope").getter(PutRecommendationPreferencesRequest.getter(PutRecommendationPreferencesRequest::scope)).setter(PutRecommendationPreferencesRequest.setter(Builder::scope)).constructor(Scope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<String> ENHANCED_INFRASTRUCTURE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enhancedInfrastructureMetrics").getter(PutRecommendationPreferencesRequest.getter(PutRecommendationPreferencesRequest::enhancedInfrastructureMetricsAsString)).setter(PutRecommendationPreferencesRequest.setter(Builder::enhancedInfrastructureMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedInfrastructureMetrics").build()}).build();
    private static final SdkField<String> INFERRED_WORKLOAD_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inferredWorkloadTypes").getter(PutRecommendationPreferencesRequest.getter(PutRecommendationPreferencesRequest::inferredWorkloadTypesAsString)).setter(PutRecommendationPreferencesRequest.setter(Builder::inferredWorkloadTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferredWorkloadTypes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, SCOPE_FIELD, ENHANCED_INFRASTRUCTURE_METRICS_FIELD, INFERRED_WORKLOAD_TYPES_FIELD));
    private final String resourceType;
    private final Scope scope;
    private final String enhancedInfrastructureMetrics;
    private final String inferredWorkloadTypes;

    private PutRecommendationPreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.scope = builder.scope;
        this.enhancedInfrastructureMetrics = builder.enhancedInfrastructureMetrics;
        this.inferredWorkloadTypes = builder.inferredWorkloadTypes;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final Scope scope() {
        return this.scope;
    }

    public final EnhancedInfrastructureMetrics enhancedInfrastructureMetrics() {
        return EnhancedInfrastructureMetrics.fromValue(this.enhancedInfrastructureMetrics);
    }

    public final String enhancedInfrastructureMetricsAsString() {
        return this.enhancedInfrastructureMetrics;
    }

    public final InferredWorkloadTypesPreference inferredWorkloadTypes() {
        return InferredWorkloadTypesPreference.fromValue(this.inferredWorkloadTypes);
    }

    public final String inferredWorkloadTypesAsString() {
        return this.inferredWorkloadTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedInfrastructureMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferredWorkloadTypesAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecommendationPreferencesRequest)) {
            return false;
        }
        PutRecommendationPreferencesRequest other = (PutRecommendationPreferencesRequest)((Object)obj);
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.enhancedInfrastructureMetricsAsString(), other.enhancedInfrastructureMetricsAsString()) && Objects.equals(this.inferredWorkloadTypesAsString(), other.inferredWorkloadTypesAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutRecommendationPreferencesRequest").add("ResourceType", (Object)this.resourceTypeAsString()).add("Scope", (Object)this.scope()).add("EnhancedInfrastructureMetrics", (Object)this.enhancedInfrastructureMetricsAsString()).add("InferredWorkloadTypes", (Object)this.inferredWorkloadTypesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "enhancedInfrastructureMetrics": {
                return Optional.ofNullable(clazz.cast(this.enhancedInfrastructureMetricsAsString()));
            }
            case "inferredWorkloadTypes": {
                return Optional.ofNullable(clazz.cast(this.inferredWorkloadTypesAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecommendationPreferencesRequest, T> g) {
        return obj -> g.apply((PutRecommendationPreferencesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerRequest.BuilderImpl
    implements Builder {
        private String resourceType;
        private Scope scope;
        private String enhancedInfrastructureMetrics;
        private String inferredWorkloadTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecommendationPreferencesRequest model) {
            super(model);
            this.resourceType(model.resourceType);
            this.scope(model.scope);
            this.enhancedInfrastructureMetrics(model.enhancedInfrastructureMetrics);
            this.inferredWorkloadTypes(model.inferredWorkloadTypes);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Scope.Builder getScope() {
            return this.scope != null ? this.scope.toBuilder() : null;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        @Transient
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final String getEnhancedInfrastructureMetrics() {
            return this.enhancedInfrastructureMetrics;
        }

        public final void setEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
        }

        @Override
        @Transient
        public final Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
            return this;
        }

        @Override
        @Transient
        public final Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics(enhancedInfrastructureMetrics == null ? null : enhancedInfrastructureMetrics.toString());
            return this;
        }

        public final String getInferredWorkloadTypes() {
            return this.inferredWorkloadTypes;
        }

        public final void setInferredWorkloadTypes(String inferredWorkloadTypes) {
            this.inferredWorkloadTypes = inferredWorkloadTypes;
        }

        @Override
        @Transient
        public final Builder inferredWorkloadTypes(String inferredWorkloadTypes) {
            this.inferredWorkloadTypes = inferredWorkloadTypes;
            return this;
        }

        @Override
        @Transient
        public final Builder inferredWorkloadTypes(InferredWorkloadTypesPreference inferredWorkloadTypes) {
            this.inferredWorkloadTypes(inferredWorkloadTypes == null ? null : inferredWorkloadTypes.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRecommendationPreferencesRequest build() {
            return new PutRecommendationPreferencesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComputeOptimizerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRecommendationPreferencesRequest> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder scope(Scope var1);

        default public Builder scope(Consumer<Scope.Builder> scope) {
            return this.scope((Scope)((Scope.Builder)Scope.builder().applyMutation(scope)).build());
        }

        public Builder enhancedInfrastructureMetrics(String var1);

        public Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics var1);

        public Builder inferredWorkloadTypes(String var1);

        public Builder inferredWorkloadTypes(InferredWorkloadTypesPreference var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

