/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationSource> {
    private static final SdkField<String> RECOMMENDATION_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationSourceArn").getter(RecommendationSource.getter(RecommendationSource::recommendationSourceArn)).setter(RecommendationSource.setter(Builder::recommendationSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationSourceArn").build()}).build();
    private static final SdkField<String> RECOMMENDATION_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationSourceType").getter(RecommendationSource.getter(RecommendationSource::recommendationSourceTypeAsString)).setter(RecommendationSource.setter(Builder::recommendationSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationSourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_SOURCE_ARN_FIELD, RECOMMENDATION_SOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recommendationSourceArn;
    private final String recommendationSourceType;

    private RecommendationSource(BuilderImpl builder) {
        this.recommendationSourceArn = builder.recommendationSourceArn;
        this.recommendationSourceType = builder.recommendationSourceType;
    }

    public final String recommendationSourceArn() {
        return this.recommendationSourceArn;
    }

    public final RecommendationSourceType recommendationSourceType() {
        return RecommendationSourceType.fromValue(this.recommendationSourceType);
    }

    public final String recommendationSourceTypeAsString() {
        return this.recommendationSourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationSourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSource)) {
            return false;
        }
        RecommendationSource other = (RecommendationSource)obj;
        return Objects.equals(this.recommendationSourceArn(), other.recommendationSourceArn()) && Objects.equals(this.recommendationSourceTypeAsString(), other.recommendationSourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationSource").add("RecommendationSourceArn", (Object)this.recommendationSourceArn()).add("RecommendationSourceType", (Object)this.recommendationSourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommendationSourceArn": {
                return Optional.ofNullable(clazz.cast(this.recommendationSourceArn()));
            }
            case "recommendationSourceType": {
                return Optional.ofNullable(clazz.cast(this.recommendationSourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSource, T> g) {
        return obj -> g.apply((RecommendationSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommendationSourceArn;
        private String recommendationSourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSource model) {
            this.recommendationSourceArn(model.recommendationSourceArn);
            this.recommendationSourceType(model.recommendationSourceType);
        }

        public final String getRecommendationSourceArn() {
            return this.recommendationSourceArn;
        }

        public final void setRecommendationSourceArn(String recommendationSourceArn) {
            this.recommendationSourceArn = recommendationSourceArn;
        }

        @Override
        @Transient
        public final Builder recommendationSourceArn(String recommendationSourceArn) {
            this.recommendationSourceArn = recommendationSourceArn;
            return this;
        }

        public final String getRecommendationSourceType() {
            return this.recommendationSourceType;
        }

        public final void setRecommendationSourceType(String recommendationSourceType) {
            this.recommendationSourceType = recommendationSourceType;
        }

        @Override
        @Transient
        public final Builder recommendationSourceType(String recommendationSourceType) {
            this.recommendationSourceType = recommendationSourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder recommendationSourceType(RecommendationSourceType recommendationSourceType) {
            this.recommendationSourceType(recommendationSourceType == null ? null : recommendationSourceType.toString());
            return this;
        }

        public RecommendationSource build() {
            return new RecommendationSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationSource> {
        public Builder recommendationSourceArn(String var1);

        public Builder recommendationSourceType(String var1);

        public Builder recommendationSourceType(RecommendationSourceType var1);
    }
}

