/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture;
import software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecturesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EffectiveRecommendationPreferences
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EffectiveRecommendationPreferences> {
    private static final SdkField<List<String>> CPU_VENDOR_ARCHITECTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cpuVendorArchitectures").getter(EffectiveRecommendationPreferences.getter(EffectiveRecommendationPreferences::cpuVendorArchitecturesAsStrings)).setter(EffectiveRecommendationPreferences.setter(Builder::cpuVendorArchitecturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuVendorArchitectures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENHANCED_INFRASTRUCTURE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enhancedInfrastructureMetrics").getter(EffectiveRecommendationPreferences.getter(EffectiveRecommendationPreferences::enhancedInfrastructureMetricsAsString)).setter(EffectiveRecommendationPreferences.setter(Builder::enhancedInfrastructureMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedInfrastructureMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_VENDOR_ARCHITECTURES_FIELD, ENHANCED_INFRASTRUCTURE_METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> cpuVendorArchitectures;
    private final String enhancedInfrastructureMetrics;

    private EffectiveRecommendationPreferences(BuilderImpl builder) {
        this.cpuVendorArchitectures = builder.cpuVendorArchitectures;
        this.enhancedInfrastructureMetrics = builder.enhancedInfrastructureMetrics;
    }

    public final List<CpuVendorArchitecture> cpuVendorArchitectures() {
        return CpuVendorArchitecturesCopier.copyStringToEnum(this.cpuVendorArchitectures);
    }

    public final boolean hasCpuVendorArchitectures() {
        return this.cpuVendorArchitectures != null && !(this.cpuVendorArchitectures instanceof SdkAutoConstructList);
    }

    public final List<String> cpuVendorArchitecturesAsStrings() {
        return this.cpuVendorArchitectures;
    }

    public final EnhancedInfrastructureMetrics enhancedInfrastructureMetrics() {
        return EnhancedInfrastructureMetrics.fromValue(this.enhancedInfrastructureMetrics);
    }

    public final String enhancedInfrastructureMetricsAsString() {
        return this.enhancedInfrastructureMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCpuVendorArchitectures() ? this.cpuVendorArchitecturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedInfrastructureMetricsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectiveRecommendationPreferences)) {
            return false;
        }
        EffectiveRecommendationPreferences other = (EffectiveRecommendationPreferences)obj;
        return this.hasCpuVendorArchitectures() == other.hasCpuVendorArchitectures() && Objects.equals(this.cpuVendorArchitecturesAsStrings(), other.cpuVendorArchitecturesAsStrings()) && Objects.equals(this.enhancedInfrastructureMetricsAsString(), other.enhancedInfrastructureMetricsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EffectiveRecommendationPreferences").add("CpuVendorArchitectures", this.hasCpuVendorArchitectures() ? this.cpuVendorArchitecturesAsStrings() : null).add("EnhancedInfrastructureMetrics", (Object)this.enhancedInfrastructureMetricsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cpuVendorArchitectures": {
                return Optional.ofNullable(clazz.cast(this.cpuVendorArchitecturesAsStrings()));
            }
            case "enhancedInfrastructureMetrics": {
                return Optional.ofNullable(clazz.cast(this.enhancedInfrastructureMetricsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EffectiveRecommendationPreferences, T> g) {
        return obj -> g.apply((EffectiveRecommendationPreferences)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> cpuVendorArchitectures = DefaultSdkAutoConstructList.getInstance();
        private String enhancedInfrastructureMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectiveRecommendationPreferences model) {
            this.cpuVendorArchitecturesWithStrings(model.cpuVendorArchitectures);
            this.enhancedInfrastructureMetrics(model.enhancedInfrastructureMetrics);
        }

        public final Collection<String> getCpuVendorArchitectures() {
            if (this.cpuVendorArchitectures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cpuVendorArchitectures;
        }

        public final void setCpuVendorArchitectures(Collection<String> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copy(cpuVendorArchitectures);
        }

        @Override
        @Transient
        public final Builder cpuVendorArchitecturesWithStrings(Collection<String> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copy(cpuVendorArchitectures);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cpuVendorArchitecturesWithStrings(String ... cpuVendorArchitectures) {
            this.cpuVendorArchitecturesWithStrings(Arrays.asList(cpuVendorArchitectures));
            return this;
        }

        @Override
        @Transient
        public final Builder cpuVendorArchitectures(Collection<CpuVendorArchitecture> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copyEnumToString(cpuVendorArchitectures);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cpuVendorArchitectures(CpuVendorArchitecture ... cpuVendorArchitectures) {
            this.cpuVendorArchitectures(Arrays.asList(cpuVendorArchitectures));
            return this;
        }

        public final String getEnhancedInfrastructureMetrics() {
            return this.enhancedInfrastructureMetrics;
        }

        public final void setEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
        }

        @Override
        @Transient
        public final Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
            return this;
        }

        @Override
        @Transient
        public final Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics(enhancedInfrastructureMetrics == null ? null : enhancedInfrastructureMetrics.toString());
            return this;
        }

        public EffectiveRecommendationPreferences build() {
            return new EffectiveRecommendationPreferences(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EffectiveRecommendationPreferences> {
        public Builder cpuVendorArchitecturesWithStrings(Collection<String> var1);

        public Builder cpuVendorArchitecturesWithStrings(String ... var1);

        public Builder cpuVendorArchitectures(Collection<CpuVendorArchitecture> var1);

        public Builder cpuVendorArchitectures(CpuVendorArchitecture ... var1);

        public Builder enhancedInfrastructureMetrics(String var1);

        public Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics var1);
    }
}

