/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationSummary.Builder, RecommendationSummary> {
    private static final SdkField<List<Summary>> SUMMARIES_FIELD = SdkField
            .<List<Summary>> builder(MarshallingType.LIST)
            .memberName("summaries")
            .getter(getter(RecommendationSummary::summaries))
            .setter(setter(Builder::summaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Summary> builder(MarshallingType.SDK_POJO)
                                            .constructor(Summary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECOMMENDATION_RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("recommendationResourceType")
            .getter(getter(RecommendationSummary::recommendationResourceTypeAsString))
            .setter(setter(Builder::recommendationResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationResourceType").build())
            .build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(RecommendationSummary::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD,
            RECOMMENDATION_RESOURCE_TYPE_FIELD, ACCOUNT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Summary> summaries;

    private final String recommendationResourceType;

    private final String accountId;

    private RecommendationSummary(BuilderImpl builder) {
        this.summaries = builder.summaries;
        this.recommendationResourceType = builder.recommendationResourceType;
        this.accountId = builder.accountId;
    }

    /**
     * Returns true if the Summaries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSummaries() {
        return summaries != null && !(summaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe a recommendation summary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe a recommendation summary.
     */
    public final List<Summary> summaries() {
        return summaries;
    }

    /**
     * <p>
     * The resource type of the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationResourceType} will return {@link RecommendationSourceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #recommendationResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the recommendation.
     * @see RecommendationSourceType
     */
    public final RecommendationSourceType recommendationResourceType() {
        return RecommendationSourceType.fromValue(recommendationResourceType);
    }

    /**
     * <p>
     * The resource type of the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationResourceType} will return {@link RecommendationSourceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #recommendationResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the recommendation.
     * @see RecommendationSourceType
     */
    public final String recommendationResourceTypeAsString() {
        return recommendationResourceType;
    }

    /**
     * <p>
     * The AWS account ID of the recommendation summary.
     * </p>
     * 
     * @return The AWS account ID of the recommendation summary.
     */
    public final String accountId() {
        return accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSummaries() ? summaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recommendationResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary) obj;
        return hasSummaries() == other.hasSummaries() && Objects.equals(summaries(), other.summaries())
                && Objects.equals(recommendationResourceTypeAsString(), other.recommendationResourceTypeAsString())
                && Objects.equals(accountId(), other.accountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationSummary").add("Summaries", hasSummaries() ? summaries() : null)
                .add("RecommendationResourceType", recommendationResourceTypeAsString()).add("AccountId", accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "summaries":
            return Optional.ofNullable(clazz.cast(summaries()));
        case "recommendationResourceType":
            return Optional.ofNullable(clazz.cast(recommendationResourceTypeAsString()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSummary, T> g) {
        return obj -> g.apply((RecommendationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationSummary> {
        /**
         * <p>
         * An array of objects that describe a recommendation summary.
         * </p>
         * 
         * @param summaries
         *        An array of objects that describe a recommendation summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Collection<Summary> summaries);

        /**
         * <p>
         * An array of objects that describe a recommendation summary.
         * </p>
         * 
         * @param summaries
         *        An array of objects that describe a recommendation summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Summary... summaries);

        /**
         * <p>
         * An array of objects that describe a recommendation summary.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Summary>.Builder} avoiding the need to
         * create one manually via {@link List<Summary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Summary>.Builder#build()} is called immediately and its
         * result is passed to {@link #summaries(List<Summary>)}.
         * 
         * @param summaries
         *        a consumer that will call methods on {@link List<Summary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaries(List<Summary>)
         */
        Builder summaries(Consumer<Summary.Builder>... summaries);

        /**
         * <p>
         * The resource type of the recommendation.
         * </p>
         * 
         * @param recommendationResourceType
         *        The resource type of the recommendation.
         * @see RecommendationSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSourceType
         */
        Builder recommendationResourceType(String recommendationResourceType);

        /**
         * <p>
         * The resource type of the recommendation.
         * </p>
         * 
         * @param recommendationResourceType
         *        The resource type of the recommendation.
         * @see RecommendationSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSourceType
         */
        Builder recommendationResourceType(RecommendationSourceType recommendationResourceType);

        /**
         * <p>
         * The AWS account ID of the recommendation summary.
         * </p>
         * 
         * @param accountId
         *        The AWS account ID of the recommendation summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);
    }

    static final class BuilderImpl implements Builder {
        private List<Summary> summaries = DefaultSdkAutoConstructList.getInstance();

        private String recommendationResourceType;

        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSummary model) {
            summaries(model.summaries);
            recommendationResourceType(model.recommendationResourceType);
            accountId(model.accountId);
        }

        public final Collection<Summary.Builder> getSummaries() {
            if (summaries instanceof SdkAutoConstructList) {
                return null;
            }
            return summaries != null ? summaries.stream().map(Summary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder summaries(Collection<Summary> summaries) {
            this.summaries = SummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Summary... summaries) {
            summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<Summary.Builder>... summaries) {
            summaries(Stream.of(summaries).map(c -> Summary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSummaries(Collection<Summary.BuilderImpl> summaries) {
            this.summaries = SummariesCopier.copyFromBuilder(summaries);
        }

        public final String getRecommendationResourceType() {
            return recommendationResourceType;
        }

        @Override
        public final Builder recommendationResourceType(String recommendationResourceType) {
            this.recommendationResourceType = recommendationResourceType;
            return this;
        }

        @Override
        public final Builder recommendationResourceType(RecommendationSourceType recommendationResourceType) {
            this.recommendationResourceType(recommendationResourceType == null ? null : recommendationResourceType.toString());
            return this;
        }

        public final void setRecommendationResourceType(String recommendationResourceType) {
            this.recommendationResourceType = recommendationResourceType;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public RecommendationSummary build() {
            return new RecommendationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
