/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a recommendation export job.
 * </p>
 * <p>
 * Use the <code>DescribeRecommendationExportJobs</code> action to view your recommendation export jobs.
 * </p>
 * <p>
 * Use the <code>ExportAutoScalingGroupRecommendations</code> or <code>ExportEC2InstanceRecommendations</code> actions
 * to request an export of your recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationExportJob implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationExportJob.Builder, RecommendationExportJob> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(RecommendationExportJob::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<ExportDestination> DESTINATION_FIELD = SdkField
            .<ExportDestination> builder(MarshallingType.SDK_POJO).memberName("destination")
            .getter(getter(RecommendationExportJob::destination)).setter(setter(Builder::destination))
            .constructor(ExportDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(RecommendationExportJob::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RecommendationExportJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimestamp").getter(getter(RecommendationExportJob::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTimestamp").getter(getter(RecommendationExportJob::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(RecommendationExportJob::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            DESTINATION_FIELD, RESOURCE_TYPE_FIELD, STATUS_FIELD, CREATION_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD,
            FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final ExportDestination destination;

    private final String resourceType;

    private final String status;

    private final Instant creationTimestamp;

    private final Instant lastUpdatedTimestamp;

    private final String failureReason;

    private RecommendationExportJob(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.destination = builder.destination;
        this.resourceType = builder.resourceType;
        this.status = builder.status;
        this.creationTimestamp = builder.creationTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The identification number of the export job.
     * </p>
     * 
     * @return The identification number of the export job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * An object that describes the destination of the export file.
     * </p>
     * 
     * @return An object that describes the destination of the export file.
     */
    public final ExportDestination destination() {
        return destination;
    }

    /**
     * <p>
     * The resource type of the exported recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the exported recommendations.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type of the exported recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the exported recommendations.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The status of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the export job.
     * @see JobStatus
     */
    public final JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the export job.
     * @see JobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp of when the export job was created.
     * </p>
     * 
     * @return The timestamp of when the export job was created.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the export job was last updated.
     * </p>
     * 
     * @return The timestamp of when the export job was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The reason for an export job failure.
     * </p>
     * 
     * @return The reason for an export job failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationExportJob)) {
            return false;
        }
        RecommendationExportJob other = (RecommendationExportJob) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(destination(), other.destination())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationExportJob").add("JobId", jobId()).add("Destination", destination())
                .add("ResourceType", resourceTypeAsString()).add("Status", statusAsString())
                .add("CreationTimestamp", creationTimestamp()).add("LastUpdatedTimestamp", lastUpdatedTimestamp())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "lastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationExportJob, T> g) {
        return obj -> g.apply((RecommendationExportJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationExportJob> {
        /**
         * <p>
         * The identification number of the export job.
         * </p>
         * 
         * @param jobId
         *        The identification number of the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * An object that describes the destination of the export file.
         * </p>
         * 
         * @param destination
         *        An object that describes the destination of the export file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(ExportDestination destination);

        /**
         * <p>
         * An object that describes the destination of the export file.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportDestination.Builder} avoiding the need to
         * create one manually via {@link ExportDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(ExportDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link ExportDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(ExportDestination)
         */
        default Builder destination(Consumer<ExportDestination.Builder> destination) {
            return destination(ExportDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The resource type of the exported recommendations.
         * </p>
         * 
         * @param resourceType
         *        The resource type of the exported recommendations.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type of the exported recommendations.
         * </p>
         * 
         * @param resourceType
         *        The resource type of the exported recommendations.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The status of the export job.
         * </p>
         * 
         * @param status
         *        The status of the export job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the export job.
         * </p>
         * 
         * @param status
         *        The status of the export job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * The timestamp of when the export job was created.
         * </p>
         * 
         * @param creationTimestamp
         *        The timestamp of when the export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The timestamp of when the export job was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The timestamp of when the export job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * The reason for an export job failure.
         * </p>
         * 
         * @param failureReason
         *        The reason for an export job failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private ExportDestination destination;

        private String resourceType;

        private String status;

        private Instant creationTimestamp;

        private Instant lastUpdatedTimestamp;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationExportJob model) {
            jobId(model.jobId);
            destination(model.destination);
            resourceType(model.resourceType);
            status(model.status);
            creationTimestamp(model.creationTimestamp);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            failureReason(model.failureReason);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final ExportDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(ExportDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(ExportDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public RecommendationExportJob build() {
            return new RecommendationExportJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
