/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a recommendation option for an AWS Lambda function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionMemoryRecommendationOption implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionMemoryRecommendationOption.Builder, LambdaFunctionMemoryRecommendationOption> {
    private static final SdkField<Integer> RANK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("rank")
            .getter(getter(LambdaFunctionMemoryRecommendationOption::rank)).setter(setter(Builder::rank))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memorySize").getter(getter(LambdaFunctionMemoryRecommendationOption::memorySize))
            .setter(setter(Builder::memorySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySize").build()).build();

    private static final SdkField<List<LambdaFunctionMemoryProjectedMetric>> PROJECTED_UTILIZATION_METRICS_FIELD = SdkField
            .<List<LambdaFunctionMemoryProjectedMetric>> builder(MarshallingType.LIST)
            .memberName("projectedUtilizationMetrics")
            .getter(getter(LambdaFunctionMemoryRecommendationOption::projectedUtilizationMetrics))
            .setter(setter(Builder::projectedUtilizationMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedUtilizationMetrics")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LambdaFunctionMemoryProjectedMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(LambdaFunctionMemoryProjectedMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RANK_FIELD, MEMORY_SIZE_FIELD,
            PROJECTED_UTILIZATION_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer rank;

    private final Integer memorySize;

    private final List<LambdaFunctionMemoryProjectedMetric> projectedUtilizationMetrics;

    private LambdaFunctionMemoryRecommendationOption(BuilderImpl builder) {
        this.rank = builder.rank;
        this.memorySize = builder.memorySize;
        this.projectedUtilizationMetrics = builder.projectedUtilizationMetrics;
    }

    /**
     * <p>
     * The rank of the function recommendation option.
     * </p>
     * <p>
     * The top recommendation option is ranked as <code>1</code>.
     * </p>
     * 
     * @return The rank of the function recommendation option.</p>
     *         <p>
     *         The top recommendation option is ranked as <code>1</code>.
     */
    public final Integer rank() {
        return rank;
    }

    /**
     * <p>
     * The memory size, in MB, of the function recommendation option.
     * </p>
     * 
     * @return The memory size, in MB, of the function recommendation option.
     */
    public final Integer memorySize() {
        return memorySize;
    }

    /**
     * Returns true if the ProjectedUtilizationMetrics property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasProjectedUtilizationMetrics() {
        return projectedUtilizationMetrics != null && !(projectedUtilizationMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the projected utilization metrics of the function recommendation option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProjectedUtilizationMetrics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe the projected utilization metrics of the function recommendation
     *         option.
     */
    public final List<LambdaFunctionMemoryProjectedMetric> projectedUtilizationMetrics() {
        return projectedUtilizationMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rank());
        hashCode = 31 * hashCode + Objects.hashCode(memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectedUtilizationMetrics() ? projectedUtilizationMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionMemoryRecommendationOption)) {
            return false;
        }
        LambdaFunctionMemoryRecommendationOption other = (LambdaFunctionMemoryRecommendationOption) obj;
        return Objects.equals(rank(), other.rank()) && Objects.equals(memorySize(), other.memorySize())
                && hasProjectedUtilizationMetrics() == other.hasProjectedUtilizationMetrics()
                && Objects.equals(projectedUtilizationMetrics(), other.projectedUtilizationMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaFunctionMemoryRecommendationOption").add("Rank", rank()).add("MemorySize", memorySize())
                .add("ProjectedUtilizationMetrics", hasProjectedUtilizationMetrics() ? projectedUtilizationMetrics() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rank":
            return Optional.ofNullable(clazz.cast(rank()));
        case "memorySize":
            return Optional.ofNullable(clazz.cast(memorySize()));
        case "projectedUtilizationMetrics":
            return Optional.ofNullable(clazz.cast(projectedUtilizationMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionMemoryRecommendationOption, T> g) {
        return obj -> g.apply((LambdaFunctionMemoryRecommendationOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionMemoryRecommendationOption> {
        /**
         * <p>
         * The rank of the function recommendation option.
         * </p>
         * <p>
         * The top recommendation option is ranked as <code>1</code>.
         * </p>
         * 
         * @param rank
         *        The rank of the function recommendation option.</p>
         *        <p>
         *        The top recommendation option is ranked as <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rank(Integer rank);

        /**
         * <p>
         * The memory size, in MB, of the function recommendation option.
         * </p>
         * 
         * @param memorySize
         *        The memory size, in MB, of the function recommendation option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySize(Integer memorySize);

        /**
         * <p>
         * An array of objects that describe the projected utilization metrics of the function recommendation option.
         * </p>
         * 
         * @param projectedUtilizationMetrics
         *        An array of objects that describe the projected utilization metrics of the function recommendation
         *        option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedUtilizationMetrics(Collection<LambdaFunctionMemoryProjectedMetric> projectedUtilizationMetrics);

        /**
         * <p>
         * An array of objects that describe the projected utilization metrics of the function recommendation option.
         * </p>
         * 
         * @param projectedUtilizationMetrics
         *        An array of objects that describe the projected utilization metrics of the function recommendation
         *        option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedUtilizationMetrics(LambdaFunctionMemoryProjectedMetric... projectedUtilizationMetrics);

        /**
         * <p>
         * An array of objects that describe the projected utilization metrics of the function recommendation option.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LambdaFunctionMemoryProjectedMetric>.Builder} avoiding the need to create one manually via {@link List
         * <LambdaFunctionMemoryProjectedMetric>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LambdaFunctionMemoryProjectedMetric>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #projectedUtilizationMetrics(List<LambdaFunctionMemoryProjectedMetric>)}.
         * 
         * @param projectedUtilizationMetrics
         *        a consumer that will call methods on {@link List<LambdaFunctionMemoryProjectedMetric>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectedUtilizationMetrics(List<LambdaFunctionMemoryProjectedMetric>)
         */
        Builder projectedUtilizationMetrics(Consumer<LambdaFunctionMemoryProjectedMetric.Builder>... projectedUtilizationMetrics);
    }

    static final class BuilderImpl implements Builder {
        private Integer rank;

        private Integer memorySize;

        private List<LambdaFunctionMemoryProjectedMetric> projectedUtilizationMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionMemoryRecommendationOption model) {
            rank(model.rank);
            memorySize(model.memorySize);
            projectedUtilizationMetrics(model.projectedUtilizationMetrics);
        }

        public final Integer getRank() {
            return rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        public final Integer getMemorySize() {
            return memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        public final Collection<LambdaFunctionMemoryProjectedMetric.Builder> getProjectedUtilizationMetrics() {
            if (projectedUtilizationMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return projectedUtilizationMetrics != null ? projectedUtilizationMetrics.stream()
                    .map(LambdaFunctionMemoryProjectedMetric::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder projectedUtilizationMetrics(
                Collection<LambdaFunctionMemoryProjectedMetric> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = LambdaFunctionMemoryProjectedMetricsCopier.copy(projectedUtilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(LambdaFunctionMemoryProjectedMetric... projectedUtilizationMetrics) {
            projectedUtilizationMetrics(Arrays.asList(projectedUtilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(
                Consumer<LambdaFunctionMemoryProjectedMetric.Builder>... projectedUtilizationMetrics) {
            projectedUtilizationMetrics(Stream.of(projectedUtilizationMetrics)
                    .map(c -> LambdaFunctionMemoryProjectedMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProjectedUtilizationMetrics(
                Collection<LambdaFunctionMemoryProjectedMetric.BuilderImpl> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = LambdaFunctionMemoryProjectedMetricsCopier
                    .copyFromBuilder(projectedUtilizationMetrics);
        }

        @Override
        public LambdaFunctionMemoryRecommendationOption build() {
            return new LambdaFunctionMemoryRecommendationOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
