/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnrollmentStatusResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<GetEnrollmentStatusResponse.Builder, GetEnrollmentStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetEnrollmentStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GetEnrollmentStatusResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Boolean> MEMBER_ACCOUNTS_ENROLLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("memberAccountsEnrolled").getter(getter(GetEnrollmentStatusResponse::memberAccountsEnrolled))
            .setter(setter(Builder::memberAccountsEnrolled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountsEnrolled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_REASON_FIELD, MEMBER_ACCOUNTS_ENROLLED_FIELD));

    private final String status;

    private final String statusReason;

    private final Boolean memberAccountsEnrolled;

    private GetEnrollmentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.memberAccountsEnrolled = builder.memberAccountsEnrolled;
    }

    /**
     * <p>
     * The enrollment status of the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The enrollment status of the account.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The enrollment status of the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The enrollment status of the account.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the enrollment status of the account.
     * </p>
     * <p>
     * For example, an account might show a status of <code>Pending</code> because member accounts of an organization
     * require more time to be enrolled in the service.
     * </p>
     * 
     * @return The reason for the enrollment status of the account.</p>
     *         <p>
     *         For example, an account might show a status of <code>Pending</code> because member accounts of an
     *         organization require more time to be enrolled in the service.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Confirms the enrollment status of member accounts within the organization, if the account is a management account
     * of an organization.
     * </p>
     * 
     * @return Confirms the enrollment status of member accounts within the organization, if the account is a management
     *         account of an organization.
     */
    public final Boolean memberAccountsEnrolled() {
        return memberAccountsEnrolled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountsEnrolled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnrollmentStatusResponse)) {
            return false;
        }
        GetEnrollmentStatusResponse other = (GetEnrollmentStatusResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(memberAccountsEnrolled(), other.memberAccountsEnrolled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnrollmentStatusResponse").add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("MemberAccountsEnrolled", memberAccountsEnrolled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "memberAccountsEnrolled":
            return Optional.ofNullable(clazz.cast(memberAccountsEnrolled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnrollmentStatusResponse, T> g) {
        return obj -> g.apply((GetEnrollmentStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEnrollmentStatusResponse> {
        /**
         * <p>
         * The enrollment status of the account.
         * </p>
         * 
         * @param status
         *        The enrollment status of the account.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The enrollment status of the account.
         * </p>
         * 
         * @param status
         *        The enrollment status of the account.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The reason for the enrollment status of the account.
         * </p>
         * <p>
         * For example, an account might show a status of <code>Pending</code> because member accounts of an
         * organization require more time to be enrolled in the service.
         * </p>
         * 
         * @param statusReason
         *        The reason for the enrollment status of the account.</p>
         *        <p>
         *        For example, an account might show a status of <code>Pending</code> because member accounts of an
         *        organization require more time to be enrolled in the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Confirms the enrollment status of member accounts within the organization, if the account is a management
         * account of an organization.
         * </p>
         * 
         * @param memberAccountsEnrolled
         *        Confirms the enrollment status of member accounts within the organization, if the account is a
         *        management account of an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountsEnrolled(Boolean memberAccountsEnrolled);
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private String status;

        private String statusReason;

        private Boolean memberAccountsEnrolled;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnrollmentStatusResponse model) {
            super(model);
            status(model.status);
            statusReason(model.statusReason);
            memberAccountsEnrolled(model.memberAccountsEnrolled);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Boolean getMemberAccountsEnrolled() {
            return memberAccountsEnrolled;
        }

        @Override
        public final Builder memberAccountsEnrolled(Boolean memberAccountsEnrolled) {
            this.memberAccountsEnrolled = memberAccountsEnrolled;
            return this;
        }

        public final void setMemberAccountsEnrolled(Boolean memberAccountsEnrolled) {
            this.memberAccountsEnrolled = memberAccountsEnrolled;
        }

        @Override
        public GetEnrollmentStatusResponse build() {
            return new GetEnrollmentStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
