/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEbsVolumeRecommendationsResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<GetEbsVolumeRecommendationsResponse.Builder, GetEbsVolumeRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetEbsVolumeRecommendationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<VolumeRecommendation>> VOLUME_RECOMMENDATIONS_FIELD = SdkField
            .<List<VolumeRecommendation>> builder(MarshallingType.LIST)
            .memberName("volumeRecommendations")
            .getter(getter(GetEbsVolumeRecommendationsResponse::volumeRecommendations))
            .setter(setter(Builder::volumeRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeRecommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VolumeRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GetRecommendationError>> ERRORS_FIELD = SdkField
            .<List<GetRecommendationError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(GetEbsVolumeRecommendationsResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GetRecommendationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(GetRecommendationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VOLUME_RECOMMENDATIONS_FIELD, ERRORS_FIELD));

    private final String nextToken;

    private final List<VolumeRecommendation> volumeRecommendations;

    private final List<GetRecommendationError> errors;

    private GetEbsVolumeRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.volumeRecommendations = builder.volumeRecommendations;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The token to use to advance to the next page of volume recommendations.
     * </p>
     * <p>
     * This value is null when there are no more pages of volume recommendations to return.
     * </p>
     * 
     * @return The token to use to advance to the next page of volume recommendations.</p>
     *         <p>
     *         This value is null when there are no more pages of volume recommendations to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the VolumeRecommendations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasVolumeRecommendations() {
        return volumeRecommendations != null && !(volumeRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe volume recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVolumeRecommendations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe volume recommendations.
     */
    public final List<VolumeRecommendation> volumeRecommendations() {
        return volumeRecommendations;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe errors of the request.
     * </p>
     * <p>
     * For example, an error is returned if you request recommendations for an unsupported volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe errors of the request.</p>
     *         <p>
     *         For example, an error is returned if you request recommendations for an unsupported volume.
     */
    public final List<GetRecommendationError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeRecommendations() ? volumeRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEbsVolumeRecommendationsResponse)) {
            return false;
        }
        GetEbsVolumeRecommendationsResponse other = (GetEbsVolumeRecommendationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasVolumeRecommendations() == other.hasVolumeRecommendations()
                && Objects.equals(volumeRecommendations(), other.volumeRecommendations()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEbsVolumeRecommendationsResponse").add("NextToken", nextToken())
                .add("VolumeRecommendations", hasVolumeRecommendations() ? volumeRecommendations() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "volumeRecommendations":
            return Optional.ofNullable(clazz.cast(volumeRecommendations()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEbsVolumeRecommendationsResponse, T> g) {
        return obj -> g.apply((GetEbsVolumeRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEbsVolumeRecommendationsResponse> {
        /**
         * <p>
         * The token to use to advance to the next page of volume recommendations.
         * </p>
         * <p>
         * This value is null when there are no more pages of volume recommendations to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to advance to the next page of volume recommendations.</p>
         *        <p>
         *        This value is null when there are no more pages of volume recommendations to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of objects that describe volume recommendations.
         * </p>
         * 
         * @param volumeRecommendations
         *        An array of objects that describe volume recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeRecommendations(Collection<VolumeRecommendation> volumeRecommendations);

        /**
         * <p>
         * An array of objects that describe volume recommendations.
         * </p>
         * 
         * @param volumeRecommendations
         *        An array of objects that describe volume recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeRecommendations(VolumeRecommendation... volumeRecommendations);

        /**
         * <p>
         * An array of objects that describe volume recommendations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VolumeRecommendation>.Builder} avoiding the
         * need to create one manually via {@link List<VolumeRecommendation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VolumeRecommendation>.Builder#build()} is called immediately
         * and its result is passed to {@link #volumeRecommendations(List<VolumeRecommendation>)}.
         * 
         * @param volumeRecommendations
         *        a consumer that will call methods on {@link List<VolumeRecommendation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeRecommendations(List<VolumeRecommendation>)
         */
        Builder volumeRecommendations(Consumer<VolumeRecommendation.Builder>... volumeRecommendations);

        /**
         * <p>
         * An array of objects that describe errors of the request.
         * </p>
         * <p>
         * For example, an error is returned if you request recommendations for an unsupported volume.
         * </p>
         * 
         * @param errors
         *        An array of objects that describe errors of the request.</p>
         *        <p>
         *        For example, an error is returned if you request recommendations for an unsupported volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<GetRecommendationError> errors);

        /**
         * <p>
         * An array of objects that describe errors of the request.
         * </p>
         * <p>
         * For example, an error is returned if you request recommendations for an unsupported volume.
         * </p>
         * 
         * @param errors
         *        An array of objects that describe errors of the request.</p>
         *        <p>
         *        For example, an error is returned if you request recommendations for an unsupported volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(GetRecommendationError... errors);

        /**
         * <p>
         * An array of objects that describe errors of the request.
         * </p>
         * <p>
         * For example, an error is returned if you request recommendations for an unsupported volume.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GetRecommendationError>.Builder} avoiding
         * the need to create one manually via {@link List<GetRecommendationError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GetRecommendationError>.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<GetRecommendationError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<GetRecommendationError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<GetRecommendationError>)
         */
        Builder errors(Consumer<GetRecommendationError.Builder>... errors);
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VolumeRecommendation> volumeRecommendations = DefaultSdkAutoConstructList.getInstance();

        private List<GetRecommendationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEbsVolumeRecommendationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            volumeRecommendations(model.volumeRecommendations);
            errors(model.errors);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VolumeRecommendation.Builder> getVolumeRecommendations() {
            if (volumeRecommendations instanceof SdkAutoConstructList) {
                return null;
            }
            return volumeRecommendations != null ? volumeRecommendations.stream().map(VolumeRecommendation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumeRecommendations(Collection<VolumeRecommendation> volumeRecommendations) {
            this.volumeRecommendations = VolumeRecommendationsCopier.copy(volumeRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeRecommendations(VolumeRecommendation... volumeRecommendations) {
            volumeRecommendations(Arrays.asList(volumeRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeRecommendations(Consumer<VolumeRecommendation.Builder>... volumeRecommendations) {
            volumeRecommendations(Stream.of(volumeRecommendations)
                    .map(c -> VolumeRecommendation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumeRecommendations(Collection<VolumeRecommendation.BuilderImpl> volumeRecommendations) {
            this.volumeRecommendations = VolumeRecommendationsCopier.copyFromBuilder(volumeRecommendations);
        }

        public final Collection<GetRecommendationError.Builder> getErrors() {
            if (errors instanceof SdkAutoConstructList) {
                return null;
            }
            return errors != null ? errors.stream().map(GetRecommendationError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<GetRecommendationError> errors) {
            this.errors = GetRecommendationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(GetRecommendationError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<GetRecommendationError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> GetRecommendationError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<GetRecommendationError.BuilderImpl> errors) {
            this.errors = GetRecommendationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public GetEbsVolumeRecommendationsResponse build() {
            return new GetEbsVolumeRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
