/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportEc2InstanceRecommendationsRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<ExportEc2InstanceRecommendationsRequest.Builder, ExportEc2InstanceRecommendationsRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(ExportEc2InstanceRecommendationsRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ExportEc2InstanceRecommendationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FIELDS_TO_EXPORT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("fieldsToExport")
            .getter(getter(ExportEc2InstanceRecommendationsRequest::fieldsToExportAsStrings))
            .setter(setter(Builder::fieldsToExportWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldsToExport").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<S3DestinationConfig> S3_DESTINATION_CONFIG_FIELD = SdkField
            .<S3DestinationConfig> builder(MarshallingType.SDK_POJO).memberName("s3DestinationConfig")
            .getter(getter(ExportEc2InstanceRecommendationsRequest::s3DestinationConfig))
            .setter(setter(Builder::s3DestinationConfig)).constructor(S3DestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DestinationConfig").build())
            .build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(ExportEc2InstanceRecommendationsRequest::fileFormatAsString))
            .setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final SdkField<Boolean> INCLUDE_MEMBER_ACCOUNTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeMemberAccounts").getter(getter(ExportEc2InstanceRecommendationsRequest::includeMemberAccounts))
            .setter(setter(Builder::includeMemberAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeMemberAccounts").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, FILTERS_FIELD, FIELDS_TO_EXPORT_FIELD,
                    S3_DESTINATION_CONFIG_FIELD, FILE_FORMAT_FIELD, INCLUDE_MEMBER_ACCOUNTS_FIELD));

    private final List<String> accountIds;

    private final List<Filter> filters;

    private final List<String> fieldsToExport;

    private final S3DestinationConfig s3DestinationConfig;

    private final String fileFormat;

    private final Boolean includeMemberAccounts;

    private ExportEc2InstanceRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.filters = builder.filters;
        this.fieldsToExport = builder.fieldsToExport;
        this.s3DestinationConfig = builder.s3DestinationConfig;
        this.fileFormat = builder.fileFormat;
        this.includeMemberAccounts = builder.includeMemberAccounts;
    }

    /**
     * Returns true if the AccountIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the AWS accounts for which to export instance recommendations.
     * </p>
     * <p>
     * If your account is the management account of an organization, use this parameter to specify the member account
     * for which you want to export recommendations.
     * </p>
     * <p>
     * This parameter cannot be specified together with the include member accounts parameter. The parameters are
     * mutually exclusive.
     * </p>
     * <p>
     * Recommendations for member accounts are not included in the export if this parameter, or the include member
     * accounts parameter, is omitted.
     * </p>
     * <p>
     * You can specify multiple account IDs per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the AWS accounts for which to export instance recommendations.</p>
     *         <p>
     *         If your account is the management account of an organization, use this parameter to specify the member
     *         account for which you want to export recommendations.
     *         </p>
     *         <p>
     *         This parameter cannot be specified together with the include member accounts parameter. The parameters
     *         are mutually exclusive.
     *         </p>
     *         <p>
     *         Recommendations for member accounts are not included in the export if this parameter, or the include
     *         member accounts parameter, is omitted.
     *         </p>
     *         <p>
     *         You can specify multiple account IDs per request.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe a filter to export a more specific set of instance recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe a filter to export a more specific set of instance recommendations.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The recommendations data to include in the export file. For more information about the fields that can be
     * exported, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
     * >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFieldsToExport()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The recommendations data to include in the export file. For more information about the fields that can be
     *         exported, see <a href=
     *         "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
     *         >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
     */
    public final List<ExportableInstanceField> fieldsToExport() {
        return ExportableInstanceFieldsCopier.copyStringToEnum(fieldsToExport);
    }

    /**
     * Returns true if the FieldsToExport property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFieldsToExport() {
        return fieldsToExport != null && !(fieldsToExport instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recommendations data to include in the export file. For more information about the fields that can be
     * exported, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
     * >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFieldsToExport()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The recommendations data to include in the export file. For more information about the fields that can be
     *         exported, see <a href=
     *         "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
     *         >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
     */
    public final List<String> fieldsToExportAsStrings() {
        return fieldsToExport;
    }

    /**
     * <p>
     * An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for the
     * export job.
     * </p>
     * <p>
     * You must create the destination Amazon S3 bucket for your recommendations export before you create the export
     * job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it has
     * the required permission policy to allow Compute Optimizer to write the export file to it. If you plan to specify
     * an object prefix when you create the export job, you must include the object prefix in the policy that you add to
     * the S3 bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html"
     * >Amazon S3 Bucket Policy for Compute Optimizer</a> in the <i>Compute Optimizer user guide</i>.
     * </p>
     * 
     * @return An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix
     *         for the export job.</p>
     *         <p>
     *         You must create the destination Amazon S3 bucket for your recommendations export before you create the
     *         export job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket,
     *         ensure that it has the required permission policy to allow Compute Optimizer to write the export file to
     *         it. If you plan to specify an object prefix when you create the export job, you must include the object
     *         prefix in the policy that you add to the S3 bucket. For more information, see <a href=
     *         "https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html"
     *         >Amazon S3 Bucket Policy for Compute Optimizer</a> in the <i>Compute Optimizer user guide</i>.
     */
    public final S3DestinationConfig s3DestinationConfig() {
        return s3DestinationConfig;
    }

    /**
     * <p>
     * The format of the export file.
     * </p>
     * <p>
     * The only export file format currently supported is <code>Csv</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The format of the export file.</p>
     *         <p>
     *         The only export file format currently supported is <code>Csv</code>.
     * @see FileFormat
     */
    public final FileFormat fileFormat() {
        return FileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * The format of the export file.
     * </p>
     * <p>
     * The only export file format currently supported is <code>Csv</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The format of the export file.</p>
     *         <p>
     *         The only export file format currently supported is <code>Csv</code>.
     * @see FileFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * Indicates whether to include recommendations for resources in all member accounts of the organization if your
     * account is the management account of an organization.
     * </p>
     * <p>
     * The member accounts must also be opted in to Compute Optimizer.
     * </p>
     * <p>
     * Recommendations for member accounts of the organization are not included in the export file if this parameter is
     * omitted.
     * </p>
     * <p>
     * Recommendations for member accounts are not included in the export if this parameter, or the account IDs
     * parameter, is omitted.
     * </p>
     * 
     * @return Indicates whether to include recommendations for resources in all member accounts of the organization if
     *         your account is the management account of an organization.</p>
     *         <p>
     *         The member accounts must also be opted in to Compute Optimizer.
     *         </p>
     *         <p>
     *         Recommendations for member accounts of the organization are not included in the export file if this
     *         parameter is omitted.
     *         </p>
     *         <p>
     *         Recommendations for member accounts are not included in the export if this parameter, or the account IDs
     *         parameter, is omitted.
     */
    public final Boolean includeMemberAccounts() {
        return includeMemberAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldsToExport() ? fieldsToExportAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeMemberAccounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportEc2InstanceRecommendationsRequest)) {
            return false;
        }
        ExportEc2InstanceRecommendationsRequest other = (ExportEc2InstanceRecommendationsRequest) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasFieldsToExport() == other.hasFieldsToExport()
                && Objects.equals(fieldsToExportAsStrings(), other.fieldsToExportAsStrings())
                && Objects.equals(s3DestinationConfig(), other.s3DestinationConfig())
                && Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(includeMemberAccounts(), other.includeMemberAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportEc2InstanceRecommendationsRequest")
                .add("AccountIds", hasAccountIds() ? accountIds() : null).add("Filters", hasFilters() ? filters() : null)
                .add("FieldsToExport", hasFieldsToExport() ? fieldsToExportAsStrings() : null)
                .add("S3DestinationConfig", s3DestinationConfig()).add("FileFormat", fileFormatAsString())
                .add("IncludeMemberAccounts", includeMemberAccounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "fieldsToExport":
            return Optional.ofNullable(clazz.cast(fieldsToExportAsStrings()));
        case "s3DestinationConfig":
            return Optional.ofNullable(clazz.cast(s3DestinationConfig()));
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "includeMemberAccounts":
            return Optional.ofNullable(clazz.cast(includeMemberAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportEc2InstanceRecommendationsRequest, T> g) {
        return obj -> g.apply((ExportEc2InstanceRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportEc2InstanceRecommendationsRequest> {
        /**
         * <p>
         * The IDs of the AWS accounts for which to export instance recommendations.
         * </p>
         * <p>
         * If your account is the management account of an organization, use this parameter to specify the member
         * account for which you want to export recommendations.
         * </p>
         * <p>
         * This parameter cannot be specified together with the include member accounts parameter. The parameters are
         * mutually exclusive.
         * </p>
         * <p>
         * Recommendations for member accounts are not included in the export if this parameter, or the include member
         * accounts parameter, is omitted.
         * </p>
         * <p>
         * You can specify multiple account IDs per request.
         * </p>
         * 
         * @param accountIds
         *        The IDs of the AWS accounts for which to export instance recommendations.</p>
         *        <p>
         *        If your account is the management account of an organization, use this parameter to specify the member
         *        account for which you want to export recommendations.
         *        </p>
         *        <p>
         *        This parameter cannot be specified together with the include member accounts parameter. The parameters
         *        are mutually exclusive.
         *        </p>
         *        <p>
         *        Recommendations for member accounts are not included in the export if this parameter, or the include
         *        member accounts parameter, is omitted.
         *        </p>
         *        <p>
         *        You can specify multiple account IDs per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The IDs of the AWS accounts for which to export instance recommendations.
         * </p>
         * <p>
         * If your account is the management account of an organization, use this parameter to specify the member
         * account for which you want to export recommendations.
         * </p>
         * <p>
         * This parameter cannot be specified together with the include member accounts parameter. The parameters are
         * mutually exclusive.
         * </p>
         * <p>
         * Recommendations for member accounts are not included in the export if this parameter, or the include member
         * accounts parameter, is omitted.
         * </p>
         * <p>
         * You can specify multiple account IDs per request.
         * </p>
         * 
         * @param accountIds
         *        The IDs of the AWS accounts for which to export instance recommendations.</p>
         *        <p>
         *        If your account is the management account of an organization, use this parameter to specify the member
         *        account for which you want to export recommendations.
         *        </p>
         *        <p>
         *        This parameter cannot be specified together with the include member accounts parameter. The parameters
         *        are mutually exclusive.
         *        </p>
         *        <p>
         *        Recommendations for member accounts are not included in the export if this parameter, or the include
         *        member accounts parameter, is omitted.
         *        </p>
         *        <p>
         *        You can specify multiple account IDs per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * An array of objects that describe a filter to export a more specific set of instance recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects that describe a filter to export a more specific set of instance recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * An array of objects that describe a filter to export a more specific set of instance recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects that describe a filter to export a more specific set of instance recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * An array of objects that describe a filter to export a more specific set of instance recommendations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The recommendations data to include in the export file. For more information about the fields that can be
         * exported, see <a href=
         * "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         * >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param fieldsToExport
         *        The recommendations data to include in the export file. For more information about the fields that can
         *        be exported, see <a href=
         *        "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         *        >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsToExportWithStrings(Collection<String> fieldsToExport);

        /**
         * <p>
         * The recommendations data to include in the export file. For more information about the fields that can be
         * exported, see <a href=
         * "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         * >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param fieldsToExport
         *        The recommendations data to include in the export file. For more information about the fields that can
         *        be exported, see <a href=
         *        "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         *        >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsToExportWithStrings(String... fieldsToExport);

        /**
         * <p>
         * The recommendations data to include in the export file. For more information about the fields that can be
         * exported, see <a href=
         * "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         * >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param fieldsToExport
         *        The recommendations data to include in the export file. For more information about the fields that can
         *        be exported, see <a href=
         *        "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         *        >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsToExport(Collection<ExportableInstanceField> fieldsToExport);

        /**
         * <p>
         * The recommendations data to include in the export file. For more information about the fields that can be
         * exported, see <a href=
         * "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         * >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param fieldsToExport
         *        The recommendations data to include in the export file. For more information about the fields that can
         *        be exported, see <a href=
         *        "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         *        >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsToExport(ExportableInstanceField... fieldsToExport);

        /**
         * <p>
         * An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for
         * the export job.
         * </p>
         * <p>
         * You must create the destination Amazon S3 bucket for your recommendations export before you create the export
         * job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it
         * has the required permission policy to allow Compute Optimizer to write the export file to it. If you plan to
         * specify an object prefix when you create the export job, you must include the object prefix in the policy
         * that you add to the S3 bucket. For more information, see <a href=
         * "https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html"
         * >Amazon S3 Bucket Policy for Compute Optimizer</a> in the <i>Compute Optimizer user guide</i>.
         * </p>
         * 
         * @param s3DestinationConfig
         *        An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket name and key
         *        prefix for the export job.</p>
         *        <p>
         *        You must create the destination Amazon S3 bucket for your recommendations export before you create the
         *        export job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket,
         *        ensure that it has the required permission policy to allow Compute Optimizer to write the export file
         *        to it. If you plan to specify an object prefix when you create the export job, you must include the
         *        object prefix in the policy that you add to the S3 bucket. For more information, see <a href=
         *        "https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html"
         *        >Amazon S3 Bucket Policy for Compute Optimizer</a> in the <i>Compute Optimizer user guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationConfig(S3DestinationConfig s3DestinationConfig);

        /**
         * <p>
         * An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for
         * the export job.
         * </p>
         * <p>
         * You must create the destination Amazon S3 bucket for your recommendations export before you create the export
         * job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it
         * has the required permission policy to allow Compute Optimizer to write the export file to it. If you plan to
         * specify an object prefix when you create the export job, you must include the object prefix in the policy
         * that you add to the S3 bucket. For more information, see <a href=
         * "https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html"
         * >Amazon S3 Bucket Policy for Compute Optimizer</a> in the <i>Compute Optimizer user guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationConfig.Builder} avoiding the need
         * to create one manually via {@link S3DestinationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #s3DestinationConfig(S3DestinationConfig)}.
         * 
         * @param s3DestinationConfig
         *        a consumer that will call methods on {@link S3DestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DestinationConfig(S3DestinationConfig)
         */
        default Builder s3DestinationConfig(Consumer<S3DestinationConfig.Builder> s3DestinationConfig) {
            return s3DestinationConfig(S3DestinationConfig.builder().applyMutation(s3DestinationConfig).build());
        }

        /**
         * <p>
         * The format of the export file.
         * </p>
         * <p>
         * The only export file format currently supported is <code>Csv</code>.
         * </p>
         * 
         * @param fileFormat
         *        The format of the export file.</p>
         *        <p>
         *        The only export file format currently supported is <code>Csv</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * The format of the export file.
         * </p>
         * <p>
         * The only export file format currently supported is <code>Csv</code>.
         * </p>
         * 
         * @param fileFormat
         *        The format of the export file.</p>
         *        <p>
         *        The only export file format currently supported is <code>Csv</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder fileFormat(FileFormat fileFormat);

        /**
         * <p>
         * Indicates whether to include recommendations for resources in all member accounts of the organization if your
         * account is the management account of an organization.
         * </p>
         * <p>
         * The member accounts must also be opted in to Compute Optimizer.
         * </p>
         * <p>
         * Recommendations for member accounts of the organization are not included in the export file if this parameter
         * is omitted.
         * </p>
         * <p>
         * Recommendations for member accounts are not included in the export if this parameter, or the account IDs
         * parameter, is omitted.
         * </p>
         * 
         * @param includeMemberAccounts
         *        Indicates whether to include recommendations for resources in all member accounts of the organization
         *        if your account is the management account of an organization.</p>
         *        <p>
         *        The member accounts must also be opted in to Compute Optimizer.
         *        </p>
         *        <p>
         *        Recommendations for member accounts of the organization are not included in the export file if this
         *        parameter is omitted.
         *        </p>
         *        <p>
         *        Recommendations for member accounts are not included in the export if this parameter, or the account
         *        IDs parameter, is omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMemberAccounts(Boolean includeMemberAccounts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> fieldsToExport = DefaultSdkAutoConstructList.getInstance();

        private S3DestinationConfig s3DestinationConfig;

        private String fileFormat;

        private Boolean includeMemberAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportEc2InstanceRecommendationsRequest model) {
            super(model);
            accountIds(model.accountIds);
            filters(model.filters);
            fieldsToExportWithStrings(model.fieldsToExport);
            s3DestinationConfig(model.s3DestinationConfig);
            fileFormat(model.fileFormat);
            includeMemberAccounts(model.includeMemberAccounts);
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getFieldsToExport() {
            if (fieldsToExport instanceof SdkAutoConstructList) {
                return null;
            }
            return fieldsToExport;
        }

        @Override
        public final Builder fieldsToExportWithStrings(Collection<String> fieldsToExport) {
            this.fieldsToExport = ExportableInstanceFieldsCopier.copy(fieldsToExport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldsToExportWithStrings(String... fieldsToExport) {
            fieldsToExportWithStrings(Arrays.asList(fieldsToExport));
            return this;
        }

        @Override
        public final Builder fieldsToExport(Collection<ExportableInstanceField> fieldsToExport) {
            this.fieldsToExport = ExportableInstanceFieldsCopier.copyEnumToString(fieldsToExport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldsToExport(ExportableInstanceField... fieldsToExport) {
            fieldsToExport(Arrays.asList(fieldsToExport));
            return this;
        }

        public final void setFieldsToExport(Collection<String> fieldsToExport) {
            this.fieldsToExport = ExportableInstanceFieldsCopier.copy(fieldsToExport);
        }

        public final S3DestinationConfig.Builder getS3DestinationConfig() {
            return s3DestinationConfig != null ? s3DestinationConfig.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationConfig(S3DestinationConfig s3DestinationConfig) {
            this.s3DestinationConfig = s3DestinationConfig;
            return this;
        }

        public final void setS3DestinationConfig(S3DestinationConfig.BuilderImpl s3DestinationConfig) {
            this.s3DestinationConfig = s3DestinationConfig != null ? s3DestinationConfig.build() : null;
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        public final Boolean getIncludeMemberAccounts() {
            return includeMemberAccounts;
        }

        @Override
        public final Builder includeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
            return this;
        }

        public final void setIncludeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportEc2InstanceRecommendationsRequest build() {
            return new ExportEc2InstanceRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
