/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRecommendationExportJobsResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<DescribeRecommendationExportJobsResponse.Builder, DescribeRecommendationExportJobsResponse> {
    private static final SdkField<List<RecommendationExportJob>> RECOMMENDATION_EXPORT_JOBS_FIELD = SdkField
            .<List<RecommendationExportJob>> builder(MarshallingType.LIST)
            .memberName("recommendationExportJobs")
            .getter(getter(DescribeRecommendationExportJobsResponse::recommendationExportJobs))
            .setter(setter(Builder::recommendationExportJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationExportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationExportJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationExportJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeRecommendationExportJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RECOMMENDATION_EXPORT_JOBS_FIELD, NEXT_TOKEN_FIELD));

    private final List<RecommendationExportJob> recommendationExportJobs;

    private final String nextToken;

    private DescribeRecommendationExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationExportJobs = builder.recommendationExportJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the RecommendationExportJobs property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRecommendationExportJobs() {
        return recommendationExportJobs != null && !(recommendationExportJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe recommendation export jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecommendationExportJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe recommendation export jobs.
     */
    public final List<RecommendationExportJob> recommendationExportJobs() {
        return recommendationExportJobs;
    }

    /**
     * <p>
     * The token to use to advance to the next page of export jobs.
     * </p>
     * <p>
     * This value is null when there are no more pages of export jobs to return.
     * </p>
     * 
     * @return The token to use to advance to the next page of export jobs.</p>
     *         <p>
     *         This value is null when there are no more pages of export jobs to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendationExportJobs() ? recommendationExportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecommendationExportJobsResponse)) {
            return false;
        }
        DescribeRecommendationExportJobsResponse other = (DescribeRecommendationExportJobsResponse) obj;
        return hasRecommendationExportJobs() == other.hasRecommendationExportJobs()
                && Objects.equals(recommendationExportJobs(), other.recommendationExportJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRecommendationExportJobsResponse")
                .add("RecommendationExportJobs", hasRecommendationExportJobs() ? recommendationExportJobs() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommendationExportJobs":
            return Optional.ofNullable(clazz.cast(recommendationExportJobs()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecommendationExportJobsResponse, T> g) {
        return obj -> g.apply((DescribeRecommendationExportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRecommendationExportJobsResponse> {
        /**
         * <p>
         * An array of objects that describe recommendation export jobs.
         * </p>
         * 
         * @param recommendationExportJobs
         *        An array of objects that describe recommendation export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationExportJobs(Collection<RecommendationExportJob> recommendationExportJobs);

        /**
         * <p>
         * An array of objects that describe recommendation export jobs.
         * </p>
         * 
         * @param recommendationExportJobs
         *        An array of objects that describe recommendation export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationExportJobs(RecommendationExportJob... recommendationExportJobs);

        /**
         * <p>
         * An array of objects that describe recommendation export jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecommendationExportJob>.Builder} avoiding
         * the need to create one manually via {@link List<RecommendationExportJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecommendationExportJob>.Builder#build()} is called
         * immediately and its result is passed to {@link #recommendationExportJobs(List<RecommendationExportJob>)}.
         * 
         * @param recommendationExportJobs
         *        a consumer that will call methods on {@link List<RecommendationExportJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationExportJobs(List<RecommendationExportJob>)
         */
        Builder recommendationExportJobs(Consumer<RecommendationExportJob.Builder>... recommendationExportJobs);

        /**
         * <p>
         * The token to use to advance to the next page of export jobs.
         * </p>
         * <p>
         * This value is null when there are no more pages of export jobs to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to advance to the next page of export jobs.</p>
         *        <p>
         *        This value is null when there are no more pages of export jobs to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private List<RecommendationExportJob> recommendationExportJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecommendationExportJobsResponse model) {
            super(model);
            recommendationExportJobs(model.recommendationExportJobs);
            nextToken(model.nextToken);
        }

        public final Collection<RecommendationExportJob.Builder> getRecommendationExportJobs() {
            if (recommendationExportJobs instanceof SdkAutoConstructList) {
                return null;
            }
            return recommendationExportJobs != null ? recommendationExportJobs.stream().map(RecommendationExportJob::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendationExportJobs(Collection<RecommendationExportJob> recommendationExportJobs) {
            this.recommendationExportJobs = RecommendationExportJobsCopier.copy(recommendationExportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationExportJobs(RecommendationExportJob... recommendationExportJobs) {
            recommendationExportJobs(Arrays.asList(recommendationExportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationExportJobs(Consumer<RecommendationExportJob.Builder>... recommendationExportJobs) {
            recommendationExportJobs(Stream.of(recommendationExportJobs)
                    .map(c -> RecommendationExportJob.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendationExportJobs(Collection<RecommendationExportJob.BuilderImpl> recommendationExportJobs) {
            this.recommendationExportJobs = RecommendationExportJobsCopier.copyFromBuilder(recommendationExportJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRecommendationExportJobsResponse build() {
            return new DescribeRecommendationExportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
