/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingGroupConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingGroupConfiguration.Builder, AutoScalingGroupConfiguration> {
    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("desiredCapacity").getter(getter(AutoScalingGroupConfiguration::desiredCapacity))
            .setter(setter(Builder::desiredCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCapacity").build()).build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minSize").getter(getter(AutoScalingGroupConfiguration::minSize)).setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxSize").getter(getter(AutoScalingGroupConfiguration::maxSize)).setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSize").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(AutoScalingGroupConfiguration::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_CAPACITY_FIELD,
            MIN_SIZE_FIELD, MAX_SIZE_FIELD, INSTANCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer desiredCapacity;

    private final Integer minSize;

    private final Integer maxSize;

    private final String instanceType;

    private AutoScalingGroupConfiguration(BuilderImpl builder) {
        this.desiredCapacity = builder.desiredCapacity;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.instanceType = builder.instanceType;
    }

    /**
     * <p>
     * The desired capacity, or number of instances, for the Auto Scaling group.
     * </p>
     * 
     * @return The desired capacity, or number of instances, for the Auto Scaling group.
     */
    public final Integer desiredCapacity() {
        return desiredCapacity;
    }

    /**
     * <p>
     * The minimum size, or minimum number of instances, for the Auto Scaling group.
     * </p>
     * 
     * @return The minimum size, or minimum number of instances, for the Auto Scaling group.
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size, or maximum number of instances, for the Auto Scaling group.
     * </p>
     * 
     * @return The maximum size, or maximum number of instances, for the Auto Scaling group.
     */
    public final Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The instance type for the Auto Scaling group.
     * </p>
     * 
     * @return The instance type for the Auto Scaling group.
     */
    public final String instanceType() {
        return instanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupConfiguration)) {
            return false;
        }
        AutoScalingGroupConfiguration other = (AutoScalingGroupConfiguration) obj;
        return Objects.equals(desiredCapacity(), other.desiredCapacity()) && Objects.equals(minSize(), other.minSize())
                && Objects.equals(maxSize(), other.maxSize()) && Objects.equals(instanceType(), other.instanceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingGroupConfiguration").add("DesiredCapacity", desiredCapacity())
                .add("MinSize", minSize()).add("MaxSize", maxSize()).add("InstanceType", instanceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "desiredCapacity":
            return Optional.ofNullable(clazz.cast(desiredCapacity()));
        case "minSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "maxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupConfiguration, T> g) {
        return obj -> g.apply((AutoScalingGroupConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingGroupConfiguration> {
        /**
         * <p>
         * The desired capacity, or number of instances, for the Auto Scaling group.
         * </p>
         * 
         * @param desiredCapacity
         *        The desired capacity, or number of instances, for the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        /**
         * <p>
         * The minimum size, or minimum number of instances, for the Auto Scaling group.
         * </p>
         * 
         * @param minSize
         *        The minimum size, or minimum number of instances, for the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size, or maximum number of instances, for the Auto Scaling group.
         * </p>
         * 
         * @param maxSize
         *        The maximum size, or maximum number of instances, for the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The instance type for the Auto Scaling group.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);
    }

    static final class BuilderImpl implements Builder {
        private Integer desiredCapacity;

        private Integer minSize;

        private Integer maxSize;

        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupConfiguration model) {
            desiredCapacity(model.desiredCapacity);
            minSize(model.minSize);
            maxSize(model.maxSize);
            instanceType(model.instanceType);
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public AutoScalingGroupConfiguration build() {
            return new AutoScalingGroupConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
