/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ProjectedMetric;
import software.amazon.awssdk.services.computeoptimizer.model.ProjectedMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendedOptionProjectedMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendedOptionProjectedMetric> {
    private static final SdkField<String> RECOMMENDED_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedInstanceType").getter(RecommendedOptionProjectedMetric.getter(RecommendedOptionProjectedMetric::recommendedInstanceType)).setter(RecommendedOptionProjectedMetric.setter(Builder::recommendedInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedInstanceType").build()}).build();
    private static final SdkField<Integer> RANK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("rank").getter(RecommendedOptionProjectedMetric.getter(RecommendedOptionProjectedMetric::rank)).setter(RecommendedOptionProjectedMetric.setter(Builder::rank)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()}).build();
    private static final SdkField<List<ProjectedMetric>> PROJECTED_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projectedMetrics").getter(RecommendedOptionProjectedMetric.getter(RecommendedOptionProjectedMetric::projectedMetrics)).setter(RecommendedOptionProjectedMetric.setter(Builder::projectedMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectedMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDED_INSTANCE_TYPE_FIELD, RANK_FIELD, PROJECTED_METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recommendedInstanceType;
    private final Integer rank;
    private final List<ProjectedMetric> projectedMetrics;

    private RecommendedOptionProjectedMetric(BuilderImpl builder) {
        this.recommendedInstanceType = builder.recommendedInstanceType;
        this.rank = builder.rank;
        this.projectedMetrics = builder.projectedMetrics;
    }

    public String recommendedInstanceType() {
        return this.recommendedInstanceType;
    }

    public Integer rank() {
        return this.rank;
    }

    public boolean hasProjectedMetrics() {
        return this.projectedMetrics != null && !(this.projectedMetrics instanceof SdkAutoConstructList);
    }

    public List<ProjectedMetric> projectedMetrics() {
        return this.projectedMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectedMetrics() ? this.projectedMetrics() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendedOptionProjectedMetric)) {
            return false;
        }
        RecommendedOptionProjectedMetric other = (RecommendedOptionProjectedMetric)obj;
        return Objects.equals(this.recommendedInstanceType(), other.recommendedInstanceType()) && Objects.equals(this.rank(), other.rank()) && this.hasProjectedMetrics() == other.hasProjectedMetrics() && Objects.equals(this.projectedMetrics(), other.projectedMetrics());
    }

    public String toString() {
        return ToString.builder((String)"RecommendedOptionProjectedMetric").add("RecommendedInstanceType", (Object)this.recommendedInstanceType()).add("Rank", (Object)this.rank()).add("ProjectedMetrics", this.hasProjectedMetrics() ? this.projectedMetrics() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommendedInstanceType": {
                return Optional.ofNullable(clazz.cast(this.recommendedInstanceType()));
            }
            case "rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
            case "projectedMetrics": {
                return Optional.ofNullable(clazz.cast(this.projectedMetrics()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendedOptionProjectedMetric, T> g) {
        return obj -> g.apply((RecommendedOptionProjectedMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommendedInstanceType;
        private Integer rank;
        private List<ProjectedMetric> projectedMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendedOptionProjectedMetric model) {
            this.recommendedInstanceType(model.recommendedInstanceType);
            this.rank(model.rank);
            this.projectedMetrics(model.projectedMetrics);
        }

        public final String getRecommendedInstanceType() {
            return this.recommendedInstanceType;
        }

        @Override
        public final Builder recommendedInstanceType(String recommendedInstanceType) {
            this.recommendedInstanceType = recommendedInstanceType;
            return this;
        }

        public final void setRecommendedInstanceType(String recommendedInstanceType) {
            this.recommendedInstanceType = recommendedInstanceType;
        }

        public final Integer getRank() {
            return this.rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        public final Collection<ProjectedMetric.Builder> getProjectedMetrics() {
            if (this.projectedMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.projectedMetrics != null ? (Collection)this.projectedMetrics.stream().map(ProjectedMetric::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder projectedMetrics(Collection<ProjectedMetric> projectedMetrics) {
            this.projectedMetrics = ProjectedMetricsCopier.copy(projectedMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedMetrics(ProjectedMetric ... projectedMetrics) {
            this.projectedMetrics(Arrays.asList(projectedMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedMetrics(Consumer<ProjectedMetric.Builder> ... projectedMetrics) {
            this.projectedMetrics(Stream.of(projectedMetrics).map(c -> (ProjectedMetric)((ProjectedMetric.Builder)ProjectedMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProjectedMetrics(Collection<ProjectedMetric.BuilderImpl> projectedMetrics) {
            this.projectedMetrics = ProjectedMetricsCopier.copyFromBuilder(projectedMetrics);
        }

        public RecommendedOptionProjectedMetric build() {
            return new RecommendedOptionProjectedMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendedOptionProjectedMetric> {
        public Builder recommendedInstanceType(String var1);

        public Builder rank(Integer var1);

        public Builder projectedMetrics(Collection<ProjectedMetric> var1);

        public Builder projectedMetrics(ProjectedMetric ... var1);

        public Builder projectedMetrics(Consumer<ProjectedMetric.Builder> ... var1);
    }
}

