/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnrollmentStatusRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<UpdateEnrollmentStatusRequest.Builder, UpdateEnrollmentStatusRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEnrollmentStatusRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Boolean> INCLUDE_MEMBER_ACCOUNTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateEnrollmentStatusRequest::includeMemberAccounts)).setter(setter(Builder::includeMemberAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeMemberAccounts").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            INCLUDE_MEMBER_ACCOUNTS_FIELD));

    private final String status;

    private final Boolean includeMemberAccounts;

    private UpdateEnrollmentStatusRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.includeMemberAccounts = builder.includeMemberAccounts;
    }

    /**
     * <p>
     * The new enrollment status of the account.
     * </p>
     * <p>
     * Accepted options are <code>Active</code> or <code>Inactive</code>. You will get an error if <code>Pending</code>
     * or <code>Failed</code> are specified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The new enrollment status of the account.</p>
     *         <p>
     *         Accepted options are <code>Active</code> or <code>Inactive</code>. You will get an error if
     *         <code>Pending</code> or <code>Failed</code> are specified.
     * @see Status
     */
    public Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The new enrollment status of the account.
     * </p>
     * <p>
     * Accepted options are <code>Active</code> or <code>Inactive</code>. You will get an error if <code>Pending</code>
     * or <code>Failed</code> are specified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The new enrollment status of the account.</p>
     *         <p>
     *         Accepted options are <code>Active</code> or <code>Inactive</code>. You will get an error if
     *         <code>Pending</code> or <code>Failed</code> are specified.
     * @see Status
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates whether to enroll member accounts within the organization, if the account is a master account of an
     * organization.
     * </p>
     * 
     * @return Indicates whether to enroll member accounts within the organization, if the account is a master account
     *         of an organization.
     */
    public Boolean includeMemberAccounts() {
        return includeMemberAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeMemberAccounts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnrollmentStatusRequest)) {
            return false;
        }
        UpdateEnrollmentStatusRequest other = (UpdateEnrollmentStatusRequest) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(includeMemberAccounts(), other.includeMemberAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateEnrollmentStatusRequest").add("Status", statusAsString())
                .add("IncludeMemberAccounts", includeMemberAccounts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "includeMemberAccounts":
            return Optional.ofNullable(clazz.cast(includeMemberAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnrollmentStatusRequest, T> g) {
        return obj -> g.apply((UpdateEnrollmentStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEnrollmentStatusRequest> {
        /**
         * <p>
         * The new enrollment status of the account.
         * </p>
         * <p>
         * Accepted options are <code>Active</code> or <code>Inactive</code>. You will get an error if
         * <code>Pending</code> or <code>Failed</code> are specified.
         * </p>
         * 
         * @param status
         *        The new enrollment status of the account.</p>
         *        <p>
         *        Accepted options are <code>Active</code> or <code>Inactive</code>. You will get an error if
         *        <code>Pending</code> or <code>Failed</code> are specified.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The new enrollment status of the account.
         * </p>
         * <p>
         * Accepted options are <code>Active</code> or <code>Inactive</code>. You will get an error if
         * <code>Pending</code> or <code>Failed</code> are specified.
         * </p>
         * 
         * @param status
         *        The new enrollment status of the account.</p>
         *        <p>
         *        Accepted options are <code>Active</code> or <code>Inactive</code>. You will get an error if
         *        <code>Pending</code> or <code>Failed</code> are specified.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * Indicates whether to enroll member accounts within the organization, if the account is a master account of an
         * organization.
         * </p>
         * 
         * @param includeMemberAccounts
         *        Indicates whether to enroll member accounts within the organization, if the account is a master
         *        account of an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMemberAccounts(Boolean includeMemberAccounts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private String status;

        private Boolean includeMemberAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnrollmentStatusRequest model) {
            super(model);
            status(model.status);
            includeMemberAccounts(model.includeMemberAccounts);
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getIncludeMemberAccounts() {
            return includeMemberAccounts;
        }

        @Override
        public final Builder includeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
            return this;
        }

        public final void setIncludeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnrollmentStatusRequest build() {
            return new UpdateEnrollmentStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
