/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an extracted medical entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Entity implements SdkPojo, Serializable, ToCopyableBuilder<Entity.Builder, Entity> {
    private static final SdkField<Integer> ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Entity::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Entity::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Entity::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()).build();

    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(Entity::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Entity::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Entity::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Entity::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<Trait>> TRAITS_FIELD = SdkField
            .<List<Trait>> builder(MarshallingType.LIST)
            .getter(getter(Entity::traits))
            .setter(setter(Builder::traits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trait> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trait::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .getter(getter(Entity::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, BEGIN_OFFSET_FIELD,
            END_OFFSET_FIELD, SCORE_FIELD, TEXT_FIELD, CATEGORY_FIELD, TYPE_FIELD, TRAITS_FIELD, ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer id;

    private final Integer beginOffset;

    private final Integer endOffset;

    private final Float score;

    private final String text;

    private final String category;

    private final String type;

    private final List<Trait> traits;

    private final List<Attribute> attributes;

    private Entity(BuilderImpl builder) {
        this.id = builder.id;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.score = builder.score;
        this.text = builder.text;
        this.category = builder.category;
        this.type = builder.type;
        this.traits = builder.traits;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The numeric identifier for the entity. This is a monotonically increasing id unique within this response rather
     * than a global unique identifier.
     * </p>
     * 
     * @return The numeric identifier for the entity. This is a monotonically increasing id unique within this response
     *         rather than a global unique identifier.
     */
    public Integer id() {
        return id;
    }

    /**
     * <p>
     * The 0-based character offset in the input text that shows where the entity begins. The offset returns the UTF-8
     * code point in the string.
     * </p>
     * 
     * @return The 0-based character offset in the input text that shows where the entity begins. The offset returns the
     *         UTF-8 code point in the string.
     */
    public Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * The 0-based character offset in the input text that shows where the entity ends. The offset returns the UTF-8
     * code point in the string.
     * </p>
     * 
     * @return The 0-based character offset in the input text that shows where the entity ends. The offset returns the
     *         UTF-8 code point in the string.
     */
    public Integer endOffset() {
        return endOffset;
    }

    /**
     * <p>
     * The level of confidence that Comprehend Medical has in the accuracy of the detection.
     * </p>
     * 
     * @return The level of confidence that Comprehend Medical has in the accuracy of the detection.
     */
    public Float score() {
        return score;
    }

    /**
     * <p>
     * The segment of input text extracted as this entity.
     * </p>
     * 
     * @return The segment of input text extracted as this entity.
     */
    public String text() {
        return text;
    }

    /**
     * <p>
     * The category of the entity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the entity.
     * @see EntityType
     */
    public EntityType category() {
        return EntityType.fromValue(category);
    }

    /**
     * <p>
     * The category of the entity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the entity.
     * @see EntityType
     */
    public String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * Describes the specific type of entity with category of entities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EntitySubType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes the specific type of entity with category of entities.
     * @see EntitySubType
     */
    public EntitySubType type() {
        return EntitySubType.fromValue(type);
    }

    /**
     * <p>
     * Describes the specific type of entity with category of entities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EntitySubType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes the specific type of entity with category of entities.
     * @see EntitySubType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Contextual information for the entity
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contextual information for the entity
     */
    public List<Trait> traits() {
        return traits;
    }

    /**
     * <p>
     * The extracted attributes that relate to this entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The extracted attributes that relate to this entity.
     */
    public List<Attribute> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(traits());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(beginOffset(), other.beginOffset())
                && Objects.equals(endOffset(), other.endOffset()) && Objects.equals(score(), other.score())
                && Objects.equals(text(), other.text()) && Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(traits(), other.traits())
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Entity").add("Id", id()).add("BeginOffset", beginOffset()).add("EndOffset", endOffset())
                .add("Score", score()).add("Text", text()).add("Category", categoryAsString()).add("Type", typeAsString())
                .add("Traits", traits()).add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "BeginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "EndOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Traits":
            return Optional.ofNullable(clazz.cast(traits()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entity, T> g) {
        return obj -> g.apply((Entity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Entity> {
        /**
         * <p>
         * The numeric identifier for the entity. This is a monotonically increasing id unique within this response
         * rather than a global unique identifier.
         * </p>
         * 
         * @param id
         *        The numeric identifier for the entity. This is a monotonically increasing id unique within this
         *        response rather than a global unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Integer id);

        /**
         * <p>
         * The 0-based character offset in the input text that shows where the entity begins. The offset returns the
         * UTF-8 code point in the string.
         * </p>
         * 
         * @param beginOffset
         *        The 0-based character offset in the input text that shows where the entity begins. The offset returns
         *        the UTF-8 code point in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * The 0-based character offset in the input text that shows where the entity ends. The offset returns the UTF-8
         * code point in the string.
         * </p>
         * 
         * @param endOffset
         *        The 0-based character offset in the input text that shows where the entity ends. The offset returns
         *        the UTF-8 code point in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);

        /**
         * <p>
         * The level of confidence that Comprehend Medical has in the accuracy of the detection.
         * </p>
         * 
         * @param score
         *        The level of confidence that Comprehend Medical has in the accuracy of the detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);

        /**
         * <p>
         * The segment of input text extracted as this entity.
         * </p>
         * 
         * @param text
         *        The segment of input text extracted as this entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The category of the entity.
         * </p>
         * 
         * @param category
         *        The category of the entity.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder category(String category);

        /**
         * <p>
         * The category of the entity.
         * </p>
         * 
         * @param category
         *        The category of the entity.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder category(EntityType category);

        /**
         * <p>
         * Describes the specific type of entity with category of entities.
         * </p>
         * 
         * @param type
         *        Describes the specific type of entity with category of entities.
         * @see EntitySubType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitySubType
         */
        Builder type(String type);

        /**
         * <p>
         * Describes the specific type of entity with category of entities.
         * </p>
         * 
         * @param type
         *        Describes the specific type of entity with category of entities.
         * @see EntitySubType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitySubType
         */
        Builder type(EntitySubType type);

        /**
         * <p>
         * Contextual information for the entity
         * </p>
         * 
         * @param traits
         *        Contextual information for the entity
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traits(Collection<Trait> traits);

        /**
         * <p>
         * Contextual information for the entity
         * </p>
         * 
         * @param traits
         *        Contextual information for the entity
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traits(Trait... traits);

        /**
         * <p>
         * Contextual information for the entity
         * </p>
         * This is a convenience that creates an instance of the {@link List<Trait>.Builder} avoiding the need to create
         * one manually via {@link List<Trait>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Trait>.Builder#build()} is called immediately and its result
         * is passed to {@link #traits(List<Trait>)}.
         * 
         * @param traits
         *        a consumer that will call methods on {@link List<Trait>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traits(List<Trait>)
         */
        Builder traits(Consumer<Trait.Builder>... traits);

        /**
         * <p>
         * The extracted attributes that relate to this entity.
         * </p>
         * 
         * @param attributes
         *        The extracted attributes that relate to this entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<Attribute> attributes);

        /**
         * <p>
         * The extracted attributes that relate to this entity.
         * </p>
         * 
         * @param attributes
         *        The extracted attributes that relate to this entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Attribute... attributes);

        /**
         * <p>
         * The extracted attributes that relate to this entity.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Attribute>.Builder} avoiding the need to
         * create one manually via {@link List<Attribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Attribute>.Builder#build()} is called immediately and its
         * result is passed to {@link #attributes(List<Attribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<Attribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<Attribute>)
         */
        Builder attributes(Consumer<Attribute.Builder>... attributes);
    }

    static final class BuilderImpl implements Builder {
        private Integer id;

        private Integer beginOffset;

        private Integer endOffset;

        private Float score;

        private String text;

        private String category;

        private String type;

        private List<Trait> traits = DefaultSdkAutoConstructList.getInstance();

        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Entity model) {
            id(model.id);
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
            score(model.score);
            text(model.text);
            category(model.category);
            type(model.type);
            traits(model.traits);
            attributes(model.attributes);
        }

        public final Integer getId() {
            return id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        public final Float getScore() {
            return score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        public final String getText() {
            return text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getCategoryAsString() {
            return category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(EntityType category) {
            this.category(category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EntitySubType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Trait.Builder> getTraits() {
            return traits != null ? traits.stream().map(Trait::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder traits(Collection<Trait> traits) {
            this.traits = TraitListCopier.copy(traits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(Trait... traits) {
            traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(Consumer<Trait.Builder>... traits) {
            traits(Stream.of(traits).map(c -> Trait.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTraits(Collection<Trait.BuilderImpl> traits) {
            this.traits = TraitListCopier.copyFromBuilder(traits);
        }

        public final Collection<Attribute.Builder> getAttributes() {
            return attributes != null ? attributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> Attribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        public Entity build() {
            return new Entity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
