/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehendmedical.model.Attribute;
import software.amazon.awssdk.services.comprehendmedical.model.AttributeListCopier;
import software.amazon.awssdk.services.comprehendmedical.model.EntitySubType;
import software.amazon.awssdk.services.comprehendmedical.model.EntityType;
import software.amazon.awssdk.services.comprehendmedical.model.Trait;
import software.amazon.awssdk.services.comprehendmedical.model.TraitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Entity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Entity> {
    private static final SdkField<Integer> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Entity.getter(Entity::id)).setter(Entity.setter(Builder::id)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Entity.getter(Entity::beginOffset)).setter(Entity.setter(Builder::beginOffset)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Entity.getter(Entity::endOffset)).setter(Entity.setter(Builder::endOffset)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(Entity.getter(Entity::score)).setter(Entity.setter(Builder::score)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Entity.getter(Entity::text)).setter(Entity.setter(Builder::text)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Entity.getter(Entity::categoryAsString)).setter(Entity.setter(Builder::category)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Entity.getter(Entity::typeAsString)).setter(Entity.setter(Builder::type)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<Trait>> TRAITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Entity.getter(Entity::traits)).setter(Entity.setter(Builder::traits)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Trait::builder).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Entity.getter(Entity::attributes)).setter(Entity.setter(Builder::attributes)).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new software.amazon.awssdk.core.traits.Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, SCORE_FIELD, TEXT_FIELD, CATEGORY_FIELD, TYPE_FIELD, TRAITS_FIELD, ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer id;
    private final Integer beginOffset;
    private final Integer endOffset;
    private final Float score;
    private final String text;
    private final String category;
    private final String type;
    private final List<Trait> traits;
    private final List<Attribute> attributes;

    private Entity(BuilderImpl builder) {
        this.id = builder.id;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.score = builder.score;
        this.text = builder.text;
        this.category = builder.category;
        this.type = builder.type;
        this.traits = builder.traits;
        this.attributes = builder.attributes;
    }

    public Integer id() {
        return this.id;
    }

    public Integer beginOffset() {
        return this.beginOffset;
    }

    public Integer endOffset() {
        return this.endOffset;
    }

    public Float score() {
        return this.score;
    }

    public String text() {
        return this.text;
    }

    public EntityType category() {
        return EntityType.fromValue(this.category);
    }

    public String categoryAsString() {
        return this.category;
    }

    public EntitySubType type() {
        return EntitySubType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public List<Trait> traits() {
        return this.traits;
    }

    public List<Attribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.traits());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.traits(), other.traits()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"Entity").add("Id", (Object)this.id()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).add("Score", (Object)this.score()).add("Text", (Object)this.text()).add("Category", (Object)this.categoryAsString()).add("Type", (Object)this.typeAsString()).add("Traits", this.traits()).add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Traits": {
                return Optional.ofNullable(clazz.cast(this.traits()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entity, T> g) {
        return obj -> g.apply((Entity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer id;
        private Integer beginOffset;
        private Integer endOffset;
        private Float score;
        private String text;
        private String category;
        private String type;
        private List<Trait> traits = DefaultSdkAutoConstructList.getInstance();
        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Entity model) {
            this.id(model.id);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
            this.score(model.score);
            this.text(model.text);
            this.category(model.category);
            this.type(model.type);
            this.traits(model.traits);
            this.attributes(model.attributes);
        }

        public final Integer getId() {
            return this.id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        public final Float getScore() {
            return this.score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getCategoryAsString() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(EntityType category) {
            this.category(category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EntitySubType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Trait.Builder> getTraits() {
            return this.traits != null ? (Collection)this.traits.stream().map(Trait::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder traits(Collection<Trait> traits) {
            this.traits = TraitListCopier.copy(traits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(Trait ... traits) {
            this.traits(Arrays.asList(traits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traits(Consumer<Trait.Builder> ... traits) {
            this.traits(Stream.of(traits).map(c -> (Trait)((Trait.Builder)Trait.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTraits(Collection<Trait.BuilderImpl> traits) {
            this.traits = TraitListCopier.copyFromBuilder(traits);
        }

        public final Collection<Attribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributeListCopier.copyFromBuilder(attributes);
        }

        public Entity build() {
            return new Entity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Entity> {
        public Builder id(Integer var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);

        public Builder score(Float var1);

        public Builder text(String var1);

        public Builder category(String var1);

        public Builder category(EntityType var1);

        public Builder type(String var1);

        public Builder type(EntitySubType var1);

        public Builder traits(Collection<Trait> var1);

        public Builder traits(Trait ... var1);

        public Builder traits(Consumer<Trait.Builder> ... var1);

        public Builder attributes(Collection<Attribute> var1);

        public Builder attributes(Attribute ... var1);

        public Builder attributes(Consumer<Attribute.Builder> ... var1);
    }
}

