/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPiiEntitiesDetectionJobsResponse extends ComprehendResponse implements
        ToCopyableBuilder<ListPiiEntitiesDetectionJobsResponse.Builder, ListPiiEntitiesDetectionJobsResponse> {
    private static final SdkField<List<PiiEntitiesDetectionJobProperties>> PII_ENTITIES_DETECTION_JOB_PROPERTIES_LIST_FIELD = SdkField
            .<List<PiiEntitiesDetectionJobProperties>> builder(MarshallingType.LIST)
            .memberName("PiiEntitiesDetectionJobPropertiesList")
            .getter(getter(ListPiiEntitiesDetectionJobsResponse::piiEntitiesDetectionJobPropertiesList))
            .setter(setter(Builder::piiEntitiesDetectionJobPropertiesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PiiEntitiesDetectionJobPropertiesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PiiEntitiesDetectionJobProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(PiiEntitiesDetectionJobProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPiiEntitiesDetectionJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PII_ENTITIES_DETECTION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PiiEntitiesDetectionJobProperties> piiEntitiesDetectionJobPropertiesList;

    private final String nextToken;

    private ListPiiEntitiesDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.piiEntitiesDetectionJobPropertiesList = builder.piiEntitiesDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PiiEntitiesDetectionJobPropertiesList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasPiiEntitiesDetectionJobPropertiesList() {
        return piiEntitiesDetectionJobPropertiesList != null
                && !(piiEntitiesDetectionJobPropertiesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing the properties of each job that is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPiiEntitiesDetectionJobPropertiesList}
     * method.
     * </p>
     * 
     * @return A list containing the properties of each job that is returned.
     */
    public final List<PiiEntitiesDetectionJobProperties> piiEntitiesDetectionJobPropertiesList() {
        return piiEntitiesDetectionJobPropertiesList;
    }

    /**
     * <p>
     * Identifies the next page of results to return.
     * </p>
     * 
     * @return Identifies the next page of results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPiiEntitiesDetectionJobPropertiesList() ? piiEntitiesDetectionJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPiiEntitiesDetectionJobsResponse)) {
            return false;
        }
        ListPiiEntitiesDetectionJobsResponse other = (ListPiiEntitiesDetectionJobsResponse) obj;
        return hasPiiEntitiesDetectionJobPropertiesList() == other.hasPiiEntitiesDetectionJobPropertiesList()
                && Objects.equals(piiEntitiesDetectionJobPropertiesList(), other.piiEntitiesDetectionJobPropertiesList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListPiiEntitiesDetectionJobsResponse")
                .add("PiiEntitiesDetectionJobPropertiesList",
                        hasPiiEntitiesDetectionJobPropertiesList() ? piiEntitiesDetectionJobPropertiesList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PiiEntitiesDetectionJobPropertiesList":
            return Optional.ofNullable(clazz.cast(piiEntitiesDetectionJobPropertiesList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PiiEntitiesDetectionJobPropertiesList", PII_ENTITIES_DETECTION_JOB_PROPERTIES_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPiiEntitiesDetectionJobsResponse, T> g) {
        return obj -> g.apply((ListPiiEntitiesDetectionJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPiiEntitiesDetectionJobsResponse> {
        /**
         * <p>
         * A list containing the properties of each job that is returned.
         * </p>
         * 
         * @param piiEntitiesDetectionJobPropertiesList
         *        A list containing the properties of each job that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntitiesDetectionJobPropertiesList(
                Collection<PiiEntitiesDetectionJobProperties> piiEntitiesDetectionJobPropertiesList);

        /**
         * <p>
         * A list containing the properties of each job that is returned.
         * </p>
         * 
         * @param piiEntitiesDetectionJobPropertiesList
         *        A list containing the properties of each job that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntitiesDetectionJobPropertiesList(PiiEntitiesDetectionJobProperties... piiEntitiesDetectionJobPropertiesList);

        /**
         * <p>
         * A list containing the properties of each job that is returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionJobProperties.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionJobProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionJobProperties.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #piiEntitiesDetectionJobPropertiesList(List<PiiEntitiesDetectionJobProperties>)}.
         * 
         * @param piiEntitiesDetectionJobPropertiesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #piiEntitiesDetectionJobPropertiesList(java.util.Collection<PiiEntitiesDetectionJobProperties>)
         */
        Builder piiEntitiesDetectionJobPropertiesList(
                Consumer<PiiEntitiesDetectionJobProperties.Builder>... piiEntitiesDetectionJobPropertiesList);

        /**
         * <p>
         * Identifies the next page of results to return.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<PiiEntitiesDetectionJobProperties> piiEntitiesDetectionJobPropertiesList = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPiiEntitiesDetectionJobsResponse model) {
            super(model);
            piiEntitiesDetectionJobPropertiesList(model.piiEntitiesDetectionJobPropertiesList);
            nextToken(model.nextToken);
        }

        public final List<PiiEntitiesDetectionJobProperties.Builder> getPiiEntitiesDetectionJobPropertiesList() {
            List<PiiEntitiesDetectionJobProperties.Builder> result = PiiEntitiesDetectionJobPropertiesListCopier
                    .copyToBuilder(this.piiEntitiesDetectionJobPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPiiEntitiesDetectionJobPropertiesList(
                Collection<PiiEntitiesDetectionJobProperties.BuilderImpl> piiEntitiesDetectionJobPropertiesList) {
            this.piiEntitiesDetectionJobPropertiesList = PiiEntitiesDetectionJobPropertiesListCopier
                    .copyFromBuilder(piiEntitiesDetectionJobPropertiesList);
        }

        @Override
        public final Builder piiEntitiesDetectionJobPropertiesList(
                Collection<PiiEntitiesDetectionJobProperties> piiEntitiesDetectionJobPropertiesList) {
            this.piiEntitiesDetectionJobPropertiesList = PiiEntitiesDetectionJobPropertiesListCopier
                    .copy(piiEntitiesDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntitiesDetectionJobPropertiesList(
                PiiEntitiesDetectionJobProperties... piiEntitiesDetectionJobPropertiesList) {
            piiEntitiesDetectionJobPropertiesList(Arrays.asList(piiEntitiesDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntitiesDetectionJobPropertiesList(
                Consumer<PiiEntitiesDetectionJobProperties.Builder>... piiEntitiesDetectionJobPropertiesList) {
            piiEntitiesDetectionJobPropertiesList(Stream.of(piiEntitiesDetectionJobPropertiesList)
                    .map(c -> PiiEntitiesDetectionJobProperties.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPiiEntitiesDetectionJobsResponse build() {
            return new ListPiiEntitiesDetectionJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
