/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectDominantLanguageResponse extends ComprehendResponse implements
        ToCopyableBuilder<DetectDominantLanguageResponse.Builder, DetectDominantLanguageResponse> {
    private static final SdkField<List<DominantLanguage>> LANGUAGES_FIELD = SdkField
            .<List<DominantLanguage>> builder(MarshallingType.LIST)
            .memberName("Languages")
            .getter(getter(DetectDominantLanguageResponse::languages))
            .setter(setter(Builder::languages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Languages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DominantLanguage> builder(MarshallingType.SDK_POJO)
                                            .constructor(DominantLanguage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DominantLanguage> languages;

    private DetectDominantLanguageResponse(BuilderImpl builder) {
        super(builder);
        this.languages = builder.languages;
    }

    /**
     * For responses, this returns true if the service returned a value for the Languages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLanguages() {
        return languages != null && !(languages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of languages that Amazon Comprehend detected in the input text. The array is sorted in descending order of
     * the score (the dominant language is always the first element in the array).
     * </p>
     * <p>
     * For each language, the response returns the RFC 5646 language code and the level of confidence that Amazon
     * Comprehend has in the accuracy of its inference. For more information about RFC 5646, see <a
     * href="https://tools.ietf.org/html/rfc5646">Tags for Identifying Languages</a> on the <i>IETF Tools</i> web site.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLanguages} method.
     * </p>
     * 
     * @return Array of languages that Amazon Comprehend detected in the input text. The array is sorted in descending
     *         order of the score (the dominant language is always the first element in the array).</p>
     *         <p>
     *         For each language, the response returns the RFC 5646 language code and the level of confidence that
     *         Amazon Comprehend has in the accuracy of its inference. For more information about RFC 5646, see <a
     *         href="https://tools.ietf.org/html/rfc5646">Tags for Identifying Languages</a> on the <i>IETF Tools</i>
     *         web site.
     */
    public final List<DominantLanguage> languages() {
        return languages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLanguages() ? languages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectDominantLanguageResponse)) {
            return false;
        }
        DetectDominantLanguageResponse other = (DetectDominantLanguageResponse) obj;
        return hasLanguages() == other.hasLanguages() && Objects.equals(languages(), other.languages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectDominantLanguageResponse").add("Languages", hasLanguages() ? languages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Languages":
            return Optional.ofNullable(clazz.cast(languages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Languages", LANGUAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectDominantLanguageResponse, T> g) {
        return obj -> g.apply((DetectDominantLanguageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DetectDominantLanguageResponse> {
        /**
         * <p>
         * Array of languages that Amazon Comprehend detected in the input text. The array is sorted in descending order
         * of the score (the dominant language is always the first element in the array).
         * </p>
         * <p>
         * For each language, the response returns the RFC 5646 language code and the level of confidence that Amazon
         * Comprehend has in the accuracy of its inference. For more information about RFC 5646, see <a
         * href="https://tools.ietf.org/html/rfc5646">Tags for Identifying Languages</a> on the <i>IETF Tools</i> web
         * site.
         * </p>
         * 
         * @param languages
         *        Array of languages that Amazon Comprehend detected in the input text. The array is sorted in
         *        descending order of the score (the dominant language is always the first element in the array).</p>
         *        <p>
         *        For each language, the response returns the RFC 5646 language code and the level of confidence that
         *        Amazon Comprehend has in the accuracy of its inference. For more information about RFC 5646, see <a
         *        href="https://tools.ietf.org/html/rfc5646">Tags for Identifying Languages</a> on the <i>IETF Tools</i>
         *        web site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languages(Collection<DominantLanguage> languages);

        /**
         * <p>
         * Array of languages that Amazon Comprehend detected in the input text. The array is sorted in descending order
         * of the score (the dominant language is always the first element in the array).
         * </p>
         * <p>
         * For each language, the response returns the RFC 5646 language code and the level of confidence that Amazon
         * Comprehend has in the accuracy of its inference. For more information about RFC 5646, see <a
         * href="https://tools.ietf.org/html/rfc5646">Tags for Identifying Languages</a> on the <i>IETF Tools</i> web
         * site.
         * </p>
         * 
         * @param languages
         *        Array of languages that Amazon Comprehend detected in the input text. The array is sorted in
         *        descending order of the score (the dominant language is always the first element in the array).</p>
         *        <p>
         *        For each language, the response returns the RFC 5646 language code and the level of confidence that
         *        Amazon Comprehend has in the accuracy of its inference. For more information about RFC 5646, see <a
         *        href="https://tools.ietf.org/html/rfc5646">Tags for Identifying Languages</a> on the <i>IETF Tools</i>
         *        web site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languages(DominantLanguage... languages);

        /**
         * <p>
         * Array of languages that Amazon Comprehend detected in the input text. The array is sorted in descending order
         * of the score (the dominant language is always the first element in the array).
         * </p>
         * <p>
         * For each language, the response returns the RFC 5646 language code and the level of confidence that Amazon
         * Comprehend has in the accuracy of its inference. For more information about RFC 5646, see <a
         * href="https://tools.ietf.org/html/rfc5646">Tags for Identifying Languages</a> on the <i>IETF Tools</i> web
         * site.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.DominantLanguage.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.comprehend.model.DominantLanguage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.DominantLanguage.Builder#build()} is called
         * immediately and its result is passed to {@link #languages(List<DominantLanguage>)}.
         * 
         * @param languages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.DominantLanguage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #languages(java.util.Collection<DominantLanguage>)
         */
        Builder languages(Consumer<DominantLanguage.Builder>... languages);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<DominantLanguage> languages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectDominantLanguageResponse model) {
            super(model);
            languages(model.languages);
        }

        public final List<DominantLanguage.Builder> getLanguages() {
            List<DominantLanguage.Builder> result = ListOfDominantLanguagesCopier.copyToBuilder(this.languages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLanguages(Collection<DominantLanguage.BuilderImpl> languages) {
            this.languages = ListOfDominantLanguagesCopier.copyFromBuilder(languages);
        }

        @Override
        public final Builder languages(Collection<DominantLanguage> languages) {
            this.languages = ListOfDominantLanguagesCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(DominantLanguage... languages) {
            languages(Arrays.asList(languages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(Consumer<DominantLanguage.Builder>... languages) {
            languages(Stream.of(languages).map(c -> DominantLanguage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectDominantLanguageResponse build() {
            return new DetectDominantLanguageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
