/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.TargetedSentimentDetectionJobProperties;
import software.amazon.awssdk.services.comprehend.model.TargetedSentimentDetectionJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTargetedSentimentDetectionJobsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListTargetedSentimentDetectionJobsResponse> {
    private static final SdkField<List<TargetedSentimentDetectionJobProperties>> TARGETED_SENTIMENT_DETECTION_JOB_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetedSentimentDetectionJobPropertiesList").getter(ListTargetedSentimentDetectionJobsResponse.getter(ListTargetedSentimentDetectionJobsResponse::targetedSentimentDetectionJobPropertiesList)).setter(ListTargetedSentimentDetectionJobsResponse.setter(Builder::targetedSentimentDetectionJobPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetedSentimentDetectionJobPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetedSentimentDetectionJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTargetedSentimentDetectionJobsResponse.getter(ListTargetedSentimentDetectionJobsResponse::nextToken)).setter(ListTargetedSentimentDetectionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGETED_SENTIMENT_DETECTION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTargetedSentimentDetectionJobsResponse.memberNameToFieldInitializer();
    private final List<TargetedSentimentDetectionJobProperties> targetedSentimentDetectionJobPropertiesList;
    private final String nextToken;

    private ListTargetedSentimentDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.targetedSentimentDetectionJobPropertiesList = builder.targetedSentimentDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTargetedSentimentDetectionJobPropertiesList() {
        return this.targetedSentimentDetectionJobPropertiesList != null && !(this.targetedSentimentDetectionJobPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<TargetedSentimentDetectionJobProperties> targetedSentimentDetectionJobPropertiesList() {
        return this.targetedSentimentDetectionJobPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetedSentimentDetectionJobPropertiesList() ? this.targetedSentimentDetectionJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetedSentimentDetectionJobsResponse)) {
            return false;
        }
        ListTargetedSentimentDetectionJobsResponse other = (ListTargetedSentimentDetectionJobsResponse)((Object)obj);
        return this.hasTargetedSentimentDetectionJobPropertiesList() == other.hasTargetedSentimentDetectionJobPropertiesList() && Objects.equals(this.targetedSentimentDetectionJobPropertiesList(), other.targetedSentimentDetectionJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTargetedSentimentDetectionJobsResponse").add("TargetedSentimentDetectionJobPropertiesList", this.hasTargetedSentimentDetectionJobPropertiesList() ? this.targetedSentimentDetectionJobPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetedSentimentDetectionJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.targetedSentimentDetectionJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetedSentimentDetectionJobPropertiesList", TARGETED_SENTIMENT_DETECTION_JOB_PROPERTIES_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTargetedSentimentDetectionJobsResponse, T> g) {
        return obj -> g.apply((ListTargetedSentimentDetectionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<TargetedSentimentDetectionJobProperties> targetedSentimentDetectionJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetedSentimentDetectionJobsResponse model) {
            super(model);
            this.targetedSentimentDetectionJobPropertiesList(model.targetedSentimentDetectionJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<TargetedSentimentDetectionJobProperties.Builder> getTargetedSentimentDetectionJobPropertiesList() {
            List<TargetedSentimentDetectionJobProperties.Builder> result = TargetedSentimentDetectionJobPropertiesListCopier.copyToBuilder(this.targetedSentimentDetectionJobPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetedSentimentDetectionJobPropertiesList(Collection<TargetedSentimentDetectionJobProperties.BuilderImpl> targetedSentimentDetectionJobPropertiesList) {
            this.targetedSentimentDetectionJobPropertiesList = TargetedSentimentDetectionJobPropertiesListCopier.copyFromBuilder(targetedSentimentDetectionJobPropertiesList);
        }

        @Override
        public final Builder targetedSentimentDetectionJobPropertiesList(Collection<TargetedSentimentDetectionJobProperties> targetedSentimentDetectionJobPropertiesList) {
            this.targetedSentimentDetectionJobPropertiesList = TargetedSentimentDetectionJobPropertiesListCopier.copy(targetedSentimentDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetedSentimentDetectionJobPropertiesList(TargetedSentimentDetectionJobProperties ... targetedSentimentDetectionJobPropertiesList) {
            this.targetedSentimentDetectionJobPropertiesList(Arrays.asList(targetedSentimentDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetedSentimentDetectionJobPropertiesList(Consumer<TargetedSentimentDetectionJobProperties.Builder> ... targetedSentimentDetectionJobPropertiesList) {
            this.targetedSentimentDetectionJobPropertiesList(Stream.of(targetedSentimentDetectionJobPropertiesList).map(c -> (TargetedSentimentDetectionJobProperties)((TargetedSentimentDetectionJobProperties.Builder)TargetedSentimentDetectionJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTargetedSentimentDetectionJobsResponse build() {
            return new ListTargetedSentimentDetectionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTargetedSentimentDetectionJobsResponse> {
        public Builder targetedSentimentDetectionJobPropertiesList(Collection<TargetedSentimentDetectionJobProperties> var1);

        public Builder targetedSentimentDetectionJobPropertiesList(TargetedSentimentDetectionJobProperties ... var1);

        public Builder targetedSentimentDetectionJobPropertiesList(Consumer<TargetedSentimentDetectionJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

