/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.PageBasedWarningCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WarningsListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WarningsListItem> {
    private static final SdkField<Integer> PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Page").getter(WarningsListItem.getter(WarningsListItem::page)).setter(WarningsListItem.setter(Builder::page)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Page").build()}).build();
    private static final SdkField<String> WARN_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WarnCode").getter(WarningsListItem.getter(WarningsListItem::warnCodeAsString)).setter(WarningsListItem.setter(Builder::warnCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarnCode").build()}).build();
    private static final SdkField<String> WARN_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WarnMessage").getter(WarningsListItem.getter(WarningsListItem::warnMessage)).setter(WarningsListItem.setter(Builder::warnMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarnMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_FIELD, WARN_CODE_FIELD, WARN_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WarningsListItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer page;
    private final String warnCode;
    private final String warnMessage;

    private WarningsListItem(BuilderImpl builder) {
        this.page = builder.page;
        this.warnCode = builder.warnCode;
        this.warnMessage = builder.warnMessage;
    }

    public final Integer page() {
        return this.page;
    }

    public final PageBasedWarningCode warnCode() {
        return PageBasedWarningCode.fromValue(this.warnCode);
    }

    public final String warnCodeAsString() {
        return this.warnCode;
    }

    public final String warnMessage() {
        return this.warnMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.page());
        hashCode = 31 * hashCode + Objects.hashCode(this.warnCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.warnMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WarningsListItem)) {
            return false;
        }
        WarningsListItem other = (WarningsListItem)obj;
        return Objects.equals(this.page(), other.page()) && Objects.equals(this.warnCodeAsString(), other.warnCodeAsString()) && Objects.equals(this.warnMessage(), other.warnMessage());
    }

    public final String toString() {
        return ToString.builder((String)"WarningsListItem").add("Page", (Object)this.page()).add("WarnCode", (Object)this.warnCodeAsString()).add("WarnMessage", (Object)this.warnMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Page": {
                return Optional.ofNullable(clazz.cast(this.page()));
            }
            case "WarnCode": {
                return Optional.ofNullable(clazz.cast(this.warnCodeAsString()));
            }
            case "WarnMessage": {
                return Optional.ofNullable(clazz.cast(this.warnMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Page", PAGE_FIELD);
        map.put("WarnCode", WARN_CODE_FIELD);
        map.put("WarnMessage", WARN_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WarningsListItem, T> g) {
        return obj -> g.apply((WarningsListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer page;
        private String warnCode;
        private String warnMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(WarningsListItem model) {
            this.page(model.page);
            this.warnCode(model.warnCode);
            this.warnMessage(model.warnMessage);
        }

        public final Integer getPage() {
            return this.page;
        }

        public final void setPage(Integer page) {
            this.page = page;
        }

        @Override
        public final Builder page(Integer page) {
            this.page = page;
            return this;
        }

        public final String getWarnCode() {
            return this.warnCode;
        }

        public final void setWarnCode(String warnCode) {
            this.warnCode = warnCode;
        }

        @Override
        public final Builder warnCode(String warnCode) {
            this.warnCode = warnCode;
            return this;
        }

        @Override
        public final Builder warnCode(PageBasedWarningCode warnCode) {
            this.warnCode(warnCode == null ? null : warnCode.toString());
            return this;
        }

        public final String getWarnMessage() {
            return this.warnMessage;
        }

        public final void setWarnMessage(String warnMessage) {
            this.warnMessage = warnMessage;
        }

        @Override
        public final Builder warnMessage(String warnMessage) {
            this.warnMessage = warnMessage;
            return this;
        }

        public WarningsListItem build() {
            return new WarningsListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WarningsListItem> {
        public Builder page(Integer var1);

        public Builder warnCode(String var1);

        public Builder warnCode(PageBasedWarningCode var1);

        public Builder warnMessage(String var1);
    }
}

