/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlywheelModelEvaluationMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlywheelModelEvaluationMetrics> {
    private static final SdkField<Double> AVERAGE_F1_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AverageF1Score").getter(FlywheelModelEvaluationMetrics.getter(FlywheelModelEvaluationMetrics::averageF1Score)).setter(FlywheelModelEvaluationMetrics.setter(Builder::averageF1Score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageF1Score").build()}).build();
    private static final SdkField<Double> AVERAGE_PRECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AveragePrecision").getter(FlywheelModelEvaluationMetrics.getter(FlywheelModelEvaluationMetrics::averagePrecision)).setter(FlywheelModelEvaluationMetrics.setter(Builder::averagePrecision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AveragePrecision").build()}).build();
    private static final SdkField<Double> AVERAGE_RECALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AverageRecall").getter(FlywheelModelEvaluationMetrics.getter(FlywheelModelEvaluationMetrics::averageRecall)).setter(FlywheelModelEvaluationMetrics.setter(Builder::averageRecall)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageRecall").build()}).build();
    private static final SdkField<Double> AVERAGE_ACCURACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AverageAccuracy").getter(FlywheelModelEvaluationMetrics.getter(FlywheelModelEvaluationMetrics::averageAccuracy)).setter(FlywheelModelEvaluationMetrics.setter(Builder::averageAccuracy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageAccuracy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVERAGE_F1_SCORE_FIELD, AVERAGE_PRECISION_FIELD, AVERAGE_RECALL_FIELD, AVERAGE_ACCURACY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AverageF1Score", AVERAGE_F1_SCORE_FIELD);
            this.put("AveragePrecision", AVERAGE_PRECISION_FIELD);
            this.put("AverageRecall", AVERAGE_RECALL_FIELD);
            this.put("AverageAccuracy", AVERAGE_ACCURACY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double averageF1Score;
    private final Double averagePrecision;
    private final Double averageRecall;
    private final Double averageAccuracy;

    private FlywheelModelEvaluationMetrics(BuilderImpl builder) {
        this.averageF1Score = builder.averageF1Score;
        this.averagePrecision = builder.averagePrecision;
        this.averageRecall = builder.averageRecall;
        this.averageAccuracy = builder.averageAccuracy;
    }

    public final Double averageF1Score() {
        return this.averageF1Score;
    }

    public final Double averagePrecision() {
        return this.averagePrecision;
    }

    public final Double averageRecall() {
        return this.averageRecall;
    }

    public final Double averageAccuracy() {
        return this.averageAccuracy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.averageF1Score());
        hashCode = 31 * hashCode + Objects.hashCode(this.averagePrecision());
        hashCode = 31 * hashCode + Objects.hashCode(this.averageRecall());
        hashCode = 31 * hashCode + Objects.hashCode(this.averageAccuracy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlywheelModelEvaluationMetrics)) {
            return false;
        }
        FlywheelModelEvaluationMetrics other = (FlywheelModelEvaluationMetrics)obj;
        return Objects.equals(this.averageF1Score(), other.averageF1Score()) && Objects.equals(this.averagePrecision(), other.averagePrecision()) && Objects.equals(this.averageRecall(), other.averageRecall()) && Objects.equals(this.averageAccuracy(), other.averageAccuracy());
    }

    public final String toString() {
        return ToString.builder((String)"FlywheelModelEvaluationMetrics").add("AverageF1Score", (Object)this.averageF1Score()).add("AveragePrecision", (Object)this.averagePrecision()).add("AverageRecall", (Object)this.averageRecall()).add("AverageAccuracy", (Object)this.averageAccuracy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AverageF1Score": {
                return Optional.ofNullable(clazz.cast(this.averageF1Score()));
            }
            case "AveragePrecision": {
                return Optional.ofNullable(clazz.cast(this.averagePrecision()));
            }
            case "AverageRecall": {
                return Optional.ofNullable(clazz.cast(this.averageRecall()));
            }
            case "AverageAccuracy": {
                return Optional.ofNullable(clazz.cast(this.averageAccuracy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FlywheelModelEvaluationMetrics, T> g) {
        return obj -> g.apply((FlywheelModelEvaluationMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double averageF1Score;
        private Double averagePrecision;
        private Double averageRecall;
        private Double averageAccuracy;

        private BuilderImpl() {
        }

        private BuilderImpl(FlywheelModelEvaluationMetrics model) {
            this.averageF1Score(model.averageF1Score);
            this.averagePrecision(model.averagePrecision);
            this.averageRecall(model.averageRecall);
            this.averageAccuracy(model.averageAccuracy);
        }

        public final Double getAverageF1Score() {
            return this.averageF1Score;
        }

        public final void setAverageF1Score(Double averageF1Score) {
            this.averageF1Score = averageF1Score;
        }

        @Override
        public final Builder averageF1Score(Double averageF1Score) {
            this.averageF1Score = averageF1Score;
            return this;
        }

        public final Double getAveragePrecision() {
            return this.averagePrecision;
        }

        public final void setAveragePrecision(Double averagePrecision) {
            this.averagePrecision = averagePrecision;
        }

        @Override
        public final Builder averagePrecision(Double averagePrecision) {
            this.averagePrecision = averagePrecision;
            return this;
        }

        public final Double getAverageRecall() {
            return this.averageRecall;
        }

        public final void setAverageRecall(Double averageRecall) {
            this.averageRecall = averageRecall;
        }

        @Override
        public final Builder averageRecall(Double averageRecall) {
            this.averageRecall = averageRecall;
            return this;
        }

        public final Double getAverageAccuracy() {
            return this.averageAccuracy;
        }

        public final void setAverageAccuracy(Double averageAccuracy) {
            this.averageAccuracy = averageAccuracy;
        }

        @Override
        public final Builder averageAccuracy(Double averageAccuracy) {
            this.averageAccuracy = averageAccuracy;
            return this;
        }

        public FlywheelModelEvaluationMetrics build() {
            return new FlywheelModelEvaluationMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlywheelModelEvaluationMetrics> {
        public Builder averageF1Score(Double var1);

        public Builder averagePrecision(Double var1);

        public Builder averageRecall(Double var1);

        public Builder averageAccuracy(Double var1);
    }
}

