/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ChildBlock;
import software.amazon.awssdk.services.comprehend.model.ListOfChildBlocksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlockReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlockReference> {
    private static final SdkField<String> BLOCK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlockId").getter(BlockReference.getter(BlockReference::blockId)).setter(BlockReference.setter(Builder::blockId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockId").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BeginOffset").getter(BlockReference.getter(BlockReference::beginOffset)).setter(BlockReference.setter(Builder::beginOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndOffset").getter(BlockReference.getter(BlockReference::endOffset)).setter(BlockReference.setter(Builder::endOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final SdkField<List<ChildBlock>> CHILD_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChildBlocks").getter(BlockReference.getter(BlockReference::childBlocks)).setter(BlockReference.setter(Builder::childBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChildBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_ID_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, CHILD_BLOCKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BlockId", BLOCK_ID_FIELD);
            this.put("BeginOffset", BEGIN_OFFSET_FIELD);
            this.put("EndOffset", END_OFFSET_FIELD);
            this.put("ChildBlocks", CHILD_BLOCKS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String blockId;
    private final Integer beginOffset;
    private final Integer endOffset;
    private final List<ChildBlock> childBlocks;

    private BlockReference(BuilderImpl builder) {
        this.blockId = builder.blockId;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.childBlocks = builder.childBlocks;
    }

    public final String blockId() {
        return this.blockId;
    }

    public final Integer beginOffset() {
        return this.beginOffset;
    }

    public final Integer endOffset() {
        return this.endOffset;
    }

    public final boolean hasChildBlocks() {
        return this.childBlocks != null && !(this.childBlocks instanceof SdkAutoConstructList);
    }

    public final List<ChildBlock> childBlocks() {
        return this.childBlocks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blockId());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildBlocks() ? this.childBlocks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockReference)) {
            return false;
        }
        BlockReference other = (BlockReference)obj;
        return Objects.equals(this.blockId(), other.blockId()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset()) && this.hasChildBlocks() == other.hasChildBlocks() && Objects.equals(this.childBlocks(), other.childBlocks());
    }

    public final String toString() {
        return ToString.builder((String)"BlockReference").add("BlockId", (Object)this.blockId()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).add("ChildBlocks", this.hasChildBlocks() ? this.childBlocks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockId": {
                return Optional.ofNullable(clazz.cast(this.blockId()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
            case "ChildBlocks": {
                return Optional.ofNullable(clazz.cast(this.childBlocks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BlockReference, T> g) {
        return obj -> g.apply((BlockReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blockId;
        private Integer beginOffset;
        private Integer endOffset;
        private List<ChildBlock> childBlocks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BlockReference model) {
            this.blockId(model.blockId);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
            this.childBlocks(model.childBlocks);
        }

        public final String getBlockId() {
            return this.blockId;
        }

        public final void setBlockId(String blockId) {
            this.blockId = blockId;
        }

        @Override
        public final Builder blockId(String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final List<ChildBlock.Builder> getChildBlocks() {
            List<ChildBlock.Builder> result = ListOfChildBlocksCopier.copyToBuilder(this.childBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildBlocks(Collection<ChildBlock.BuilderImpl> childBlocks) {
            this.childBlocks = ListOfChildBlocksCopier.copyFromBuilder(childBlocks);
        }

        @Override
        public final Builder childBlocks(Collection<ChildBlock> childBlocks) {
            this.childBlocks = ListOfChildBlocksCopier.copy(childBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childBlocks(ChildBlock ... childBlocks) {
            this.childBlocks(Arrays.asList(childBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childBlocks(Consumer<ChildBlock.Builder> ... childBlocks) {
            this.childBlocks(Stream.of(childBlocks).map(c -> (ChildBlock)((ChildBlock.Builder)ChildBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BlockReference build() {
            return new BlockReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlockReference> {
        public Builder blockId(String var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);

        public Builder childBlocks(Collection<ChildBlock> var1);

        public Builder childBlocks(ChildBlock ... var1);

        public Builder childBlocks(Consumer<ChildBlock.Builder> ... var1);
    }
}

