/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ClassifierEvaluationMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClassifierMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClassifierMetadata> {
    private static final SdkField<Integer> NUMBER_OF_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfLabels").getter(ClassifierMetadata.getter(ClassifierMetadata::numberOfLabels)).setter(ClassifierMetadata.setter(Builder::numberOfLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfLabels").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_TRAINED_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfTrainedDocuments").getter(ClassifierMetadata.getter(ClassifierMetadata::numberOfTrainedDocuments)).setter(ClassifierMetadata.setter(Builder::numberOfTrainedDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTrainedDocuments").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_TEST_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfTestDocuments").getter(ClassifierMetadata.getter(ClassifierMetadata::numberOfTestDocuments)).setter(ClassifierMetadata.setter(Builder::numberOfTestDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTestDocuments").build()}).build();
    private static final SdkField<ClassifierEvaluationMetrics> EVALUATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationMetrics").getter(ClassifierMetadata.getter(ClassifierMetadata::evaluationMetrics)).setter(ClassifierMetadata.setter(Builder::evaluationMetrics)).constructor(ClassifierEvaluationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_LABELS_FIELD, NUMBER_OF_TRAINED_DOCUMENTS_FIELD, NUMBER_OF_TEST_DOCUMENTS_FIELD, EVALUATION_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NumberOfLabels", NUMBER_OF_LABELS_FIELD);
            this.put("NumberOfTrainedDocuments", NUMBER_OF_TRAINED_DOCUMENTS_FIELD);
            this.put("NumberOfTestDocuments", NUMBER_OF_TEST_DOCUMENTS_FIELD);
            this.put("EvaluationMetrics", EVALUATION_METRICS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer numberOfLabels;
    private final Integer numberOfTrainedDocuments;
    private final Integer numberOfTestDocuments;
    private final ClassifierEvaluationMetrics evaluationMetrics;

    private ClassifierMetadata(BuilderImpl builder) {
        this.numberOfLabels = builder.numberOfLabels;
        this.numberOfTrainedDocuments = builder.numberOfTrainedDocuments;
        this.numberOfTestDocuments = builder.numberOfTestDocuments;
        this.evaluationMetrics = builder.evaluationMetrics;
    }

    public final Integer numberOfLabels() {
        return this.numberOfLabels;
    }

    public final Integer numberOfTrainedDocuments() {
        return this.numberOfTrainedDocuments;
    }

    public final Integer numberOfTestDocuments() {
        return this.numberOfTestDocuments;
    }

    public final ClassifierEvaluationMetrics evaluationMetrics() {
        return this.evaluationMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfTrainedDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfTestDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationMetrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassifierMetadata)) {
            return false;
        }
        ClassifierMetadata other = (ClassifierMetadata)obj;
        return Objects.equals(this.numberOfLabels(), other.numberOfLabels()) && Objects.equals(this.numberOfTrainedDocuments(), other.numberOfTrainedDocuments()) && Objects.equals(this.numberOfTestDocuments(), other.numberOfTestDocuments()) && Objects.equals(this.evaluationMetrics(), other.evaluationMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"ClassifierMetadata").add("NumberOfLabels", (Object)this.numberOfLabels()).add("NumberOfTrainedDocuments", (Object)this.numberOfTrainedDocuments()).add("NumberOfTestDocuments", (Object)this.numberOfTestDocuments()).add("EvaluationMetrics", (Object)this.evaluationMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfLabels": {
                return Optional.ofNullable(clazz.cast(this.numberOfLabels()));
            }
            case "NumberOfTrainedDocuments": {
                return Optional.ofNullable(clazz.cast(this.numberOfTrainedDocuments()));
            }
            case "NumberOfTestDocuments": {
                return Optional.ofNullable(clazz.cast(this.numberOfTestDocuments()));
            }
            case "EvaluationMetrics": {
                return Optional.ofNullable(clazz.cast(this.evaluationMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClassifierMetadata, T> g) {
        return obj -> g.apply((ClassifierMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer numberOfLabels;
        private Integer numberOfTrainedDocuments;
        private Integer numberOfTestDocuments;
        private ClassifierEvaluationMetrics evaluationMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassifierMetadata model) {
            this.numberOfLabels(model.numberOfLabels);
            this.numberOfTrainedDocuments(model.numberOfTrainedDocuments);
            this.numberOfTestDocuments(model.numberOfTestDocuments);
            this.evaluationMetrics(model.evaluationMetrics);
        }

        public final Integer getNumberOfLabels() {
            return this.numberOfLabels;
        }

        public final void setNumberOfLabels(Integer numberOfLabels) {
            this.numberOfLabels = numberOfLabels;
        }

        @Override
        public final Builder numberOfLabels(Integer numberOfLabels) {
            this.numberOfLabels = numberOfLabels;
            return this;
        }

        public final Integer getNumberOfTrainedDocuments() {
            return this.numberOfTrainedDocuments;
        }

        public final void setNumberOfTrainedDocuments(Integer numberOfTrainedDocuments) {
            this.numberOfTrainedDocuments = numberOfTrainedDocuments;
        }

        @Override
        public final Builder numberOfTrainedDocuments(Integer numberOfTrainedDocuments) {
            this.numberOfTrainedDocuments = numberOfTrainedDocuments;
            return this;
        }

        public final Integer getNumberOfTestDocuments() {
            return this.numberOfTestDocuments;
        }

        public final void setNumberOfTestDocuments(Integer numberOfTestDocuments) {
            this.numberOfTestDocuments = numberOfTestDocuments;
        }

        @Override
        public final Builder numberOfTestDocuments(Integer numberOfTestDocuments) {
            this.numberOfTestDocuments = numberOfTestDocuments;
            return this;
        }

        public final ClassifierEvaluationMetrics.Builder getEvaluationMetrics() {
            return this.evaluationMetrics != null ? this.evaluationMetrics.toBuilder() : null;
        }

        public final void setEvaluationMetrics(ClassifierEvaluationMetrics.BuilderImpl evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics != null ? evaluationMetrics.build() : null;
        }

        @Override
        public final Builder evaluationMetrics(ClassifierEvaluationMetrics evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics;
            return this;
        }

        public ClassifierMetadata build() {
            return new ClassifierMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClassifierMetadata> {
        public Builder numberOfLabels(Integer var1);

        public Builder numberOfTrainedDocuments(Integer var1);

        public Builder numberOfTestDocuments(Integer var1);

        public Builder evaluationMetrics(ClassifierEvaluationMetrics var1);

        default public Builder evaluationMetrics(Consumer<ClassifierEvaluationMetrics.Builder> evaluationMetrics) {
            return this.evaluationMetrics((ClassifierEvaluationMetrics)((ClassifierEvaluationMetrics.Builder)ClassifierEvaluationMetrics.builder().applyMutation(evaluationMetrics)).build());
        }
    }
}

